/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_1;

import io.fabric8.kubernetes.api.builder.v5_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_1.Nested;
import io.fabric8.kubernetes.api.model.v5_1.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_1.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v5_1.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v5_1.PodAffinityTerm;
import io.fabric8.kubernetes.api.model.v5_1.PodAffinityTermFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PodAffinityTermFluentImpl<A extends PodAffinityTermFluent<A>>
extends BaseFluent<A>
implements PodAffinityTermFluent<A> {
    private LabelSelectorBuilder labelSelector;
    private List<String> namespaces = new ArrayList<String>();
    private String topologyKey;

    public PodAffinityTermFluentImpl() {
    }

    public PodAffinityTermFluentImpl(PodAffinityTerm instance) {
        this.withLabelSelector(instance.getLabelSelector());
        this.withNamespaces(instance.getNamespaces());
        this.withTopologyKey(instance.getTopologyKey());
    }

    @Override
    @Deprecated
    public LabelSelector getLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public LabelSelector buildLabelSelector() {
        return this.labelSelector != null ? this.labelSelector.build() : null;
    }

    @Override
    public A withLabelSelector(LabelSelector labelSelector) {
        this._visitables.get("labelSelector").remove(this.labelSelector);
        if (labelSelector != null) {
            this.labelSelector = new LabelSelectorBuilder(labelSelector);
            this._visitables.get("labelSelector").add(this.labelSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLabelSelector() {
        return this.labelSelector != null;
    }

    @Override
    public PodAffinityTermFluent.LabelSelectorNested<A> withNewLabelSelector() {
        return new LabelSelectorNestedImpl();
    }

    @Override
    public PodAffinityTermFluent.LabelSelectorNested<A> withNewLabelSelectorLike(LabelSelector item) {
        return new LabelSelectorNestedImpl(item);
    }

    @Override
    public PodAffinityTermFluent.LabelSelectorNested<A> editLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector());
    }

    @Override
    public PodAffinityTermFluent.LabelSelectorNested<A> editOrNewLabelSelector() {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public PodAffinityTermFluent.LabelSelectorNested<A> editOrNewLabelSelectorLike(LabelSelector item) {
        return this.withNewLabelSelectorLike(this.getLabelSelector() != null ? this.getLabelSelector() : item);
    }

    @Override
    public A addToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNamespaces(String ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNamespaces(String ... items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    @Override
    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    @Override
    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    @Override
    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNamespaces(List<String> namespaces) {
        if (this.namespaces != null) {
            this._visitables.get("namespaces").removeAll(this.namespaces);
        }
        if (namespaces != null) {
            this.namespaces = new ArrayList<String>();
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)this;
    }

    @Override
    public A withNamespaces(String ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
        }
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    @Override
    public A addNewNamespace(String arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    public A addNewNamespace(StringBuilder arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    public A addNewNamespace(StringBuffer arg1) {
        return this.addToNamespaces(new String(arg1));
    }

    @Override
    public String getTopologyKey() {
        return this.topologyKey;
    }

    @Override
    public A withTopologyKey(String topologyKey) {
        this.topologyKey = topologyKey;
        return (A)this;
    }

    @Override
    public Boolean hasTopologyKey() {
        return this.topologyKey != null;
    }

    @Override
    public A withNewTopologyKey(String arg1) {
        return this.withTopologyKey(new String(arg1));
    }

    @Override
    public A withNewTopologyKey(StringBuilder arg1) {
        return this.withTopologyKey(new String(arg1));
    }

    @Override
    public A withNewTopologyKey(StringBuffer arg1) {
        return this.withTopologyKey(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodAffinityTermFluentImpl that = (PodAffinityTermFluentImpl)o;
        if (this.labelSelector != null ? !this.labelSelector.equals(that.labelSelector) : that.labelSelector != null) {
            return false;
        }
        if (this.namespaces != null ? !this.namespaces.equals(that.namespaces) : that.namespaces != null) {
            return false;
        }
        return !(this.topologyKey != null ? !this.topologyKey.equals(that.topologyKey) : that.topologyKey != null);
    }

    public int hashCode() {
        return Objects.hash(this.labelSelector, this.namespaces, this.topologyKey, super.hashCode());
    }

    public class LabelSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<PodAffinityTermFluent.LabelSelectorNested<N>>
    implements PodAffinityTermFluent.LabelSelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        LabelSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        LabelSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodAffinityTermFluentImpl.this.withLabelSelector(this.builder.build());
        }

        @Override
        public N endLabelSelector() {
            return this.and();
        }
    }
}

