/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_1;

import io.fabric8.kubernetes.api.builder.v5_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_1.ServiceStatus;
import io.fabric8.kubernetes.api.model.v5_1.ServiceStatusFluent;
import io.fabric8.kubernetes.api.model.v5_1.ServiceStatusFluentImpl;
import java.util.Objects;

public class ServiceStatusBuilder
extends ServiceStatusFluentImpl<ServiceStatusBuilder>
implements VisitableBuilder<ServiceStatus, ServiceStatusBuilder> {
    ServiceStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceStatusBuilder() {
        this(true);
    }

    public ServiceStatusBuilder(Boolean validationEnabled) {
        this(new ServiceStatus(), validationEnabled);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceStatus(), validationEnabled);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, ServiceStatus instance) {
        this(fluent, instance, true);
    }

    public ServiceStatusBuilder(ServiceStatusFluent<?> fluent, ServiceStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withConditions(instance.getConditions());
        fluent.withLoadBalancer(instance.getLoadBalancer());
        this.validationEnabled = validationEnabled;
    }

    public ServiceStatusBuilder(ServiceStatus instance) {
        this(instance, (Boolean)true);
    }

    public ServiceStatusBuilder(ServiceStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withConditions(instance.getConditions());
        this.withLoadBalancer(instance.getLoadBalancer());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ServiceStatus build() {
        ServiceStatus buildable = new ServiceStatus(this.fluent.getConditions(), this.fluent.getLoadBalancer());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceStatusBuilder that = (ServiceStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

