/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_1.apps;

import io.fabric8.kubernetes.api.builder.v5_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_1.Nested;
import io.fabric8.kubernetes.api.builder.v5_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_1.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_1.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_1.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_1.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v5_1.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v5_1.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.v5_1.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.v5_1.apps.ControllerRevision;
import io.fabric8.kubernetes.api.model.v5_1.apps.ControllerRevisionBuilder;
import io.fabric8.kubernetes.api.model.v5_1.apps.ControllerRevisionFluent;
import io.fabric8.kubernetes.api.model.v5_1.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.v5_1.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.v5_1.apps.DaemonSetFluentImpl;
import io.fabric8.kubernetes.api.model.v5_1.apps.Deployment;
import io.fabric8.kubernetes.api.model.v5_1.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.v5_1.apps.DeploymentFluentImpl;
import io.fabric8.kubernetes.api.model.v5_1.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.v5_1.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.v5_1.apps.ReplicaSetFluentImpl;
import io.fabric8.kubernetes.api.model.v5_1.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.v5_1.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.v5_1.apps.StatefulSetFluentImpl;
import java.util.Objects;

public class ControllerRevisionFluentImpl<A extends ControllerRevisionFluent<A>>
extends BaseFluent<A>
implements ControllerRevisionFluent<A> {
    private String apiVersion;
    private VisitableBuilder<? extends HasMetadata, ?> data;
    private String kind;
    private ObjectMetaBuilder metadata;
    private Long revision;

    public ControllerRevisionFluentImpl() {
    }

    public ControllerRevisionFluentImpl(ControllerRevision instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withData(instance.getData());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRevision(instance.getRevision());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    @Deprecated
    public HasMetadata getData() {
        return this.data != null ? (HasMetadata)this.data.build() : null;
    }

    @Override
    public HasMetadata buildData() {
        return this.data != null ? (HasMetadata)this.data.build() : null;
    }

    @Override
    public A withData(HasMetadata data) {
        if (data instanceof ReplicaSet) {
            this.data = new ReplicaSetBuilder((ReplicaSet)data);
            this._visitables.get("data").add(this.data);
        }
        if (data instanceof DaemonSet) {
            this.data = new DaemonSetBuilder((DaemonSet)data);
            this._visitables.get("data").add(this.data);
        }
        if (data instanceof ControllerRevision) {
            this.data = new ControllerRevisionBuilder((ControllerRevision)data);
            this._visitables.get("data").add(this.data);
        }
        if (data instanceof StatefulSet) {
            this.data = new StatefulSetBuilder((StatefulSet)data);
            this._visitables.get("data").add(this.data);
        }
        if (data instanceof PersistentVolumeClaim) {
            this.data = new PersistentVolumeClaimBuilder((PersistentVolumeClaim)data);
            this._visitables.get("data").add(this.data);
        }
        if (data instanceof Deployment) {
            this.data = new DeploymentBuilder((Deployment)data);
            this._visitables.get("data").add(this.data);
        }
        return (A)this;
    }

    @Override
    public Boolean hasData() {
        return this.data != null;
    }

    @Override
    public A withReplicaSetData(ReplicaSet replicaSetData) {
        this._visitables.get("data").remove(this.data);
        if (replicaSetData != null) {
            this.data = new ReplicaSetBuilder(replicaSetData);
            this._visitables.get("data").add(this.data);
        }
        return (A)this;
    }

    @Override
    public ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetData() {
        return new ReplicaSetDataNestedImpl();
    }

    @Override
    public ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetDataLike(ReplicaSet item) {
        return new ReplicaSetDataNestedImpl(item);
    }

    @Override
    public A withDaemonSetData(DaemonSet daemonSetData) {
        this._visitables.get("data").remove(this.data);
        if (daemonSetData != null) {
            this.data = new DaemonSetBuilder(daemonSetData);
            this._visitables.get("data").add(this.data);
        }
        return (A)this;
    }

    @Override
    public ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetData() {
        return new DaemonSetDataNestedImpl();
    }

    @Override
    public ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetDataLike(DaemonSet item) {
        return new DaemonSetDataNestedImpl(item);
    }

    @Override
    public A withControllerRevisionData(ControllerRevision controllerRevisionData) {
        this._visitables.get("data").remove(this.data);
        if (controllerRevisionData != null) {
            this.data = new ControllerRevisionBuilder(controllerRevisionData);
            this._visitables.get("data").add(this.data);
        }
        return (A)this;
    }

    @Override
    public ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionData() {
        return new ControllerRevisionDataNestedImpl();
    }

    @Override
    public ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionDataLike(ControllerRevision item) {
        return new ControllerRevisionDataNestedImpl(item);
    }

    @Override
    public A withStatefulSetData(StatefulSet statefulSetData) {
        this._visitables.get("data").remove(this.data);
        if (statefulSetData != null) {
            this.data = new StatefulSetBuilder(statefulSetData);
            this._visitables.get("data").add(this.data);
        }
        return (A)this;
    }

    @Override
    public ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetData() {
        return new StatefulSetDataNestedImpl();
    }

    @Override
    public ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetDataLike(StatefulSet item) {
        return new StatefulSetDataNestedImpl(item);
    }

    @Override
    public A withPersistentVolumeClaimData(PersistentVolumeClaim persistentVolumeClaimData) {
        this._visitables.get("data").remove(this.data);
        if (persistentVolumeClaimData != null) {
            this.data = new PersistentVolumeClaimBuilder(persistentVolumeClaimData);
            this._visitables.get("data").add(this.data);
        }
        return (A)this;
    }

    @Override
    public ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimData() {
        return new PersistentVolumeClaimDataNestedImpl();
    }

    @Override
    public ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimDataLike(PersistentVolumeClaim item) {
        return new PersistentVolumeClaimDataNestedImpl(item);
    }

    @Override
    public A withDeploymentData(Deployment deploymentData) {
        this._visitables.get("data").remove(this.data);
        if (deploymentData != null) {
            this.data = new DeploymentBuilder(deploymentData);
            this._visitables.get("data").add(this.data);
        }
        return (A)this;
    }

    @Override
    public ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentData() {
        return new DeploymentDataNestedImpl();
    }

    @Override
    public ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentDataLike(Deployment item) {
        return new DeploymentDataNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ControllerRevisionFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ControllerRevisionFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ControllerRevisionFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ControllerRevisionFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ControllerRevisionFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public Long getRevision() {
        return this.revision;
    }

    @Override
    public A withRevision(Long revision) {
        this.revision = revision;
        return (A)this;
    }

    @Override
    public Boolean hasRevision() {
        return this.revision != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ControllerRevisionFluentImpl that = (ControllerRevisionFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.revision != null ? !this.revision.equals(that.revision) : that.revision != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.data, this.kind, this.metadata, this.revision, super.hashCode());
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ControllerRevisionFluent.MetadataNested<N>>
    implements ControllerRevisionFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ControllerRevisionFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class DeploymentDataNestedImpl<N>
    extends DeploymentFluentImpl<ControllerRevisionFluent.DeploymentDataNested<N>>
    implements ControllerRevisionFluent.DeploymentDataNested<N>,
    Nested<N> {
        private final DeploymentBuilder builder;

        DeploymentDataNestedImpl(Deployment item) {
            this.builder = new DeploymentBuilder(this, item);
        }

        DeploymentDataNestedImpl() {
            this.builder = new DeploymentBuilder(this);
        }

        @Override
        public N and() {
            return (N)ControllerRevisionFluentImpl.this.withData(this.builder.build());
        }

        @Override
        public N endDeploymentData() {
            return this.and();
        }
    }

    public class PersistentVolumeClaimDataNestedImpl<N>
    extends PersistentVolumeClaimFluentImpl<ControllerRevisionFluent.PersistentVolumeClaimDataNested<N>>
    implements ControllerRevisionFluent.PersistentVolumeClaimDataNested<N>,
    Nested<N> {
        private final PersistentVolumeClaimBuilder builder;

        PersistentVolumeClaimDataNestedImpl(PersistentVolumeClaim item) {
            this.builder = new PersistentVolumeClaimBuilder(this, item);
        }

        PersistentVolumeClaimDataNestedImpl() {
            this.builder = new PersistentVolumeClaimBuilder(this);
        }

        @Override
        public N and() {
            return (N)ControllerRevisionFluentImpl.this.withData(this.builder.build());
        }

        @Override
        public N endPersistentVolumeClaimData() {
            return this.and();
        }
    }

    public class StatefulSetDataNestedImpl<N>
    extends StatefulSetFluentImpl<ControllerRevisionFluent.StatefulSetDataNested<N>>
    implements ControllerRevisionFluent.StatefulSetDataNested<N>,
    Nested<N> {
        private final StatefulSetBuilder builder;

        StatefulSetDataNestedImpl(StatefulSet item) {
            this.builder = new StatefulSetBuilder(this, item);
        }

        StatefulSetDataNestedImpl() {
            this.builder = new StatefulSetBuilder(this);
        }

        @Override
        public N and() {
            return (N)ControllerRevisionFluentImpl.this.withData(this.builder.build());
        }

        @Override
        public N endStatefulSetData() {
            return this.and();
        }
    }

    public class ControllerRevisionDataNestedImpl<N>
    extends ControllerRevisionFluentImpl<ControllerRevisionFluent.ControllerRevisionDataNested<N>>
    implements ControllerRevisionFluent.ControllerRevisionDataNested<N>,
    Nested<N> {
        private final ControllerRevisionBuilder builder;

        ControllerRevisionDataNestedImpl(ControllerRevision item) {
            this.builder = new ControllerRevisionBuilder(this, item);
        }

        ControllerRevisionDataNestedImpl() {
            this.builder = new ControllerRevisionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ControllerRevisionFluentImpl.this.withData(this.builder.build());
        }

        @Override
        public N endControllerRevisionData() {
            return this.and();
        }
    }

    public class DaemonSetDataNestedImpl<N>
    extends DaemonSetFluentImpl<ControllerRevisionFluent.DaemonSetDataNested<N>>
    implements ControllerRevisionFluent.DaemonSetDataNested<N>,
    Nested<N> {
        private final DaemonSetBuilder builder;

        DaemonSetDataNestedImpl(DaemonSet item) {
            this.builder = new DaemonSetBuilder(this, item);
        }

        DaemonSetDataNestedImpl() {
            this.builder = new DaemonSetBuilder(this);
        }

        @Override
        public N and() {
            return (N)ControllerRevisionFluentImpl.this.withData(this.builder.build());
        }

        @Override
        public N endDaemonSetData() {
            return this.and();
        }
    }

    public class ReplicaSetDataNestedImpl<N>
    extends ReplicaSetFluentImpl<ControllerRevisionFluent.ReplicaSetDataNested<N>>
    implements ControllerRevisionFluent.ReplicaSetDataNested<N>,
    Nested<N> {
        private final ReplicaSetBuilder builder;

        ReplicaSetDataNestedImpl(ReplicaSet item) {
            this.builder = new ReplicaSetBuilder(this, item);
        }

        ReplicaSetDataNestedImpl() {
            this.builder = new ReplicaSetBuilder(this);
        }

        @Override
        public N and() {
            return (N)ControllerRevisionFluentImpl.this.withData(this.builder.build());
        }

        @Override
        public N endReplicaSetData() {
            return this.and();
        }
    }
}

