/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_1.extensions;

import io.fabric8.kubernetes.api.builder.v5_1.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_1.extensions.ReplicaSetStatus;
import io.fabric8.kubernetes.api.model.v5_1.extensions.ReplicaSetStatusFluent;
import io.fabric8.kubernetes.api.model.v5_1.extensions.ReplicaSetStatusFluentImpl;
import java.util.Objects;

public class ReplicaSetStatusBuilder
extends ReplicaSetStatusFluentImpl<ReplicaSetStatusBuilder>
implements VisitableBuilder<ReplicaSetStatus, ReplicaSetStatusBuilder> {
    ReplicaSetStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ReplicaSetStatusBuilder() {
        this(true);
    }

    public ReplicaSetStatusBuilder(Boolean validationEnabled) {
        this(new ReplicaSetStatus(), validationEnabled);
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ReplicaSetStatus(), validationEnabled);
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent, ReplicaSetStatus instance) {
        this(fluent, instance, true);
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent, ReplicaSetStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAvailableReplicas(instance.getAvailableReplicas());
        fluent.withConditions(instance.getConditions());
        fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        fluent.withObservedGeneration(instance.getObservedGeneration());
        fluent.withReadyReplicas(instance.getReadyReplicas());
        fluent.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatus instance) {
        this(instance, (Boolean)true);
    }

    public ReplicaSetStatusBuilder(ReplicaSetStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAvailableReplicas(instance.getAvailableReplicas());
        this.withConditions(instance.getConditions());
        this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ReplicaSetStatus build() {
        ReplicaSetStatus buildable = new ReplicaSetStatus(this.fluent.getAvailableReplicas(), this.fluent.getConditions(), this.fluent.getFullyLabeledReplicas(), this.fluent.getObservedGeneration(), this.fluent.getReadyReplicas(), this.fluent.getReplicas());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReplicaSetStatusBuilder that = (ReplicaSetStatusBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

