/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_1;

import io.fabric8.kubernetes.api.builder.v5_1.Visitor;
import io.fabric8.kubernetes.api.model.v5_1.APIService;
import io.fabric8.kubernetes.api.model.v5_1.APIServiceList;
import io.fabric8.kubernetes.api.model.v5_1.Binding;
import io.fabric8.kubernetes.api.model.v5_1.ComponentStatus;
import io.fabric8.kubernetes.api.model.v5_1.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v5_1.ConfigMap;
import io.fabric8.kubernetes.api.model.v5_1.ConfigMapList;
import io.fabric8.kubernetes.api.model.v5_1.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_1.Endpoints;
import io.fabric8.kubernetes.api.model.v5_1.EndpointsList;
import io.fabric8.kubernetes.api.model.v5_1.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_1.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.v5_1.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_1.LimitRange;
import io.fabric8.kubernetes.api.model.v5_1.LimitRangeList;
import io.fabric8.kubernetes.api.model.v5_1.Namespace;
import io.fabric8.kubernetes.api.model.v5_1.NamespaceList;
import io.fabric8.kubernetes.api.model.v5_1.Node;
import io.fabric8.kubernetes.api.model.v5_1.NodeList;
import io.fabric8.kubernetes.api.model.v5_1.PersistentVolume;
import io.fabric8.kubernetes.api.model.v5_1.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v5_1.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v5_1.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v5_1.Pod;
import io.fabric8.kubernetes.api.model.v5_1.PodList;
import io.fabric8.kubernetes.api.model.v5_1.ReplicationController;
import io.fabric8.kubernetes.api.model.v5_1.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v5_1.ResourceQuota;
import io.fabric8.kubernetes.api.model.v5_1.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v5_1.Secret;
import io.fabric8.kubernetes.api.model.v5_1.SecretList;
import io.fabric8.kubernetes.api.model.v5_1.Service;
import io.fabric8.kubernetes.api.model.v5_1.ServiceAccount;
import io.fabric8.kubernetes.api.model.v5_1.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v5_1.ServiceList;
import io.fabric8.kubernetes.api.model.v5_1.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.v5_1.certificates.v1beta1.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.v5_1.certificates.v1beta1.CertificateSigningRequestList;
import io.fabric8.kubernetes.api.model.v5_1.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.v5_1.coordination.v1.LeaseList;
import io.fabric8.kubernetes.api.model.v5_1.node.v1beta1.RuntimeClass;
import io.fabric8.kubernetes.api.model.v5_1.node.v1beta1.RuntimeClassList;
import io.fabric8.kubernetes.clnt.v5_1.AdmissionRegistrationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.AdmissionRegistrationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.ApiextensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.AppsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.AuthorizationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.AutoscalingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.BaseClient;
import io.fabric8.kubernetes.clnt.v5_1.BatchAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.CertificatesAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.Config;
import io.fabric8.kubernetes.clnt.v5_1.ConfigBuilder;
import io.fabric8.kubernetes.clnt.v5_1.CustomResource;
import io.fabric8.kubernetes.clnt.v5_1.DiscoveryAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.MetricAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_1.NetworkAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.PolicyAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.RbacAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.RequestConfig;
import io.fabric8.kubernetes.clnt.v5_1.SchedulingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.StorageAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.V1APIGroupClient;
import io.fabric8.kubernetes.clnt.v5_1.VersionInfo;
import io.fabric8.kubernetes.clnt.v5_1.WithRequestCallable;
import io.fabric8.kubernetes.clnt.v5_1.dsl.ApiextensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.AuthorizationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.BatchAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.CertificatesAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.Createable;
import io.fabric8.kubernetes.clnt.v5_1.dsl.DiscoveryAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v5_1.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v5_1.dsl.MetricAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v5_1.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_1.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_1.dsl.NetworkAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_1.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_1.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v5_1.dsl.PolicyAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.RbacAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_1.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v5_1.dsl.SchedulingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v5_1.dsl.StorageAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.V1APIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_1.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v5_1.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.ClusterOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.CreateOnlyResourceOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.CustomResourceOperationContext;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.CustomResourceOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.KubernetesListOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.RawCustomResourceOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.certificates.v1beta1.CertificateSigningRequestOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.coordination.v1.LeaseOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.APIServiceOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.BindingOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.ConfigMapOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.EndpointsOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.LimitRangeOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.NamespaceOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.NodeOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.PersistentVolumeClaimOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.PersistentVolumeOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.PodOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.ReplicationControllerOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.ResourceQuotaOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.SecretOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.ServiceAccountOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.core.v1.ServiceOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.node.v1beta1.RuntimeClassOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_1.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.clnt.v5_1.extended.run.RunConfigBuilder;
import io.fabric8.kubernetes.clnt.v5_1.extended.run.RunOperations;
import io.fabric8.kubernetes.clnt.v5_1.informers.SharedInformerFactory;
import io.fabric8.kubernetes.clnt.v5_1.utils.Serialization;
import io.fabric8.kubernetes.clnt.v5_1.utils.Utils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import okhttp3.OkHttpClient;

public class DefaultKubernetesClient
extends BaseClient
implements NamespacedKubernetesClient {
    public DefaultKubernetesClient() {
    }

    public DefaultKubernetesClient(String masterUrl) {
        super(masterUrl);
    }

    public DefaultKubernetesClient(Config config) {
        super(config);
    }

    public DefaultKubernetesClient(OkHttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    public static DefaultKubernetesClient fromConfig(String config) {
        return new DefaultKubernetesClient(Serialization.unmarshal(config, Config.class));
    }

    public static DefaultKubernetesClient fromConfig(InputStream is) {
        return new DefaultKubernetesClient(Serialization.unmarshal(is, Config.class));
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList(), is, null, true, DeletionPropagation.BACKGROUND){};
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList item) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList(), item, null, DeletionPropagation.BACKGROUND, true){};
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(HasMetadata ... items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(items)).build());
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(Collection<HasMetadata> items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(new ArrayList<HasMetadata>(items))).build());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList(), s, null, DeletionPropagation.BACKGROUND, true){};
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(HasMetadata item) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList<Visitor>(), item, -1L, DeletionPropagation.BACKGROUND, true, 5L, 2.0);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(String s) {
        return new NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList<Visitor>(), s, -1L, DeletionPropagation.BACKGROUND, true, 5L, 2.0);
    }

    @Override
    public MixedOperation<Binding, KubernetesResourceList<Binding>, Resource<Binding>> bindings() {
        return new BindingOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, Resource<Endpoints>> endpoints() {
        return new EndpointsOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, Resource<Namespace>> namespaces() {
        return new NamespaceOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, Resource<Node>> nodes() {
        return new NodeOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, Resource<PersistentVolume>> persistentVolumes() {
        return new PersistentVolumeOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims() {
        return new PersistentVolumeClaimOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Pod, PodList, PodResource<Pod>> pods() {
        return new PodOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> replicationControllers() {
        return new ReplicationControllerOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, Resource<ResourceQuota>> resourceQuotas() {
        return new ResourceQuotaOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public SchedulingAPIGroupDSL scheduling() {
        return this.adapt(SchedulingAPIGroupClient.class);
    }

    @Override
    public MixedOperation<Secret, SecretList, Resource<Secret>> secrets() {
        return new SecretOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<Service, ServiceList, ServiceResource<Service>> services() {
        return new ServiceOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, Resource<ServiceAccount>> serviceAccounts() {
        return new ServiceAccountOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<APIService, APIServiceList, Resource<APIService>> apiServices() {
        return new APIServiceOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return new KubernetesListOperationsImpl(this.httpClient, this.getConfiguration(), this.getNamespace());
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMaps() {
        return new ConfigMapOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, Resource<LimitRange>> limitRanges() {
        return new LimitRangeOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ApiextensionsAPIGroupDSL apiextensions() {
        return this.adapt(ApiextensionsAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<CertificateSigningRequest, CertificateSigningRequestList, Resource<CertificateSigningRequest>> certificateSigningRequests() {
        return new CertificateSigningRequestOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public CertificatesAPIGroupDSL certificates() {
        return this.adapt(CertificatesAPIGroupClient.class);
    }

    @Override
    public AuthorizationAPIGroupDSL authorization() {
        return this.adapt(AuthorizationAPIGroupClient.class);
    }

    @Override
    public Createable<TokenReview> tokenReviews() {
        return new CreateOnlyResourceOperationsImpl<TokenReview>(this.httpClient, this.getConfiguration(), "authentication.k8s.io", "v1", Utils.getPluralFromKind(TokenReview.class.getSimpleName()), TokenReview.class);
    }

    @Override
    public <T extends CustomResource> MixedOperation<T, KubernetesResourceList<T>, Resource<T>> customResources(Class<T> resourceType) {
        return this.customResources(resourceType, null);
    }

    @Override
    public <T extends CustomResource, L extends KubernetesResourceList<T>> MixedOperation<T, L, Resource<T>> customResources(Class<T> resourceType, Class<L> listClass) {
        return new CustomResourceOperationsImpl(new CustomResourceOperationContext().withOkhttpClient(this.httpClient).withConfig(this.getConfiguration()).withCrdContext(CustomResourceDefinitionContext.fromCustomResourceType(resourceType)).withType(resourceType).withListType(listClass).withPropagationPolicy(HasMetadataOperation.DEFAULT_PROPAGATION_POLICY));
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList<T>> MixedOperation<T, L, Resource<T>> customResources(CustomResourceDefinitionContext crdContext, Class<T> resourceType, Class<L> listClass) {
        return new CustomResourceOperationsImpl(new CustomResourceOperationContext().withOkhttpClient(this.httpClient).withConfig(this.getConfiguration()).withCrdContext(crdContext).withType(resourceType).withListType(listClass).withPropagationPolicy(HasMetadataOperation.DEFAULT_PROPAGATION_POLICY));
    }

    @Override
    public RawCustomResourceOperationsImpl customResource(CustomResourceDefinitionContext customResourceDefinition) {
        return new RawCustomResourceOperationsImpl(this.httpClient, this.getConfiguration(), customResourceDefinition);
    }

    @Override
    public DiscoveryAPIGroupDSL discovery() {
        return this.adapt(DiscoveryAPIGroupClient.class);
    }

    @Override
    public NamespacedKubernetesClient inNamespace(String namespace) {
        Config updated = ((ConfigBuilder)new ConfigBuilder(this.getConfiguration()).withNamespace(namespace)).build();
        return new DefaultKubernetesClient(this.httpClient, updated);
    }

    @Override
    public NamespacedKubernetesClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public FunctionCallable<NamespacedKubernetesClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedKubernetesClient>(this, requestConfig);
    }

    @Override
    public ExtensionsAPIGroupDSL extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        return new ClusterOperationsImpl(this.httpClient, this.getConfiguration(), "version").fetchVersion();
    }

    @Override
    public V1APIGroupDSL v1() {
        return this.adapt(V1APIGroupClient.class);
    }

    @Override
    public AdmissionRegistrationAPIGroupDSL admissionRegistration() {
        return this.adapt(AdmissionRegistrationAPIGroupClient.class);
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.adapt(AppsAPIGroupClient.class);
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.adapt(AutoscalingAPIGroupClient.class);
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.adapt(NetworkAPIGroupClient.class);
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.adapt(StorageAPIGroupClient.class);
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.adapt(BatchAPIGroupClient.class);
    }

    @Override
    public MetricAPIGroupDSL top() {
        return this.adapt(MetricAPIGroupClient.class);
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.adapt(PolicyAPIGroupClient.class);
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.adapt(RbacAPIGroupClient.class);
    }

    @Override
    public SharedInformerFactory informers() {
        return new SharedInformerFactory(ForkJoinPool.commonPool(), this.httpClient, this.getConfiguration());
    }

    @Override
    public SharedInformerFactory informers(ExecutorService executorService) {
        return new SharedInformerFactory(executorService, this.httpClient, this.getConfiguration());
    }

    public LeaderElectorBuilder<NamespacedKubernetesClient> leaderElector() {
        return new LeaderElectorBuilder<NamespacedKubernetesClient>(this);
    }

    @Override
    public MixedOperation<Lease, LeaseList, Resource<Lease>> leases() {
        return new LeaseOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public RunOperations run() {
        return new RunOperations(this.httpClient, this.getConfiguration(), this.getNamespace(), new RunConfigBuilder());
    }

    @Override
    public NonNamespaceOperation<RuntimeClass, RuntimeClassList, Resource<RuntimeClass>> runtimeClasses() {
        return new RuntimeClassOperationsImpl(this.httpClient, this.getConfiguration());
    }
}

