/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_1.dsl.base;

import io.fabric8.kubernetes.api.model.v5_1.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_1.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_1.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v5_1.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_1.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_1.dsl.base.BaseOperation;
import io.fabric8.kubernetes.clnt.v5_1.dsl.base.OperationContext;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

public class HasMetadataOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends BaseOperation<T, L, R> {
    public static final DeletionPropagation DEFAULT_PROPAGATION_POLICY = DeletionPropagation.BACKGROUND;

    public HasMetadataOperation(OperationContext ctx) {
        super(ctx);
    }

    @Override
    public T edit(UnaryOperator<T> function) {
        Object item = this.getMandatory();
        return (T)this.patch((T)((HasMetadata)function.apply(item)));
    }

    @Override
    public T accept(Consumer<T> consumer) {
        Object item = this.getMandatory();
        consumer.accept(item);
        return this.patch((T)item);
    }

    @Override
    public T replace(T item) {
        String fixedResourceVersion = this.getResourceVersion();
        Exception caught = null;
        int maxTries = 10;
        for (int i = 0; i < maxTries; ++i) {
            try {
                String resourceVersion;
                if (fixedResourceVersion != null) {
                    resourceVersion = fixedResourceVersion;
                } else {
                    HasMetadata got = (HasMetadata)this.fromServer().get();
                    if (got == null) {
                        return null;
                    }
                    resourceVersion = got.getMetadata() != null ? got.getMetadata().getResourceVersion() : null;
                }
                UnaryOperator visitor = resource -> {
                    try {
                        resource.getMetadata().setResourceVersion(resourceVersion);
                        return this.handleReplace(resource);
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable(this.forOperationType("replace"), (Throwable)e);
                    }
                };
                return (T)((HasMetadata)visitor.apply(item));
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409 || fixedResourceVersion != null) break;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable(this.forOperationType("replace"), (Throwable)caught);
    }

    @Override
    public T patch(T item) {
        Exception caught = null;
        int maxTries = 10;
        for (int i = 0; i < maxTries; ++i) {
            try {
                HasMetadata got = (HasMetadata)this.fromServer().get();
                if (got == null) {
                    return null;
                }
                String resourceVersion = got.getMetadata() != null ? got.getMetadata().getResourceVersion() : null;
                UnaryOperator visitor = resource -> {
                    try {
                        resource.getMetadata().setResourceVersion(resourceVersion);
                        return this.handlePatch(got, resource);
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable(this.forOperationType("patch"), (Throwable)e);
                    }
                };
                return (T)((HasMetadata)visitor.apply(item));
            }
            catch (KubernetesClientException e) {
                caught = e;
                if (e.getCode() != 409) break;
                if (i >= maxTries - 1) continue;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            catch (Exception e) {
                caught = e;
            }
        }
        throw KubernetesClientException.launderThrowable(this.forOperationType("patch"), (Throwable)caught);
    }
}

