/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_1.handlers.rbac.v1;

import io.fabric8.kubernetes.api.model.v5_1.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_1.ListOptions;
import io.fabric8.kubernetes.api.model.v5_1.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.v5_1.rbac.RoleBindingBuilder;
import io.fabric8.kubernetes.clnt.v5_1.Config;
import io.fabric8.kubernetes.clnt.v5_1.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_1.Watch;
import io.fabric8.kubernetes.clnt.v5_1.Watcher;
import io.fabric8.kubernetes.clnt.v5_1.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_1.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_1.dsl.internal.rbac.v1.RoleBindingOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class RoleBindingHandler
implements ResourceHandler<RoleBinding, RoleBindingBuilder> {
    @Override
    public String getKind() {
        return RoleBinding.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "rbac.authorization.k8s.io/v1";
    }

    @Override
    public RoleBinding create(OkHttpClient client, Config config, String namespace, RoleBinding item) {
        return (RoleBinding)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new RoleBinding[0]);
    }

    @Override
    public RoleBinding replace(OkHttpClient client, Config config, String namespace, RoleBinding item) {
        return ((Resource)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public RoleBinding reload(OkHttpClient client, Config config, String namespace, RoleBinding item) {
        return (RoleBinding)((Gettable)((Resource)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public RoleBindingBuilder edit(RoleBinding item) {
        return new RoleBindingBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, RoleBinding item) {
        return new RoleBindingOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, RoleBinding item, Watcher<RoleBinding> watcher) {
        return ((Resource)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, RoleBinding item, String resourceVersion, Watcher<RoleBinding> watcher) {
        return ((Resource)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, RoleBinding item, ListOptions options, Watcher<RoleBinding> watcher) {
        return ((Resource)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public RoleBinding waitUntilReady(OkHttpClient client, Config config, String namespace, RoleBinding item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (RoleBinding)((Resource)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public RoleBinding waitUntilCondition(OkHttpClient client, Config config, String namespace, RoleBinding item, Predicate<RoleBinding> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (RoleBinding)((Resource)new RoleBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

