/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_1;

import io.fabric8.kubernetes.api.builder.v5_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_1.Nested;
import io.fabric8.kubernetes.api.model.v5_1.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_1.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_1.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v5_1.ClusterNetwork;
import io.fabric8.openshift.api.model.v5_1.ClusterNetworkEntry;
import io.fabric8.openshift.api.model.v5_1.ClusterNetworkEntryBuilder;
import io.fabric8.openshift.api.model.v5_1.ClusterNetworkEntryFluentImpl;
import io.fabric8.openshift.api.model.v5_1.ClusterNetworkFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterNetworkFluentImpl<A extends ClusterNetworkFluent<A>>
extends BaseFluent<A>
implements ClusterNetworkFluent<A> {
    private String apiVersion;
    private List<ClusterNetworkEntryBuilder> clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();
    private Integer hostsubnetlength;
    private String kind;
    private ObjectMetaBuilder metadata;
    private Integer mtu;
    private String network;
    private String pluginName;
    private String serviceNetwork;
    private Integer vxlanPort;

    public ClusterNetworkFluentImpl() {
    }

    public ClusterNetworkFluentImpl(ClusterNetwork instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withClusterNetworks(instance.getClusterNetworks());
        this.withHostsubnetlength(instance.getHostsubnetlength());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withMtu(instance.getMtu());
        this.withNetwork(instance.getNetwork());
        this.withPluginName(instance.getPluginName());
        this.withServiceNetwork(instance.getServiceNetwork());
        this.withVxlanPort(instance.getVxlanPort());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToClusterNetworks(int index, ClusterNetworkEntry item) {
        if (this.clusterNetworks == null) {
            this.clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        this._visitables.get("clusterNetworks").add(index >= 0 ? index : this._visitables.get("clusterNetworks").size(), builder);
        this.clusterNetworks.add(index >= 0 ? index : this.clusterNetworks.size(), builder);
        return (A)this;
    }

    @Override
    public A setToClusterNetworks(int index, ClusterNetworkEntry item) {
        if (this.clusterNetworks == null) {
            this.clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
        if (index < 0 || index >= this._visitables.get("clusterNetworks").size()) {
            this._visitables.get("clusterNetworks").add(builder);
        } else {
            this._visitables.get("clusterNetworks").set(index, builder);
        }
        if (index < 0 || index >= this.clusterNetworks.size()) {
            this.clusterNetworks.add(builder);
        } else {
            this.clusterNetworks.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToClusterNetworks(ClusterNetworkEntry ... items) {
        if (this.clusterNetworks == null) {
            this.clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetworks").add(builder);
            this.clusterNetworks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToClusterNetworks(Collection<ClusterNetworkEntry> items) {
        if (this.clusterNetworks == null) {
            this.clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();
        }
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetworks").add(builder);
            this.clusterNetworks.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusterNetworks(ClusterNetworkEntry ... items) {
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetworks").remove(builder);
            if (this.clusterNetworks == null) continue;
            this.clusterNetworks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClusterNetworks(Collection<ClusterNetworkEntry> items) {
        for (ClusterNetworkEntry item : items) {
            ClusterNetworkEntryBuilder builder = new ClusterNetworkEntryBuilder(item);
            this._visitables.get("clusterNetworks").remove(builder);
            if (this.clusterNetworks == null) continue;
            this.clusterNetworks.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromClusterNetworks(Predicate<ClusterNetworkEntryBuilder> predicate) {
        if (this.clusterNetworks == null) {
            return (A)this;
        }
        Iterator<ClusterNetworkEntryBuilder> each = this.clusterNetworks.iterator();
        Object visitables = this._visitables.get("clusterNetworks");
        while (each.hasNext()) {
            ClusterNetworkEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterNetworkEntry> getClusterNetworks() {
        return ClusterNetworkFluentImpl.build(this.clusterNetworks);
    }

    @Override
    public List<ClusterNetworkEntry> buildClusterNetworks() {
        return ClusterNetworkFluentImpl.build(this.clusterNetworks);
    }

    @Override
    public ClusterNetworkEntry buildClusterNetwork(int index) {
        return this.clusterNetworks.get(index).build();
    }

    @Override
    public ClusterNetworkEntry buildFirstClusterNetwork() {
        return this.clusterNetworks.get(0).build();
    }

    @Override
    public ClusterNetworkEntry buildLastClusterNetwork() {
        return this.clusterNetworks.get(this.clusterNetworks.size() - 1).build();
    }

    @Override
    public ClusterNetworkEntry buildMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetworks) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        for (ClusterNetworkEntryBuilder item : this.clusterNetworks) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClusterNetworks(List<ClusterNetworkEntry> clusterNetworks) {
        if (this.clusterNetworks != null) {
            this._visitables.get("clusterNetworks").removeAll(this.clusterNetworks);
        }
        if (clusterNetworks != null) {
            this.clusterNetworks = new ArrayList<ClusterNetworkEntryBuilder>();
            for (ClusterNetworkEntry item : clusterNetworks) {
                this.addToClusterNetworks(item);
            }
        } else {
            this.clusterNetworks = null;
        }
        return (A)this;
    }

    @Override
    public A withClusterNetworks(ClusterNetworkEntry ... clusterNetworks) {
        if (this.clusterNetworks != null) {
            this.clusterNetworks.clear();
        }
        if (clusterNetworks != null) {
            for (ClusterNetworkEntry item : clusterNetworks) {
                this.addToClusterNetworks(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterNetworks() {
        return this.clusterNetworks != null && !this.clusterNetworks.isEmpty();
    }

    @Override
    public A addNewClusterNetwork(String cidr, Integer hostSubnetLength) {
        return this.addToClusterNetworks(new ClusterNetworkEntry(cidr, hostSubnetLength));
    }

    @Override
    public ClusterNetworkFluent.ClusterNetworksNested<A> addNewClusterNetwork() {
        return new ClusterNetworksNestedImpl();
    }

    @Override
    public ClusterNetworkFluent.ClusterNetworksNested<A> addNewClusterNetworkLike(ClusterNetworkEntry item) {
        return new ClusterNetworksNestedImpl(-1, item);
    }

    @Override
    public ClusterNetworkFluent.ClusterNetworksNested<A> setNewClusterNetworkLike(int index, ClusterNetworkEntry item) {
        return new ClusterNetworksNestedImpl(index, item);
    }

    @Override
    public ClusterNetworkFluent.ClusterNetworksNested<A> editClusterNetwork(int index) {
        if (this.clusterNetworks.size() <= index) {
            throw new RuntimeException("Can't edit clusterNetworks. Index exceeds size.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    public ClusterNetworkFluent.ClusterNetworksNested<A> editFirstClusterNetwork() {
        if (this.clusterNetworks.size() == 0) {
            throw new RuntimeException("Can't edit first clusterNetworks. The list is empty.");
        }
        return this.setNewClusterNetworkLike(0, this.buildClusterNetwork(0));
    }

    @Override
    public ClusterNetworkFluent.ClusterNetworksNested<A> editLastClusterNetwork() {
        int index = this.clusterNetworks.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterNetworks. The list is empty.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    public ClusterNetworkFluent.ClusterNetworksNested<A> editMatchingClusterNetwork(Predicate<ClusterNetworkEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterNetworks.size(); ++i) {
            if (!predicate.test(this.clusterNetworks.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterNetworks. No match found.");
        }
        return this.setNewClusterNetworkLike(index, this.buildClusterNetwork(index));
    }

    @Override
    public Integer getHostsubnetlength() {
        return this.hostsubnetlength;
    }

    @Override
    public A withHostsubnetlength(Integer hostsubnetlength) {
        this.hostsubnetlength = hostsubnetlength;
        return (A)this;
    }

    @Override
    public Boolean hasHostsubnetlength() {
        return this.hostsubnetlength != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ClusterNetworkFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ClusterNetworkFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ClusterNetworkFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ClusterNetworkFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ClusterNetworkFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public Integer getMtu() {
        return this.mtu;
    }

    @Override
    public A withMtu(Integer mtu) {
        this.mtu = mtu;
        return (A)this;
    }

    @Override
    public Boolean hasMtu() {
        return this.mtu != null;
    }

    @Override
    public String getNetwork() {
        return this.network;
    }

    @Override
    public A withNetwork(String network) {
        this.network = network;
        return (A)this;
    }

    @Override
    public Boolean hasNetwork() {
        return this.network != null;
    }

    @Override
    public A withNewNetwork(String arg1) {
        return this.withNetwork(new String(arg1));
    }

    @Override
    public A withNewNetwork(StringBuilder arg1) {
        return this.withNetwork(new String(arg1));
    }

    @Override
    public A withNewNetwork(StringBuffer arg1) {
        return this.withNetwork(new String(arg1));
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public A withPluginName(String pluginName) {
        this.pluginName = pluginName;
        return (A)this;
    }

    @Override
    public Boolean hasPluginName() {
        return this.pluginName != null;
    }

    @Override
    public A withNewPluginName(String arg1) {
        return this.withPluginName(new String(arg1));
    }

    @Override
    public A withNewPluginName(StringBuilder arg1) {
        return this.withPluginName(new String(arg1));
    }

    @Override
    public A withNewPluginName(StringBuffer arg1) {
        return this.withPluginName(new String(arg1));
    }

    @Override
    public String getServiceNetwork() {
        return this.serviceNetwork;
    }

    @Override
    public A withServiceNetwork(String serviceNetwork) {
        this.serviceNetwork = serviceNetwork;
        return (A)this;
    }

    @Override
    public Boolean hasServiceNetwork() {
        return this.serviceNetwork != null;
    }

    @Override
    public A withNewServiceNetwork(String arg1) {
        return this.withServiceNetwork(new String(arg1));
    }

    @Override
    public A withNewServiceNetwork(StringBuilder arg1) {
        return this.withServiceNetwork(new String(arg1));
    }

    @Override
    public A withNewServiceNetwork(StringBuffer arg1) {
        return this.withServiceNetwork(new String(arg1));
    }

    @Override
    public Integer getVxlanPort() {
        return this.vxlanPort;
    }

    @Override
    public A withVxlanPort(Integer vxlanPort) {
        this.vxlanPort = vxlanPort;
        return (A)this;
    }

    @Override
    public Boolean hasVxlanPort() {
        return this.vxlanPort != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterNetworkFluentImpl that = (ClusterNetworkFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.clusterNetworks != null ? !this.clusterNetworks.equals(that.clusterNetworks) : that.clusterNetworks != null) {
            return false;
        }
        if (this.hostsubnetlength != null ? !this.hostsubnetlength.equals(that.hostsubnetlength) : that.hostsubnetlength != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.mtu != null ? !this.mtu.equals(that.mtu) : that.mtu != null) {
            return false;
        }
        if (this.network != null ? !this.network.equals(that.network) : that.network != null) {
            return false;
        }
        if (this.pluginName != null ? !this.pluginName.equals(that.pluginName) : that.pluginName != null) {
            return false;
        }
        if (this.serviceNetwork != null ? !this.serviceNetwork.equals(that.serviceNetwork) : that.serviceNetwork != null) {
            return false;
        }
        return !(this.vxlanPort != null ? !this.vxlanPort.equals(that.vxlanPort) : that.vxlanPort != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.clusterNetworks, this.hostsubnetlength, this.kind, this.metadata, this.mtu, this.network, this.pluginName, this.serviceNetwork, this.vxlanPort, super.hashCode());
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ClusterNetworkFluent.MetadataNested<N>>
    implements ClusterNetworkFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterNetworkFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class ClusterNetworksNestedImpl<N>
    extends ClusterNetworkEntryFluentImpl<ClusterNetworkFluent.ClusterNetworksNested<N>>
    implements ClusterNetworkFluent.ClusterNetworksNested<N>,
    Nested<N> {
        private final ClusterNetworkEntryBuilder builder;
        private final int index;

        ClusterNetworksNestedImpl(int index, ClusterNetworkEntry item) {
            this.index = index;
            this.builder = new ClusterNetworkEntryBuilder(this, item);
        }

        ClusterNetworksNestedImpl() {
            this.index = -1;
            this.builder = new ClusterNetworkEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterNetworkFluentImpl.this.setToClusterNetworks(this.index, this.builder.build());
        }

        @Override
        public N endClusterNetwork() {
            return this.and();
        }
    }
}

