/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_1.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_1.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_1.Nested;
import io.fabric8.openshift.api.model.v5_1.operator.v1.DNSSpec;
import io.fabric8.openshift.api.model.v5_1.operator.v1.DNSSpecFluent;
import io.fabric8.openshift.api.model.v5_1.operator.v1.Server;
import io.fabric8.openshift.api.model.v5_1.operator.v1.ServerBuilder;
import io.fabric8.openshift.api.model.v5_1.operator.v1.ServerFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSSpecFluentImpl<A extends DNSSpecFluent<A>>
extends BaseFluent<A>
implements DNSSpecFluent<A> {
    private List<ServerBuilder> servers = new ArrayList<ServerBuilder>();

    public DNSSpecFluentImpl() {
    }

    public DNSSpecFluentImpl(DNSSpec instance) {
        this.withServers(instance.getServers());
    }

    @Override
    public A addToServers(int index, Server item) {
        if (this.servers == null) {
            this.servers = new ArrayList<ServerBuilder>();
        }
        ServerBuilder builder = new ServerBuilder(item);
        this._visitables.get("servers").add(index >= 0 ? index : this._visitables.get("servers").size(), builder);
        this.servers.add(index >= 0 ? index : this.servers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServers(int index, Server item) {
        if (this.servers == null) {
            this.servers = new ArrayList<ServerBuilder>();
        }
        ServerBuilder builder = new ServerBuilder(item);
        if (index < 0 || index >= this._visitables.get("servers").size()) {
            this._visitables.get("servers").add(builder);
        } else {
            this._visitables.get("servers").set(index, builder);
        }
        if (index < 0 || index >= this.servers.size()) {
            this.servers.add(builder);
        } else {
            this.servers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServers(Server ... items) {
        if (this.servers == null) {
            this.servers = new ArrayList<ServerBuilder>();
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get("servers").add(builder);
            this.servers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServers(Collection<Server> items) {
        if (this.servers == null) {
            this.servers = new ArrayList<ServerBuilder>();
        }
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get("servers").add(builder);
            this.servers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServers(Server ... items) {
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get("servers").remove(builder);
            if (this.servers == null) continue;
            this.servers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServers(Collection<Server> items) {
        for (Server item : items) {
            ServerBuilder builder = new ServerBuilder(item);
            this._visitables.get("servers").remove(builder);
            if (this.servers == null) continue;
            this.servers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromServers(Predicate<ServerBuilder> predicate) {
        if (this.servers == null) {
            return (A)this;
        }
        Iterator<ServerBuilder> each = this.servers.iterator();
        Object visitables = this._visitables.get("servers");
        while (each.hasNext()) {
            ServerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Server> getServers() {
        return DNSSpecFluentImpl.build(this.servers);
    }

    @Override
    public List<Server> buildServers() {
        return DNSSpecFluentImpl.build(this.servers);
    }

    @Override
    public Server buildServer(int index) {
        return this.servers.get(index).build();
    }

    @Override
    public Server buildFirstServer() {
        return this.servers.get(0).build();
    }

    @Override
    public Server buildLastServer() {
        return this.servers.get(this.servers.size() - 1).build();
    }

    @Override
    public Server buildMatchingServer(Predicate<ServerBuilder> predicate) {
        for (ServerBuilder item : this.servers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServer(Predicate<ServerBuilder> predicate) {
        for (ServerBuilder item : this.servers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServers(List<Server> servers) {
        if (this.servers != null) {
            this._visitables.get("servers").removeAll(this.servers);
        }
        if (servers != null) {
            this.servers = new ArrayList<ServerBuilder>();
            for (Server item : servers) {
                this.addToServers(item);
            }
        } else {
            this.servers = null;
        }
        return (A)this;
    }

    @Override
    public A withServers(Server ... servers) {
        if (this.servers != null) {
            this.servers.clear();
        }
        if (servers != null) {
            for (Server item : servers) {
                this.addToServers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServers() {
        return this.servers != null && !this.servers.isEmpty();
    }

    @Override
    public DNSSpecFluent.ServersNested<A> addNewServer() {
        return new ServersNestedImpl();
    }

    @Override
    public DNSSpecFluent.ServersNested<A> addNewServerLike(Server item) {
        return new ServersNestedImpl(-1, item);
    }

    @Override
    public DNSSpecFluent.ServersNested<A> setNewServerLike(int index, Server item) {
        return new ServersNestedImpl(index, item);
    }

    @Override
    public DNSSpecFluent.ServersNested<A> editServer(int index) {
        if (this.servers.size() <= index) {
            throw new RuntimeException("Can't edit servers. Index exceeds size.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    @Override
    public DNSSpecFluent.ServersNested<A> editFirstServer() {
        if (this.servers.size() == 0) {
            throw new RuntimeException("Can't edit first servers. The list is empty.");
        }
        return this.setNewServerLike(0, this.buildServer(0));
    }

    @Override
    public DNSSpecFluent.ServersNested<A> editLastServer() {
        int index = this.servers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last servers. The list is empty.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    @Override
    public DNSSpecFluent.ServersNested<A> editMatchingServer(Predicate<ServerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.servers.size(); ++i) {
            if (!predicate.test(this.servers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching servers. No match found.");
        }
        return this.setNewServerLike(index, this.buildServer(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSSpecFluentImpl that = (DNSSpecFluentImpl)o;
        return !(this.servers != null ? !this.servers.equals(that.servers) : that.servers != null);
    }

    public int hashCode() {
        return Objects.hash(this.servers, super.hashCode());
    }

    public class ServersNestedImpl<N>
    extends ServerFluentImpl<DNSSpecFluent.ServersNested<N>>
    implements DNSSpecFluent.ServersNested<N>,
    Nested<N> {
        private final ServerBuilder builder;
        private final int index;

        ServersNestedImpl(int index, Server item) {
            this.index = index;
            this.builder = new ServerBuilder(this, item);
        }

        ServersNestedImpl() {
            this.index = -1;
            this.builder = new ServerBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSSpecFluentImpl.this.setToServers(this.index, this.builder.build());
        }

        @Override
        public N endServer() {
            return this.and();
        }
    }
}

