/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_1.handlers;

import io.fabric8.kubernetes.api.model.v5_1.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_1.ListOptions;
import io.fabric8.kubernetes.clnt.v5_1.Config;
import io.fabric8.kubernetes.clnt.v5_1.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_1.Watch;
import io.fabric8.kubernetes.clnt.v5_1.Watcher;
import io.fabric8.kubernetes.clnt.v5_1.dsl.Gettable;
import io.fabric8.openshift.api.model.v5_1.BuildConfig;
import io.fabric8.openshift.api.model.v5_1.BuildConfigBuilder;
import io.fabric8.openshift.clnt.v5_1.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_1.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v5_1.dsl.internal.BuildConfigOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class BuildConfigHandler
implements ResourceHandler<BuildConfig, BuildConfigBuilder> {
    @Override
    public String getKind() {
        return BuildConfig.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "build.openshift.io/v1";
    }

    @Override
    public BuildConfig create(OkHttpClient client, Config config, String namespace, BuildConfig item) {
        return (BuildConfig)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).create(new BuildConfig[0]);
    }

    @Override
    public BuildConfig replace(OkHttpClient client, Config config, String namespace, BuildConfig item) {
        return ((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public BuildConfig reload(OkHttpClient client, Config config, String namespace, BuildConfig item) {
        return (BuildConfig)((Gettable)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public BuildConfigBuilder edit(BuildConfig item) {
        return new BuildConfigBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, BuildConfig item) {
        return new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, BuildConfig item, Watcher<BuildConfig> watcher) {
        return ((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, BuildConfig item, String resourceVersion, Watcher<BuildConfig> watcher) {
        return ((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, BuildConfig item, ListOptions options, Watcher<BuildConfig> watcher) {
        return ((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public BuildConfig waitUntilReady(OkHttpClient client, Config config, String namespace, BuildConfig item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (BuildConfig)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public BuildConfig waitUntilCondition(OkHttpClient client, Config config, String namespace, BuildConfig item, Predicate<BuildConfig> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (BuildConfig)((BuildConfigResource)new BuildConfigOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

