/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.DockerBuildStrategy;
import io.fabric8.openshift.api.model.DockerBuildStrategyFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DockerBuildStrategyFluentImpl<A extends DockerBuildStrategyFluent<A>>
extends BaseFluent<A>
implements DockerBuildStrategyFluent<A> {
    private List<EnvVar> buildArgs = new ArrayList<EnvVar>();
    private String dockerfilePath;
    private List<EnvVar> env = new ArrayList<EnvVar>();
    private Boolean forcePull;
    private ObjectReferenceBuilder from;
    private String imageOptimizationPolicy;
    private Boolean noCache;
    private LocalObjectReferenceBuilder pullSecret;

    public DockerBuildStrategyFluentImpl() {
    }

    public DockerBuildStrategyFluentImpl(DockerBuildStrategy instance) {
        this.withBuildArgs(instance.getBuildArgs());
        this.withDockerfilePath(instance.getDockerfilePath());
        this.withEnv(instance.getEnv());
        this.withForcePull(instance.getForcePull());
        this.withFrom(instance.getFrom());
        this.withImageOptimizationPolicy(instance.getImageOptimizationPolicy());
        this.withNoCache(instance.getNoCache());
        this.withPullSecret(instance.getPullSecret());
    }

    @Override
    public A addToBuildArgs(int index, EnvVar item) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVar>();
        }
        this.buildArgs.add(index, item);
        return (A)this;
    }

    @Override
    public A setToBuildArgs(int index, EnvVar item) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVar>();
        }
        this.buildArgs.set(index, item);
        return (A)this;
    }

    @Override
    public A addToBuildArgs(EnvVar ... items) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.buildArgs.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToBuildArgs(Collection<EnvVar> items) {
        if (this.buildArgs == null) {
            this.buildArgs = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.buildArgs.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromBuildArgs(EnvVar ... items) {
        for (EnvVar item : items) {
            if (this.buildArgs == null) continue;
            this.buildArgs.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromBuildArgs(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            if (this.buildArgs == null) continue;
            this.buildArgs.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<EnvVar> getBuildArgs() {
        return this.buildArgs;
    }

    @Override
    public EnvVar getBuildArg(int index) {
        return this.buildArgs.get(index);
    }

    @Override
    public EnvVar getFirstBuildArg() {
        return this.buildArgs.get(0);
    }

    @Override
    public EnvVar getLastBuildArg() {
        return this.buildArgs.get(this.buildArgs.size() - 1);
    }

    @Override
    public EnvVar getMatchingBuildArg(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.buildArgs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingBuildArg(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.buildArgs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withBuildArgs(List<EnvVar> buildArgs) {
        if (this.buildArgs != null) {
            this._visitables.get("buildArgs").removeAll(this.buildArgs);
        }
        if (buildArgs != null) {
            this.buildArgs = new ArrayList<EnvVar>();
            for (EnvVar item : buildArgs) {
                this.addToBuildArgs(item);
            }
        } else {
            this.buildArgs = null;
        }
        return (A)this;
    }

    @Override
    public A withBuildArgs(EnvVar ... buildArgs) {
        if (this.buildArgs != null) {
            this.buildArgs.clear();
        }
        if (buildArgs != null) {
            for (EnvVar item : buildArgs) {
                this.addToBuildArgs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasBuildArgs() {
        return this.buildArgs != null && !this.buildArgs.isEmpty();
    }

    @Override
    public String getDockerfilePath() {
        return this.dockerfilePath;
    }

    @Override
    public A withDockerfilePath(String dockerfilePath) {
        this.dockerfilePath = dockerfilePath;
        return (A)this;
    }

    @Override
    public Boolean hasDockerfilePath() {
        return this.dockerfilePath != null;
    }

    @Override
    public A withNewDockerfilePath(String arg1) {
        return this.withDockerfilePath(new String(arg1));
    }

    @Override
    public A withNewDockerfilePath(StringBuilder arg1) {
        return this.withDockerfilePath(new String(arg1));
    }

    @Override
    public A withNewDockerfilePath(StringBuffer arg1) {
        return this.withDockerfilePath(new String(arg1));
    }

    @Override
    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            if (this.env == null) continue;
            this.env.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            if (this.env == null) continue;
            this.env.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<EnvVar> getEnv() {
        return this.env;
    }

    @Override
    public EnvVar getEnv(int index) {
        return this.env.get(index);
    }

    @Override
    public EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    @Override
    public EnvVar getLastEnv() {
        return this.env.get(this.env.size() - 1);
    }

    @Override
    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        if (this.env != null) {
            this._visitables.get("env").removeAll(this.env);
        }
        if (env != null) {
            this.env = new ArrayList<EnvVar>();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    public Boolean isForcePull() {
        return this.forcePull;
    }

    @Override
    public A withForcePull(Boolean forcePull) {
        this.forcePull = forcePull;
        return (A)this;
    }

    @Override
    public Boolean hasForcePull() {
        return this.forcePull != null;
    }

    @Override
    public A withNewForcePull(String arg1) {
        return this.withForcePull(new Boolean(arg1));
    }

    @Override
    public A withNewForcePull(boolean arg1) {
        return this.withForcePull(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public ObjectReference getFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.get("from").remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get("from").add(this.from);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public DockerBuildStrategyFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public String getImageOptimizationPolicy() {
        return this.imageOptimizationPolicy;
    }

    @Override
    public A withImageOptimizationPolicy(String imageOptimizationPolicy) {
        this.imageOptimizationPolicy = imageOptimizationPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasImageOptimizationPolicy() {
        return this.imageOptimizationPolicy != null;
    }

    @Override
    public A withNewImageOptimizationPolicy(String arg1) {
        return this.withImageOptimizationPolicy(new String(arg1));
    }

    @Override
    public A withNewImageOptimizationPolicy(StringBuilder arg1) {
        return this.withImageOptimizationPolicy(new String(arg1));
    }

    @Override
    public A withNewImageOptimizationPolicy(StringBuffer arg1) {
        return this.withImageOptimizationPolicy(new String(arg1));
    }

    @Override
    public Boolean isNoCache() {
        return this.noCache;
    }

    @Override
    public A withNoCache(Boolean noCache) {
        this.noCache = noCache;
        return (A)this;
    }

    @Override
    public Boolean hasNoCache() {
        return this.noCache != null;
    }

    @Override
    public A withNewNoCache(String arg1) {
        return this.withNoCache(new Boolean(arg1));
    }

    @Override
    public A withNewNoCache(boolean arg1) {
        return this.withNoCache(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public LocalObjectReference getPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public LocalObjectReference buildPullSecret() {
        return this.pullSecret != null ? this.pullSecret.build() : null;
    }

    @Override
    public A withPullSecret(LocalObjectReference pullSecret) {
        this._visitables.get("pullSecret").remove(this.pullSecret);
        if (pullSecret != null) {
            this.pullSecret = new LocalObjectReferenceBuilder(pullSecret);
            this._visitables.get("pullSecret").add(this.pullSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPullSecret() {
        return this.pullSecret != null;
    }

    @Override
    public A withNewPullSecret(String name) {
        return this.withPullSecret(new LocalObjectReference(name));
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
        return new PullSecretNestedImpl();
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item) {
        return new PullSecretNestedImpl(item);
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret());
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret() {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(LocalObjectReference item) {
        return this.withNewPullSecretLike(this.getPullSecret() != null ? this.getPullSecret() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerBuildStrategyFluentImpl that = (DockerBuildStrategyFluentImpl)o;
        if (this.buildArgs != null ? !this.buildArgs.equals(that.buildArgs) : that.buildArgs != null) {
            return false;
        }
        if (this.dockerfilePath != null ? !this.dockerfilePath.equals(that.dockerfilePath) : that.dockerfilePath != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.forcePull != null ? !this.forcePull.equals(that.forcePull) : that.forcePull != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        if (this.imageOptimizationPolicy != null ? !this.imageOptimizationPolicy.equals(that.imageOptimizationPolicy) : that.imageOptimizationPolicy != null) {
            return false;
        }
        if (this.noCache != null ? !this.noCache.equals(that.noCache) : that.noCache != null) {
            return false;
        }
        return !(this.pullSecret != null ? !this.pullSecret.equals(that.pullSecret) : that.pullSecret != null);
    }

    public int hashCode() {
        return Objects.hash(this.buildArgs, this.dockerfilePath, this.env, this.forcePull, this.from, this.imageOptimizationPolicy, this.noCache, this.pullSecret, super.hashCode());
    }

    public class PullSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<DockerBuildStrategyFluent.PullSecretNested<N>>
    implements DockerBuildStrategyFluent.PullSecretNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        PullSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        PullSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)DockerBuildStrategyFluentImpl.this.withPullSecret(this.builder.build());
        }

        @Override
        public N endPullSecret() {
            return this.and();
        }
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<DockerBuildStrategyFluent.FromNested<N>>
    implements DockerBuildStrategyFluent.FromNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)DockerBuildStrategyFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }
}

