/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.ProjectRequestFluent;
import io.fabric8.openshift.api.model.ProjectRequestFluentImpl;
import java.util.Objects;

public class ProjectRequestBuilder
extends ProjectRequestFluentImpl<ProjectRequestBuilder>
implements VisitableBuilder<ProjectRequest, ProjectRequestBuilder> {
    ProjectRequestFluent<?> fluent;
    Boolean validationEnabled;

    public ProjectRequestBuilder() {
        this(true);
    }

    public ProjectRequestBuilder(Boolean validationEnabled) {
        this(new ProjectRequest(), validationEnabled);
    }

    public ProjectRequestBuilder(ProjectRequestFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ProjectRequestBuilder(ProjectRequestFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ProjectRequest(), validationEnabled);
    }

    public ProjectRequestBuilder(ProjectRequestFluent<?> fluent, ProjectRequest instance) {
        this(fluent, instance, true);
    }

    public ProjectRequestBuilder(ProjectRequestFluent<?> fluent, ProjectRequest instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withDescription(instance.getDescription());
        fluent.withDisplayName(instance.getDisplayName());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ProjectRequestBuilder(ProjectRequest instance) {
        this(instance, (Boolean)true);
    }

    public ProjectRequestBuilder(ProjectRequest instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withDescription(instance.getDescription());
        this.withDisplayName(instance.getDisplayName());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ProjectRequest build() {
        ProjectRequest buildable = new ProjectRequest(this.fluent.getApiVersion(), this.fluent.getDescription(), this.fluent.getDisplayName(), this.fluent.getKind(), this.fluent.getMetadata());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProjectRequestBuilder that = (ProjectRequestBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

