/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.Authorization;
import io.fabric8.openshift.api.model.monitoring.v1.AuthorizationBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.AuthorizationFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuth;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.BasicAuthFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2Builder;
import io.fabric8.openshift.api.model.monitoring.v1.OAuth2FluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpec;
import io.fabric8.openshift.api.model.monitoring.v1.RemoteReadSpecFluent;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.TLSConfigFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class RemoteReadSpecFluentImpl<A extends RemoteReadSpecFluent<A>>
extends BaseFluent<A>
implements RemoteReadSpecFluent<A> {
    private AuthorizationBuilder authorization;
    private BasicAuthBuilder basicAuth;
    private String bearerToken;
    private String bearerTokenFile;
    private String name;
    private OAuth2Builder oauth2;
    private String proxyUrl;
    private Boolean readRecent;
    private String remoteTimeout;
    private Map<String, String> requiredMatchers;
    private TLSConfigBuilder tlsConfig;
    private String url;
    private Map<String, Object> additionalProperties;

    public RemoteReadSpecFluentImpl() {
    }

    public RemoteReadSpecFluentImpl(RemoteReadSpec instance) {
        this.withAuthorization(instance.getAuthorization());
        this.withBasicAuth(instance.getBasicAuth());
        this.withBearerToken(instance.getBearerToken());
        this.withBearerTokenFile(instance.getBearerTokenFile());
        this.withName(instance.getName());
        this.withOauth2(instance.getOauth2());
        this.withProxyUrl(instance.getProxyUrl());
        this.withReadRecent(instance.getReadRecent());
        this.withRemoteTimeout(instance.getRemoteTimeout());
        this.withRequiredMatchers(instance.getRequiredMatchers());
        this.withTlsConfig(instance.getTlsConfig());
        this.withUrl(instance.getUrl());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public Authorization getAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    @Override
    public Authorization buildAuthorization() {
        return this.authorization != null ? this.authorization.build() : null;
    }

    @Override
    public A withAuthorization(Authorization authorization) {
        this._visitables.get("authorization").remove(this.authorization);
        if (authorization != null) {
            this.authorization = new AuthorizationBuilder(authorization);
            this._visitables.get("authorization").add(this.authorization);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAuthorization() {
        return this.authorization != null;
    }

    @Override
    public RemoteReadSpecFluent.AuthorizationNested<A> withNewAuthorization() {
        return new AuthorizationNestedImpl();
    }

    @Override
    public RemoteReadSpecFluent.AuthorizationNested<A> withNewAuthorizationLike(Authorization item) {
        return new AuthorizationNestedImpl(item);
    }

    @Override
    public RemoteReadSpecFluent.AuthorizationNested<A> editAuthorization() {
        return this.withNewAuthorizationLike(this.getAuthorization());
    }

    @Override
    public RemoteReadSpecFluent.AuthorizationNested<A> editOrNewAuthorization() {
        return this.withNewAuthorizationLike(this.getAuthorization() != null ? this.getAuthorization() : new AuthorizationBuilder().build());
    }

    @Override
    public RemoteReadSpecFluent.AuthorizationNested<A> editOrNewAuthorizationLike(Authorization item) {
        return this.withNewAuthorizationLike(this.getAuthorization() != null ? this.getAuthorization() : item);
    }

    @Override
    @Deprecated
    public BasicAuth getBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    @Override
    public BasicAuth buildBasicAuth() {
        return this.basicAuth != null ? this.basicAuth.build() : null;
    }

    @Override
    public A withBasicAuth(BasicAuth basicAuth) {
        this._visitables.get("basicAuth").remove(this.basicAuth);
        if (basicAuth != null) {
            this.basicAuth = new BasicAuthBuilder(basicAuth);
            this._visitables.get("basicAuth").add(this.basicAuth);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBasicAuth() {
        return this.basicAuth != null;
    }

    @Override
    public RemoteReadSpecFluent.BasicAuthNested<A> withNewBasicAuth() {
        return new BasicAuthNestedImpl();
    }

    @Override
    public RemoteReadSpecFluent.BasicAuthNested<A> withNewBasicAuthLike(BasicAuth item) {
        return new BasicAuthNestedImpl(item);
    }

    @Override
    public RemoteReadSpecFluent.BasicAuthNested<A> editBasicAuth() {
        return this.withNewBasicAuthLike(this.getBasicAuth());
    }

    @Override
    public RemoteReadSpecFluent.BasicAuthNested<A> editOrNewBasicAuth() {
        return this.withNewBasicAuthLike(this.getBasicAuth() != null ? this.getBasicAuth() : new BasicAuthBuilder().build());
    }

    @Override
    public RemoteReadSpecFluent.BasicAuthNested<A> editOrNewBasicAuthLike(BasicAuth item) {
        return this.withNewBasicAuthLike(this.getBasicAuth() != null ? this.getBasicAuth() : item);
    }

    @Override
    public String getBearerToken() {
        return this.bearerToken;
    }

    @Override
    public A withBearerToken(String bearerToken) {
        this.bearerToken = bearerToken;
        return (A)this;
    }

    @Override
    public Boolean hasBearerToken() {
        return this.bearerToken != null;
    }

    @Override
    @Deprecated
    public A withNewBearerToken(String arg0) {
        return this.withBearerToken(new String(arg0));
    }

    @Override
    public String getBearerTokenFile() {
        return this.bearerTokenFile;
    }

    @Override
    public A withBearerTokenFile(String bearerTokenFile) {
        this.bearerTokenFile = bearerTokenFile;
        return (A)this;
    }

    @Override
    public Boolean hasBearerTokenFile() {
        return this.bearerTokenFile != null;
    }

    @Override
    @Deprecated
    public A withNewBearerTokenFile(String arg0) {
        return this.withBearerTokenFile(new String(arg0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    @Deprecated
    public OAuth2 getOauth2() {
        return this.oauth2 != null ? this.oauth2.build() : null;
    }

    @Override
    public OAuth2 buildOauth2() {
        return this.oauth2 != null ? this.oauth2.build() : null;
    }

    @Override
    public A withOauth2(OAuth2 oauth2) {
        this._visitables.get("oauth2").remove(this.oauth2);
        if (oauth2 != null) {
            this.oauth2 = new OAuth2Builder(oauth2);
            this._visitables.get("oauth2").add(this.oauth2);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOauth2() {
        return this.oauth2 != null;
    }

    @Override
    public RemoteReadSpecFluent.Oauth2Nested<A> withNewOauth2() {
        return new Oauth2NestedImpl();
    }

    @Override
    public RemoteReadSpecFluent.Oauth2Nested<A> withNewOauth2Like(OAuth2 item) {
        return new Oauth2NestedImpl(item);
    }

    @Override
    public RemoteReadSpecFluent.Oauth2Nested<A> editOauth2() {
        return this.withNewOauth2Like(this.getOauth2());
    }

    @Override
    public RemoteReadSpecFluent.Oauth2Nested<A> editOrNewOauth2() {
        return this.withNewOauth2Like(this.getOauth2() != null ? this.getOauth2() : new OAuth2Builder().build());
    }

    @Override
    public RemoteReadSpecFluent.Oauth2Nested<A> editOrNewOauth2Like(OAuth2 item) {
        return this.withNewOauth2Like(this.getOauth2() != null ? this.getOauth2() : item);
    }

    @Override
    public String getProxyUrl() {
        return this.proxyUrl;
    }

    @Override
    public A withProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
        return (A)this;
    }

    @Override
    public Boolean hasProxyUrl() {
        return this.proxyUrl != null;
    }

    @Override
    @Deprecated
    public A withNewProxyUrl(String arg0) {
        return this.withProxyUrl(new String(arg0));
    }

    @Override
    public Boolean getReadRecent() {
        return this.readRecent;
    }

    @Override
    public A withReadRecent(Boolean readRecent) {
        this.readRecent = readRecent;
        return (A)this;
    }

    @Override
    public Boolean hasReadRecent() {
        return this.readRecent != null;
    }

    @Override
    public String getRemoteTimeout() {
        return this.remoteTimeout;
    }

    @Override
    public A withRemoteTimeout(String remoteTimeout) {
        this.remoteTimeout = remoteTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasRemoteTimeout() {
        return this.remoteTimeout != null;
    }

    @Override
    @Deprecated
    public A withNewRemoteTimeout(String arg0) {
        return this.withRemoteTimeout(new String(arg0));
    }

    @Override
    public A addToRequiredMatchers(String key, String value) {
        if (this.requiredMatchers == null && key != null && value != null) {
            this.requiredMatchers = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.requiredMatchers.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToRequiredMatchers(Map<String, String> map) {
        if (this.requiredMatchers == null && map != null) {
            this.requiredMatchers = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.requiredMatchers.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequiredMatchers(String key) {
        if (this.requiredMatchers == null) {
            return (A)this;
        }
        if (key != null && this.requiredMatchers != null) {
            this.requiredMatchers.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromRequiredMatchers(Map<String, String> map) {
        if (this.requiredMatchers == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.requiredMatchers == null) continue;
                this.requiredMatchers.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getRequiredMatchers() {
        return this.requiredMatchers;
    }

    @Override
    public <K, V> A withRequiredMatchers(Map<String, String> requiredMatchers) {
        this.requiredMatchers = requiredMatchers == null ? null : new LinkedHashMap<String, String>(requiredMatchers);
        return (A)this;
    }

    @Override
    public Boolean hasRequiredMatchers() {
        return this.requiredMatchers != null;
    }

    @Override
    @Deprecated
    public TLSConfig getTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    @Override
    public TLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    @Override
    public A withTlsConfig(TLSConfig tlsConfig) {
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
        if (tlsConfig != null) {
            this.tlsConfig = new TLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    @Override
    public RemoteReadSpecFluent.TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNestedImpl();
    }

    @Override
    public RemoteReadSpecFluent.TlsConfigNested<A> withNewTlsConfigLike(TLSConfig item) {
        return new TlsConfigNestedImpl(item);
    }

    @Override
    public RemoteReadSpecFluent.TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(this.getTlsConfig());
    }

    @Override
    public RemoteReadSpecFluent.TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(this.getTlsConfig() != null ? this.getTlsConfig() : new TLSConfigBuilder().build());
    }

    @Override
    public RemoteReadSpecFluent.TlsConfigNested<A> editOrNewTlsConfigLike(TLSConfig item) {
        return this.withNewTlsConfigLike(this.getTlsConfig() != null ? this.getTlsConfig() : item);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    @Override
    @Deprecated
    public A withNewUrl(String arg0) {
        return this.withUrl(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteReadSpecFluentImpl that = (RemoteReadSpecFluentImpl)o;
        if (this.authorization != null ? !this.authorization.equals(that.authorization) : that.authorization != null) {
            return false;
        }
        if (this.basicAuth != null ? !this.basicAuth.equals(that.basicAuth) : that.basicAuth != null) {
            return false;
        }
        if (this.bearerToken != null ? !this.bearerToken.equals(that.bearerToken) : that.bearerToken != null) {
            return false;
        }
        if (this.bearerTokenFile != null ? !this.bearerTokenFile.equals(that.bearerTokenFile) : that.bearerTokenFile != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.oauth2 != null ? !this.oauth2.equals(that.oauth2) : that.oauth2 != null) {
            return false;
        }
        if (this.proxyUrl != null ? !this.proxyUrl.equals(that.proxyUrl) : that.proxyUrl != null) {
            return false;
        }
        if (this.readRecent != null ? !this.readRecent.equals(that.readRecent) : that.readRecent != null) {
            return false;
        }
        if (this.remoteTimeout != null ? !this.remoteTimeout.equals(that.remoteTimeout) : that.remoteTimeout != null) {
            return false;
        }
        if (this.requiredMatchers != null ? !this.requiredMatchers.equals(that.requiredMatchers) : that.requiredMatchers != null) {
            return false;
        }
        if (this.tlsConfig != null ? !this.tlsConfig.equals(that.tlsConfig) : that.tlsConfig != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.authorization, this.basicAuth, this.bearerToken, this.bearerTokenFile, this.name, this.oauth2, this.proxyUrl, this.readRecent, this.remoteTimeout, this.requiredMatchers, this.tlsConfig, this.url, this.additionalProperties, super.hashCode());
    }

    public class TlsConfigNestedImpl<N>
    extends TLSConfigFluentImpl<RemoteReadSpecFluent.TlsConfigNested<N>>
    implements RemoteReadSpecFluent.TlsConfigNested<N>,
    Nested<N> {
        TLSConfigBuilder builder;

        TlsConfigNestedImpl(TLSConfig item) {
            this.builder = new TLSConfigBuilder(this, item);
        }

        TlsConfigNestedImpl() {
            this.builder = new TLSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)RemoteReadSpecFluentImpl.this.withTlsConfig(this.builder.build());
        }

        @Override
        public N endTlsConfig() {
            return this.and();
        }
    }

    public class Oauth2NestedImpl<N>
    extends OAuth2FluentImpl<RemoteReadSpecFluent.Oauth2Nested<N>>
    implements RemoteReadSpecFluent.Oauth2Nested<N>,
    Nested<N> {
        OAuth2Builder builder;

        Oauth2NestedImpl(OAuth2 item) {
            this.builder = new OAuth2Builder(this, item);
        }

        Oauth2NestedImpl() {
            this.builder = new OAuth2Builder(this);
        }

        @Override
        public N and() {
            return (N)RemoteReadSpecFluentImpl.this.withOauth2(this.builder.build());
        }

        @Override
        public N endOauth2() {
            return this.and();
        }
    }

    public class BasicAuthNestedImpl<N>
    extends BasicAuthFluentImpl<RemoteReadSpecFluent.BasicAuthNested<N>>
    implements RemoteReadSpecFluent.BasicAuthNested<N>,
    Nested<N> {
        BasicAuthBuilder builder;

        BasicAuthNestedImpl(BasicAuth item) {
            this.builder = new BasicAuthBuilder(this, item);
        }

        BasicAuthNestedImpl() {
            this.builder = new BasicAuthBuilder(this);
        }

        @Override
        public N and() {
            return (N)RemoteReadSpecFluentImpl.this.withBasicAuth(this.builder.build());
        }

        @Override
        public N endBasicAuth() {
            return this.and();
        }
    }

    public class AuthorizationNestedImpl<N>
    extends AuthorizationFluentImpl<RemoteReadSpecFluent.AuthorizationNested<N>>
    implements RemoteReadSpecFluent.AuthorizationNested<N>,
    Nested<N> {
        AuthorizationBuilder builder;

        AuthorizationNestedImpl(Authorization item) {
            this.builder = new AuthorizationBuilder(this, item);
        }

        AuthorizationNestedImpl() {
            this.builder = new AuthorizationBuilder(this);
        }

        @Override
        public N and() {
            return (N)RemoteReadSpecFluentImpl.this.withAuthorization(this.builder.build());
        }

        @Override
        public N endAuthorization() {
            return this.and();
        }
    }
}

