/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.extensions.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.extensions.IngressBackend;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendBuilder;
import io.fabric8.kubernetes.api.model.extensions.IngressBackendFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class HTTPIngressPathFluentImpl<A extends HTTPIngressPathFluent<A>>
extends BaseFluent<A>
implements HTTPIngressPathFluent<A> {
    private IngressBackendBuilder backend;
    private String path;
    private String pathType;
    private Map<String, Object> additionalProperties;

    public HTTPIngressPathFluentImpl() {
    }

    public HTTPIngressPathFluentImpl(HTTPIngressPath instance) {
        this.withBackend(instance.getBackend());
        this.withPath(instance.getPath());
        this.withPathType(instance.getPathType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public IngressBackend getBackend() {
        return this.backend != null ? this.backend.build() : null;
    }

    @Override
    public IngressBackend buildBackend() {
        return this.backend != null ? this.backend.build() : null;
    }

    @Override
    public A withBackend(IngressBackend backend) {
        this._visitables.get("backend").remove(this.backend);
        if (backend != null) {
            this.backend = new IngressBackendBuilder(backend);
            this._visitables.get("backend").add(this.backend);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBackend() {
        return this.backend != null;
    }

    @Override
    public HTTPIngressPathFluent.BackendNested<A> withNewBackend() {
        return new BackendNestedImpl();
    }

    @Override
    public HTTPIngressPathFluent.BackendNested<A> withNewBackendLike(IngressBackend item) {
        return new BackendNestedImpl(item);
    }

    @Override
    public HTTPIngressPathFluent.BackendNested<A> editBackend() {
        return this.withNewBackendLike(this.getBackend());
    }

    @Override
    public HTTPIngressPathFluent.BackendNested<A> editOrNewBackend() {
        return this.withNewBackendLike(this.getBackend() != null ? this.getBackend() : new IngressBackendBuilder().build());
    }

    @Override
    public HTTPIngressPathFluent.BackendNested<A> editOrNewBackendLike(IngressBackend item) {
        return this.withNewBackendLike(this.getBackend() != null ? this.getBackend() : item);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public A withNewPath(String arg0) {
        return this.withPath(new String(arg0));
    }

    @Override
    public String getPathType() {
        return this.pathType;
    }

    @Override
    public A withPathType(String pathType) {
        this.pathType = pathType;
        return (A)this;
    }

    @Override
    public Boolean hasPathType() {
        return this.pathType != null;
    }

    @Override
    @Deprecated
    public A withNewPathType(String arg0) {
        return this.withPathType(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPIngressPathFluentImpl that = (HTTPIngressPathFluentImpl)o;
        if (this.backend != null ? !this.backend.equals(that.backend) : that.backend != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.pathType != null ? !this.pathType.equals(that.pathType) : that.pathType != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.backend, this.path, this.pathType, this.additionalProperties, super.hashCode());
    }

    public class BackendNestedImpl<N>
    extends IngressBackendFluentImpl<HTTPIngressPathFluent.BackendNested<N>>
    implements HTTPIngressPathFluent.BackendNested<N>,
    Nested<N> {
        IngressBackendBuilder builder;

        BackendNestedImpl(IngressBackend item) {
            this.builder = new IngressBackendBuilder(this, item);
        }

        BackendNestedImpl() {
            this.builder = new IngressBackendBuilder(this);
        }

        @Override
        public N and() {
            return (N)HTTPIngressPathFluentImpl.this.withBackend(this.builder.build());
        }

        @Override
        public N endBackend() {
            return this.and();
        }
    }
}

