/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.gcp.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.gcp.v1.EncryptionKeyReference;
import io.fabric8.openshift.api.model.hive.gcp.v1.EncryptionKeyReferenceFluent;
import io.fabric8.openshift.api.model.hive.gcp.v1.KMSKeyReference;
import io.fabric8.openshift.api.model.hive.gcp.v1.KMSKeyReferenceBuilder;
import io.fabric8.openshift.api.model.hive.gcp.v1.KMSKeyReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class EncryptionKeyReferenceFluentImpl<A extends EncryptionKeyReferenceFluent<A>>
extends BaseFluent<A>
implements EncryptionKeyReferenceFluent<A> {
    private KMSKeyReferenceBuilder kmsKey;
    private String kmsKeyServiceAccount;
    private Map<String, Object> additionalProperties;

    public EncryptionKeyReferenceFluentImpl() {
    }

    public EncryptionKeyReferenceFluentImpl(EncryptionKeyReference instance) {
        this.withKmsKey(instance.getKmsKey());
        this.withKmsKeyServiceAccount(instance.getKmsKeyServiceAccount());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public KMSKeyReference getKmsKey() {
        return this.kmsKey != null ? this.kmsKey.build() : null;
    }

    @Override
    public KMSKeyReference buildKmsKey() {
        return this.kmsKey != null ? this.kmsKey.build() : null;
    }

    @Override
    public A withKmsKey(KMSKeyReference kmsKey) {
        this._visitables.get("kmsKey").remove(this.kmsKey);
        if (kmsKey != null) {
            this.kmsKey = new KMSKeyReferenceBuilder(kmsKey);
            this._visitables.get("kmsKey").add(this.kmsKey);
        }
        return (A)this;
    }

    @Override
    public Boolean hasKmsKey() {
        return this.kmsKey != null;
    }

    @Override
    public A withNewKmsKey(String keyRing, String location, String name, String projectID) {
        return this.withKmsKey(new KMSKeyReference(keyRing, location, name, projectID));
    }

    @Override
    public EncryptionKeyReferenceFluent.KmsKeyNested<A> withNewKmsKey() {
        return new KmsKeyNestedImpl();
    }

    @Override
    public EncryptionKeyReferenceFluent.KmsKeyNested<A> withNewKmsKeyLike(KMSKeyReference item) {
        return new KmsKeyNestedImpl(item);
    }

    @Override
    public EncryptionKeyReferenceFluent.KmsKeyNested<A> editKmsKey() {
        return this.withNewKmsKeyLike(this.getKmsKey());
    }

    @Override
    public EncryptionKeyReferenceFluent.KmsKeyNested<A> editOrNewKmsKey() {
        return this.withNewKmsKeyLike(this.getKmsKey() != null ? this.getKmsKey() : new KMSKeyReferenceBuilder().build());
    }

    @Override
    public EncryptionKeyReferenceFluent.KmsKeyNested<A> editOrNewKmsKeyLike(KMSKeyReference item) {
        return this.withNewKmsKeyLike(this.getKmsKey() != null ? this.getKmsKey() : item);
    }

    @Override
    public String getKmsKeyServiceAccount() {
        return this.kmsKeyServiceAccount;
    }

    @Override
    public A withKmsKeyServiceAccount(String kmsKeyServiceAccount) {
        this.kmsKeyServiceAccount = kmsKeyServiceAccount;
        return (A)this;
    }

    @Override
    public Boolean hasKmsKeyServiceAccount() {
        return this.kmsKeyServiceAccount != null;
    }

    @Override
    @Deprecated
    public A withNewKmsKeyServiceAccount(String arg0) {
        return this.withKmsKeyServiceAccount(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionKeyReferenceFluentImpl that = (EncryptionKeyReferenceFluentImpl)o;
        if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) {
            return false;
        }
        if (this.kmsKeyServiceAccount != null ? !this.kmsKeyServiceAccount.equals(that.kmsKeyServiceAccount) : that.kmsKeyServiceAccount != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.kmsKey, this.kmsKeyServiceAccount, this.additionalProperties, super.hashCode());
    }

    public class KmsKeyNestedImpl<N>
    extends KMSKeyReferenceFluentImpl<EncryptionKeyReferenceFluent.KmsKeyNested<N>>
    implements EncryptionKeyReferenceFluent.KmsKeyNested<N>,
    Nested<N> {
        KMSKeyReferenceBuilder builder;

        KmsKeyNestedImpl(KMSKeyReference item) {
            this.builder = new KMSKeyReferenceBuilder(this, item);
        }

        KmsKeyNestedImpl() {
            this.builder = new KMSKeyReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EncryptionKeyReferenceFluentImpl.this.withKmsKey(this.builder.build());
        }

        @Override
        public N endKmsKey() {
            return this.and();
        }
    }
}

