/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.metrics.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetrics;
import io.fabric8.kubernetes.api.model.metrics.v1beta1.ContainerMetricsFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ContainerMetricsFluentImpl<A extends ContainerMetricsFluent<A>>
extends BaseFluent<A>
implements ContainerMetricsFluent<A> {
    private String name;
    private Map<String, Quantity> usage;

    public ContainerMetricsFluentImpl() {
    }

    public ContainerMetricsFluentImpl(ContainerMetrics instance) {
        this.withName(instance.getName());
        this.withUsage(instance.getUsage());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A addToUsage(String key, Quantity value) {
        if (this.usage == null && key != null && value != null) {
            this.usage = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.usage.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToUsage(Map<String, Quantity> map) {
        if (this.usage == null && map != null) {
            this.usage = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.usage.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsage(String key) {
        if (this.usage == null) {
            return (A)this;
        }
        if (key != null && this.usage != null) {
            this.usage.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromUsage(Map<String, Quantity> map) {
        if (this.usage == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.usage == null) continue;
                this.usage.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getUsage() {
        return this.usage;
    }

    @Override
    public A withUsage(Map<String, Quantity> usage) {
        this.usage = usage == null ? null : new LinkedHashMap<String, Quantity>(usage);
        return (A)this;
    }

    @Override
    public Boolean hasUsage() {
        return this.usage != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerMetricsFluentImpl that = (ContainerMetricsFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.usage != null ? !this.usage.equals(that.usage) : that.usage != null);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.usage, super.hashCode());
    }
}

