/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ListerWatcher;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerEventListener;
import io.fabric8.kubernetes.client.informers.impl.DefaultSharedIndexInformer;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.Pluralize;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import okhttp3.OkHttpClient;

public class SharedInformerFactory
extends BaseOperation {
    private final Map<String, SharedIndexInformer> informers = new HashMap<String, SharedIndexInformer>();
    private final Map<String, Future> startedInformers = new HashMap<String, Future>();
    private final ExecutorService informerExecutor;
    private final BaseOperation baseOperation;
    private final ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners = new ConcurrentLinkedQueue();

    public SharedInformerFactory(ExecutorService threadPool, OkHttpClient okHttpClient, Config configuration) {
        super(new OperationContext().withOkhttpClient(okHttpClient).withConfig(configuration));
        this.initOperationContext(configuration);
        this.informerExecutor = threadPool;
        this.baseOperation = this.newInstance(this.context);
        this.namespace = null;
    }

    @Override
    public SharedInformerFactory inNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Override
    public SharedInformerFactory withName(String name) {
        this.name = name;
        return this;
    }

    public synchronized <T extends HasMetadata> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, KubernetesResourceUtil.inferListType(apiTypeClass), null, resyncPeriodInMillis);
    }

    public synchronized <T extends HasMetadata> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, OperationContext operationContext, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, KubernetesResourceUtil.inferListType(apiTypeClass), operationContext, resyncPeriodInMillis);
    }

    @Deprecated
    public synchronized <T extends CustomResource<?, ?>, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(CustomResourceDefinitionContext customResourceContext, Class<T> apiTypeClass, Class<L> apiListTypeClass, long resyncPeriodInMillis) {
        KubernetesDeserializer.registerCustomKind(String.format("%s/%s", Objects.requireNonNull(customResourceContext.getGroup()), Objects.requireNonNull(customResourceContext.getVersion())), Optional.ofNullable(customResourceContext.getKind()).orElse(apiTypeClass.getSimpleName()), apiTypeClass);
        return this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, this.context.withApiGroupName(customResourceContext.getGroup()).withApiGroupVersion(customResourceContext.getVersion()).withPlural(customResourceContext.getPlural()).withIsNamespaceConfiguredFromGlobalConfig(this.context.isNamespaceFromGlobalConfig()), resyncPeriodInMillis);
    }

    public synchronized <T extends CustomResource<?, ?>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(Class<T> apiTypeClass, OperationContext operationContext, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, KubernetesResourceUtil.inferListType(apiTypeClass), operationContext, resyncPeriodInMillis);
    }

    public synchronized <T extends CustomResource<?, ?>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(Class<T> apiTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerForCustomResource(apiTypeClass, KubernetesResourceUtil.inferListType(apiTypeClass), resyncPeriodInMillis);
    }

    public synchronized <T extends CustomResource<?, ?>, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerForCustomResource(Class<T> apiTypeClass, Class<L> apiListTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(apiTypeClass, apiListTypeClass, null, resyncPeriodInMillis);
    }

    private synchronized <T extends HasMetadata, L extends KubernetesResourceList<T>> SharedIndexInformer<T> sharedIndexInformerFor(Class<T> apiTypeClass, Class<L> apiListTypeClass, OperationContext operationContext, long resyncPeriodInMillis) {
        ListerWatcher<T, L> listerWatcher = this.listerWatcherFor(apiTypeClass, apiListTypeClass);
        OperationContext context = this.context.withApiGroupName(HasMetadata.getGroup(apiTypeClass)).withApiGroupVersion(HasMetadata.getVersion(apiTypeClass)).withPlural(CustomResource.getPlural(apiTypeClass)).withIsNamespaceConfiguredFromGlobalConfig(this.context.isNamespaceFromGlobalConfig());
        if (this.namespace != null) {
            context = context.withNamespace(this.namespace).withIsNamespaceConfiguredFromGlobalConfig(false);
        }
        if (this.name != null) {
            context = context.withFields(Collections.singletonMap("metadata.name", this.name));
        }
        if (operationContext != null) {
            context = context.withOperationContext(operationContext);
            if (operationContext.getNamespace() != null) {
                context = context.withIsNamespaceConfiguredFromGlobalConfig(false);
            }
        }
        DefaultSharedIndexInformer<T, L> informer = new DefaultSharedIndexInformer<T, L>(apiTypeClass, listerWatcher, resyncPeriodInMillis, context, this.eventListeners);
        this.informers.put(SharedInformerFactory.getInformerKey(context), informer);
        return informer;
    }

    private <T extends HasMetadata, L extends KubernetesResourceList<T>> ListerWatcher<T, L> listerWatcherFor(final Class<T> apiTypeClass, final Class<L> apiListTypeClass) {
        return new ListerWatcher<T, L>(){

            @Override
            public L list(ListOptions params, String namespace, OperationContext context) {
                BaseOperation listBaseOperation = SharedInformerFactory.this.getConfiguredBaseOperation(namespace, context, apiTypeClass, apiListTypeClass);
                SharedInformerFactory.this.registerKindToKubernetesDeserializer(apiTypeClass);
                return listBaseOperation.list();
            }

            @Override
            public Watch watch(ListOptions params, String namespace, OperationContext context, Watcher<T> resourceWatcher) {
                BaseOperation watchBaseOperation = SharedInformerFactory.this.getConfiguredBaseOperation(namespace, context, apiTypeClass, apiListTypeClass);
                SharedInformerFactory.this.registerKindToKubernetesDeserializer(apiTypeClass);
                return watchBaseOperation.watch(params.getResourceVersion(), resourceWatcher);
            }
        };
    }

    public synchronized <T> SharedIndexInformer<T> getExistingSharedIndexInformer(Class<T> apiTypeClass) {
        SharedIndexInformer foundSharedIndexInformer = null;
        for (Map.Entry<String, SharedIndexInformer> entry : this.informers.entrySet()) {
            if (!entry.getKey().contains(Pluralize.toPlural(apiTypeClass.getSimpleName().toLowerCase()))) continue;
            foundSharedIndexInformer = entry.getValue();
        }
        return foundSharedIndexInformer;
    }

    public synchronized void startAllRegisteredInformers() {
        if (this.informers.isEmpty()) {
            return;
        }
        if (!this.informerExecutor.isShutdown()) {
            this.informers.forEach((informerType, informer) -> this.startedInformers.computeIfAbsent((String)informerType, key -> this.informerExecutor.submit(informer::run)));
        }
    }

    public synchronized void stopAllRegisteredInformers() {
        this.stopAllRegisteredInformers(true);
    }

    public synchronized void stopAllRegisteredInformers(boolean shutDownThreadPool) {
        if (this.informers.isEmpty()) {
            return;
        }
        this.informers.forEach((informerType, informer) -> {
            if (this.startedInformers.remove(informerType) != null) {
                informer.stop();
            }
        });
        if (shutDownThreadPool) {
            this.informerExecutor.shutdown();
        }
    }

    public void addSharedInformerEventListener(SharedInformerEventListener event) {
        this.eventListeners.add(event);
    }

    Map<String, SharedIndexInformer> getInformers() {
        return this.informers;
    }

    static String getInformerKey(OperationContext operationContext) {
        StringBuilder keyBuilder = new StringBuilder();
        if (operationContext.getApiGroupName() == null) {
            keyBuilder.append(operationContext.getApiGroupVersion());
        } else {
            keyBuilder.append(operationContext.getApiGroupName()).append("/").append(operationContext.getApiGroupVersion());
        }
        keyBuilder.append(SharedInformerFactory.getKeyStrForField(operationContext.getPlural()));
        keyBuilder.append(SharedInformerFactory.getKeyStrForField(operationContext.getNamespace()));
        keyBuilder.append(SharedInformerFactory.getKeyStrForField(operationContext.getName()));
        return keyBuilder.toString();
    }

    private static String getKeyStrForField(String str) {
        StringBuilder keyBuilder = new StringBuilder();
        if (Utils.isNotNullOrEmpty(str)) {
            keyBuilder.append("/");
            keyBuilder.append(str);
        }
        return keyBuilder.toString();
    }

    private <T extends HasMetadata, L extends KubernetesResourceList<T>> BaseOperation<T, L, ?> getConfiguredBaseOperation(String namespace, OperationContext context, Class<T> apiTypeClass, Class<L> apiListTypeClass) {
        BaseOperation baseOperationWithContext = context.isNamespaceFromGlobalConfig() ? this.baseOperation.newInstance(context.withConfig(((ConfigBuilder)new ConfigBuilder(this.config).withNamespace(null)).build()).withNamespace(null)) : this.baseOperation.newInstance(context.withNamespace(namespace));
        baseOperationWithContext.setType(apiTypeClass);
        baseOperationWithContext.setListType(apiListTypeClass);
        return baseOperationWithContext;
    }

    private void initOperationContext(Config configuration) {
        if (configuration.getNamespace() != null) {
            this.context = this.context.withIsNamespaceConfiguredFromGlobalConfig(true);
        }
    }

    private <T extends HasMetadata> void registerKindToKubernetesDeserializer(Class<T> apiTypeClass) {
        if (CustomResource.class.isAssignableFrom(apiTypeClass)) {
            KubernetesDeserializer.registerCustomKind(HasMetadata.getApiVersion(apiTypeClass), apiTypeClass.getSimpleName(), apiTypeClass);
        }
    }
}

