/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.BinaryBuildSource;
import io.fabric8.openshift.api.model.BinaryBuildSourceBuilder;
import io.fabric8.openshift.api.model.BinaryBuildSourceFluentImpl;
import io.fabric8.openshift.api.model.BuildSource;
import io.fabric8.openshift.api.model.BuildSourceFluent;
import io.fabric8.openshift.api.model.ConfigMapBuildSource;
import io.fabric8.openshift.api.model.ConfigMapBuildSourceBuilder;
import io.fabric8.openshift.api.model.ConfigMapBuildSourceFluentImpl;
import io.fabric8.openshift.api.model.GitBuildSource;
import io.fabric8.openshift.api.model.GitBuildSourceBuilder;
import io.fabric8.openshift.api.model.GitBuildSourceFluentImpl;
import io.fabric8.openshift.api.model.ImageSource;
import io.fabric8.openshift.api.model.ImageSourceBuilder;
import io.fabric8.openshift.api.model.ImageSourceFluentImpl;
import io.fabric8.openshift.api.model.SecretBuildSource;
import io.fabric8.openshift.api.model.SecretBuildSourceBuilder;
import io.fabric8.openshift.api.model.SecretBuildSourceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class BuildSourceFluentImpl<A extends BuildSourceFluent<A>>
extends BaseFluent<A>
implements BuildSourceFluent<A> {
    private BinaryBuildSourceBuilder binary;
    private List<ConfigMapBuildSourceBuilder> configMaps = new ArrayList<ConfigMapBuildSourceBuilder>();
    private String contextDir;
    private String dockerfile;
    private GitBuildSourceBuilder git;
    private List<ImageSourceBuilder> images = new ArrayList<ImageSourceBuilder>();
    private List<SecretBuildSourceBuilder> secrets = new ArrayList<SecretBuildSourceBuilder>();
    private LocalObjectReferenceBuilder sourceSecret;
    private String type;

    public BuildSourceFluentImpl() {
    }

    public BuildSourceFluentImpl(BuildSource instance) {
        this.withBinary(instance.getBinary());
        this.withConfigMaps(instance.getConfigMaps());
        this.withContextDir(instance.getContextDir());
        this.withDockerfile(instance.getDockerfile());
        this.withGit(instance.getGit());
        this.withImages(instance.getImages());
        this.withSecrets(instance.getSecrets());
        this.withSourceSecret(instance.getSourceSecret());
        this.withType(instance.getType());
    }

    @Override
    @Deprecated
    public BinaryBuildSource getBinary() {
        return this.binary != null ? this.binary.build() : null;
    }

    @Override
    public BinaryBuildSource buildBinary() {
        return this.binary != null ? this.binary.build() : null;
    }

    @Override
    public A withBinary(BinaryBuildSource binary) {
        this._visitables.get("binary").remove(this.binary);
        if (binary != null) {
            this.binary = new BinaryBuildSourceBuilder(binary);
            this._visitables.get("binary").add(this.binary);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBinary() {
        return this.binary != null;
    }

    @Override
    public A withNewBinary(String asFile) {
        return this.withBinary(new BinaryBuildSource(asFile));
    }

    @Override
    public BuildSourceFluent.BinaryNested<A> withNewBinary() {
        return new BinaryNestedImpl();
    }

    @Override
    public BuildSourceFluent.BinaryNested<A> withNewBinaryLike(BinaryBuildSource item) {
        return new BinaryNestedImpl(item);
    }

    @Override
    public BuildSourceFluent.BinaryNested<A> editBinary() {
        return this.withNewBinaryLike(this.getBinary());
    }

    @Override
    public BuildSourceFluent.BinaryNested<A> editOrNewBinary() {
        return this.withNewBinaryLike(this.getBinary() != null ? this.getBinary() : new BinaryBuildSourceBuilder().build());
    }

    @Override
    public BuildSourceFluent.BinaryNested<A> editOrNewBinaryLike(BinaryBuildSource item) {
        return this.withNewBinaryLike(this.getBinary() != null ? this.getBinary() : item);
    }

    @Override
    public A addToConfigMaps(int index, ConfigMapBuildSource item) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<ConfigMapBuildSourceBuilder>();
        }
        ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);
        this._visitables.get("configMaps").add(index >= 0 ? index : this._visitables.get("configMaps").size(), builder);
        this.configMaps.add(index >= 0 ? index : this.configMaps.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConfigMaps(int index, ConfigMapBuildSource item) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<ConfigMapBuildSourceBuilder>();
        }
        ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get("configMaps").size()) {
            this._visitables.get("configMaps").add(builder);
        } else {
            this._visitables.get("configMaps").set(index, builder);
        }
        if (index < 0 || index >= this.configMaps.size()) {
            this.configMaps.add(builder);
        } else {
            this.configMaps.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConfigMaps(ConfigMapBuildSource ... items) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<ConfigMapBuildSourceBuilder>();
        }
        for (ConfigMapBuildSource item : items) {
            ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);
            this._visitables.get("configMaps").add(builder);
            this.configMaps.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConfigMaps(Collection<ConfigMapBuildSource> items) {
        if (this.configMaps == null) {
            this.configMaps = new ArrayList<ConfigMapBuildSourceBuilder>();
        }
        for (ConfigMapBuildSource item : items) {
            ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);
            this._visitables.get("configMaps").add(builder);
            this.configMaps.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfigMaps(ConfigMapBuildSource ... items) {
        for (ConfigMapBuildSource item : items) {
            ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);
            this._visitables.get("configMaps").remove(builder);
            if (this.configMaps == null) continue;
            this.configMaps.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConfigMaps(Collection<ConfigMapBuildSource> items) {
        for (ConfigMapBuildSource item : items) {
            ConfigMapBuildSourceBuilder builder = new ConfigMapBuildSourceBuilder(item);
            this._visitables.get("configMaps").remove(builder);
            if (this.configMaps == null) continue;
            this.configMaps.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConfigMaps(Predicate<ConfigMapBuildSourceBuilder> predicate) {
        if (this.configMaps == null) {
            return (A)this;
        }
        Iterator<ConfigMapBuildSourceBuilder> each = this.configMaps.iterator();
        Object visitables = this._visitables.get("configMaps");
        while (each.hasNext()) {
            ConfigMapBuildSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ConfigMapBuildSource> getConfigMaps() {
        return BuildSourceFluentImpl.build(this.configMaps);
    }

    @Override
    public List<ConfigMapBuildSource> buildConfigMaps() {
        return BuildSourceFluentImpl.build(this.configMaps);
    }

    @Override
    public ConfigMapBuildSource buildConfigMap(int index) {
        return this.configMaps.get(index).build();
    }

    @Override
    public ConfigMapBuildSource buildFirstConfigMap() {
        return this.configMaps.get(0).build();
    }

    @Override
    public ConfigMapBuildSource buildLastConfigMap() {
        return this.configMaps.get(this.configMaps.size() - 1).build();
    }

    @Override
    public ConfigMapBuildSource buildMatchingConfigMap(Predicate<ConfigMapBuildSourceBuilder> predicate) {
        for (ConfigMapBuildSourceBuilder item : this.configMaps) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConfigMap(Predicate<ConfigMapBuildSourceBuilder> predicate) {
        for (ConfigMapBuildSourceBuilder item : this.configMaps) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConfigMaps(List<ConfigMapBuildSource> configMaps) {
        if (this.configMaps != null) {
            this._visitables.get("configMaps").removeAll(this.configMaps);
        }
        if (configMaps != null) {
            this.configMaps = new ArrayList<ConfigMapBuildSourceBuilder>();
            for (ConfigMapBuildSource item : configMaps) {
                this.addToConfigMaps(item);
            }
        } else {
            this.configMaps = null;
        }
        return (A)this;
    }

    @Override
    public A withConfigMaps(ConfigMapBuildSource ... configMaps) {
        if (this.configMaps != null) {
            this.configMaps.clear();
        }
        if (configMaps != null) {
            for (ConfigMapBuildSource item : configMaps) {
                this.addToConfigMaps(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfigMaps() {
        return this.configMaps != null && !this.configMaps.isEmpty();
    }

    @Override
    public BuildSourceFluent.ConfigMapsNested<A> addNewConfigMap() {
        return new ConfigMapsNestedImpl();
    }

    @Override
    public BuildSourceFluent.ConfigMapsNested<A> addNewConfigMapLike(ConfigMapBuildSource item) {
        return new ConfigMapsNestedImpl(-1, item);
    }

    @Override
    public BuildSourceFluent.ConfigMapsNested<A> setNewConfigMapLike(int index, ConfigMapBuildSource item) {
        return new ConfigMapsNestedImpl(index, item);
    }

    @Override
    public BuildSourceFluent.ConfigMapsNested<A> editConfigMap(int index) {
        if (this.configMaps.size() <= index) {
            throw new RuntimeException("Can't edit configMaps. Index exceeds size.");
        }
        return this.setNewConfigMapLike(index, this.buildConfigMap(index));
    }

    @Override
    public BuildSourceFluent.ConfigMapsNested<A> editFirstConfigMap() {
        if (this.configMaps.size() == 0) {
            throw new RuntimeException("Can't edit first configMaps. The list is empty.");
        }
        return this.setNewConfigMapLike(0, this.buildConfigMap(0));
    }

    @Override
    public BuildSourceFluent.ConfigMapsNested<A> editLastConfigMap() {
        int index = this.configMaps.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configMaps. The list is empty.");
        }
        return this.setNewConfigMapLike(index, this.buildConfigMap(index));
    }

    @Override
    public BuildSourceFluent.ConfigMapsNested<A> editMatchingConfigMap(Predicate<ConfigMapBuildSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configMaps.size(); ++i) {
            if (!predicate.test(this.configMaps.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configMaps. No match found.");
        }
        return this.setNewConfigMapLike(index, this.buildConfigMap(index));
    }

    @Override
    public String getContextDir() {
        return this.contextDir;
    }

    @Override
    public A withContextDir(String contextDir) {
        this.contextDir = contextDir;
        return (A)this;
    }

    @Override
    public Boolean hasContextDir() {
        return this.contextDir != null;
    }

    @Override
    public A withNewContextDir(String arg1) {
        return this.withContextDir(new String(arg1));
    }

    @Override
    public A withNewContextDir(StringBuilder arg1) {
        return this.withContextDir(new String(arg1));
    }

    @Override
    public A withNewContextDir(StringBuffer arg1) {
        return this.withContextDir(new String(arg1));
    }

    @Override
    public String getDockerfile() {
        return this.dockerfile;
    }

    @Override
    public A withDockerfile(String dockerfile) {
        this.dockerfile = dockerfile;
        return (A)this;
    }

    @Override
    public Boolean hasDockerfile() {
        return this.dockerfile != null;
    }

    @Override
    public A withNewDockerfile(String arg1) {
        return this.withDockerfile(new String(arg1));
    }

    @Override
    public A withNewDockerfile(StringBuilder arg1) {
        return this.withDockerfile(new String(arg1));
    }

    @Override
    public A withNewDockerfile(StringBuffer arg1) {
        return this.withDockerfile(new String(arg1));
    }

    @Override
    @Deprecated
    public GitBuildSource getGit() {
        return this.git != null ? this.git.build() : null;
    }

    @Override
    public GitBuildSource buildGit() {
        return this.git != null ? this.git.build() : null;
    }

    @Override
    public A withGit(GitBuildSource git) {
        this._visitables.get("git").remove(this.git);
        if (git != null) {
            this.git = new GitBuildSourceBuilder(git);
            this._visitables.get("git").add(this.git);
        }
        return (A)this;
    }

    @Override
    public Boolean hasGit() {
        return this.git != null;
    }

    @Override
    public A withNewGit(String httpProxy, String httpsProxy, String noProxy, String ref, String uri) {
        return this.withGit(new GitBuildSource(httpProxy, httpsProxy, noProxy, ref, uri));
    }

    @Override
    public BuildSourceFluent.GitNested<A> withNewGit() {
        return new GitNestedImpl();
    }

    @Override
    public BuildSourceFluent.GitNested<A> withNewGitLike(GitBuildSource item) {
        return new GitNestedImpl(item);
    }

    @Override
    public BuildSourceFluent.GitNested<A> editGit() {
        return this.withNewGitLike(this.getGit());
    }

    @Override
    public BuildSourceFluent.GitNested<A> editOrNewGit() {
        return this.withNewGitLike(this.getGit() != null ? this.getGit() : new GitBuildSourceBuilder().build());
    }

    @Override
    public BuildSourceFluent.GitNested<A> editOrNewGitLike(GitBuildSource item) {
        return this.withNewGitLike(this.getGit() != null ? this.getGit() : item);
    }

    @Override
    public A addToImages(int index, ImageSource item) {
        if (this.images == null) {
            this.images = new ArrayList<ImageSourceBuilder>();
        }
        ImageSourceBuilder builder = new ImageSourceBuilder(item);
        this._visitables.get("images").add(index >= 0 ? index : this._visitables.get("images").size(), builder);
        this.images.add(index >= 0 ? index : this.images.size(), builder);
        return (A)this;
    }

    @Override
    public A setToImages(int index, ImageSource item) {
        if (this.images == null) {
            this.images = new ArrayList<ImageSourceBuilder>();
        }
        ImageSourceBuilder builder = new ImageSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get("images").size()) {
            this._visitables.get("images").add(builder);
        } else {
            this._visitables.get("images").set(index, builder);
        }
        if (index < 0 || index >= this.images.size()) {
            this.images.add(builder);
        } else {
            this.images.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImages(ImageSource ... items) {
        if (this.images == null) {
            this.images = new ArrayList<ImageSourceBuilder>();
        }
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImages(Collection<ImageSource> items) {
        if (this.images == null) {
            this.images = new ArrayList<ImageSourceBuilder>();
        }
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImages(ImageSource ... items) {
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.get("images").remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImages(Collection<ImageSource> items) {
        for (ImageSource item : items) {
            ImageSourceBuilder builder = new ImageSourceBuilder(item);
            this._visitables.get("images").remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImages(Predicate<ImageSourceBuilder> predicate) {
        if (this.images == null) {
            return (A)this;
        }
        Iterator<ImageSourceBuilder> each = this.images.iterator();
        Object visitables = this._visitables.get("images");
        while (each.hasNext()) {
            ImageSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageSource> getImages() {
        return BuildSourceFluentImpl.build(this.images);
    }

    @Override
    public List<ImageSource> buildImages() {
        return BuildSourceFluentImpl.build(this.images);
    }

    @Override
    public ImageSource buildImage(int index) {
        return this.images.get(index).build();
    }

    @Override
    public ImageSource buildFirstImage() {
        return this.images.get(0).build();
    }

    @Override
    public ImageSource buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    @Override
    public ImageSource buildMatchingImage(Predicate<ImageSourceBuilder> predicate) {
        for (ImageSourceBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImage(Predicate<ImageSourceBuilder> predicate) {
        for (ImageSourceBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImages(List<ImageSource> images) {
        if (this.images != null) {
            this._visitables.get("images").removeAll(this.images);
        }
        if (images != null) {
            this.images = new ArrayList<ImageSourceBuilder>();
            for (ImageSource item : images) {
                this.addToImages(item);
            }
        } else {
            this.images = null;
        }
        return (A)this;
    }

    @Override
    public A withImages(ImageSource ... images) {
        if (this.images != null) {
            this.images.clear();
        }
        if (images != null) {
            for (ImageSource item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> addNewImage() {
        return new ImagesNestedImpl();
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> addNewImageLike(ImageSource item) {
        return new ImagesNestedImpl(-1, item);
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> setNewImageLike(int index, ImageSource item) {
        return new ImagesNestedImpl(index, item);
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> editImage(int index) {
        if (this.images.size() <= index) {
            throw new RuntimeException("Can't edit images. Index exceeds size.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException("Can't edit first images. The list is empty.");
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last images. The list is empty.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public BuildSourceFluent.ImagesNested<A> editMatchingImage(Predicate<ImageSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.test(this.images.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching images. No match found.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public A addToSecrets(int index, SecretBuildSource item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<SecretBuildSourceBuilder>();
        }
        SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
        this._visitables.get("secrets").add(index >= 0 ? index : this._visitables.get("secrets").size(), builder);
        this.secrets.add(index >= 0 ? index : this.secrets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSecrets(int index, SecretBuildSource item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<SecretBuildSourceBuilder>();
        }
        SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get("secrets").size()) {
            this._visitables.get("secrets").add(builder);
        } else {
            this._visitables.get("secrets").set(index, builder);
        }
        if (index < 0 || index >= this.secrets.size()) {
            this.secrets.add(builder);
        } else {
            this.secrets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSecrets(SecretBuildSource ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<SecretBuildSourceBuilder>();
        }
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecrets(Collection<SecretBuildSource> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<SecretBuildSourceBuilder>();
        }
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.get("secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecrets(SecretBuildSource ... items) {
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.get("secrets").remove(builder);
            if (this.secrets == null) continue;
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecrets(Collection<SecretBuildSource> items) {
        for (SecretBuildSource item : items) {
            SecretBuildSourceBuilder builder = new SecretBuildSourceBuilder(item);
            this._visitables.get("secrets").remove(builder);
            if (this.secrets == null) continue;
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSecrets(Predicate<SecretBuildSourceBuilder> predicate) {
        if (this.secrets == null) {
            return (A)this;
        }
        Iterator<SecretBuildSourceBuilder> each = this.secrets.iterator();
        Object visitables = this._visitables.get("secrets");
        while (each.hasNext()) {
            SecretBuildSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SecretBuildSource> getSecrets() {
        return BuildSourceFluentImpl.build(this.secrets);
    }

    @Override
    public List<SecretBuildSource> buildSecrets() {
        return BuildSourceFluentImpl.build(this.secrets);
    }

    @Override
    public SecretBuildSource buildSecret(int index) {
        return this.secrets.get(index).build();
    }

    @Override
    public SecretBuildSource buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    @Override
    public SecretBuildSource buildLastSecret() {
        return this.secrets.get(this.secrets.size() - 1).build();
    }

    @Override
    public SecretBuildSource buildMatchingSecret(Predicate<SecretBuildSourceBuilder> predicate) {
        for (SecretBuildSourceBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSecret(Predicate<SecretBuildSourceBuilder> predicate) {
        for (SecretBuildSourceBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSecrets(List<SecretBuildSource> secrets) {
        if (this.secrets != null) {
            this._visitables.get("secrets").removeAll(this.secrets);
        }
        if (secrets != null) {
            this.secrets = new ArrayList<SecretBuildSourceBuilder>();
            for (SecretBuildSource item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)this;
    }

    @Override
    public A withSecrets(SecretBuildSource ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
        }
        if (secrets != null) {
            for (SecretBuildSource item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> addNewSecret() {
        return new SecretsNestedImpl();
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> addNewSecretLike(SecretBuildSource item) {
        return new SecretsNestedImpl(-1, item);
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> setNewSecretLike(int index, SecretBuildSource item) {
        return new SecretsNestedImpl(index, item);
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> editSecret(int index) {
        if (this.secrets.size() <= index) {
            throw new RuntimeException("Can't edit secrets. Index exceeds size.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> editFirstSecret() {
        if (this.secrets.size() == 0) {
            throw new RuntimeException("Can't edit first secrets. The list is empty.");
        }
        return this.setNewSecretLike(0, this.buildSecret(0));
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> editLastSecret() {
        int index = this.secrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secrets. The list is empty.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public BuildSourceFluent.SecretsNested<A> editMatchingSecret(Predicate<SecretBuildSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secrets.size(); ++i) {
            if (!predicate.test(this.secrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secrets. No match found.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    @Deprecated
    public LocalObjectReference getSourceSecret() {
        return this.sourceSecret != null ? this.sourceSecret.build() : null;
    }

    @Override
    public LocalObjectReference buildSourceSecret() {
        return this.sourceSecret != null ? this.sourceSecret.build() : null;
    }

    @Override
    public A withSourceSecret(LocalObjectReference sourceSecret) {
        this._visitables.get("sourceSecret").remove(this.sourceSecret);
        if (sourceSecret != null) {
            this.sourceSecret = new LocalObjectReferenceBuilder(sourceSecret);
            this._visitables.get("sourceSecret").add(this.sourceSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSourceSecret() {
        return this.sourceSecret != null;
    }

    @Override
    public A withNewSourceSecret(String name) {
        return this.withSourceSecret(new LocalObjectReference(name));
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<A> withNewSourceSecret() {
        return new SourceSecretNestedImpl();
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<A> withNewSourceSecretLike(LocalObjectReference item) {
        return new SourceSecretNestedImpl(item);
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<A> editSourceSecret() {
        return this.withNewSourceSecretLike(this.getSourceSecret());
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<A> editOrNewSourceSecret() {
        return this.withNewSourceSecretLike(this.getSourceSecret() != null ? this.getSourceSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public BuildSourceFluent.SourceSecretNested<A> editOrNewSourceSecretLike(LocalObjectReference item) {
        return this.withNewSourceSecretLike(this.getSourceSecret() != null ? this.getSourceSecret() : item);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public A withNewType(String arg1) {
        return this.withType(new String(arg1));
    }

    @Override
    public A withNewType(StringBuilder arg1) {
        return this.withType(new String(arg1));
    }

    @Override
    public A withNewType(StringBuffer arg1) {
        return this.withType(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildSourceFluentImpl that = (BuildSourceFluentImpl)o;
        if (this.binary != null ? !this.binary.equals(that.binary) : that.binary != null) {
            return false;
        }
        if (this.configMaps != null ? !this.configMaps.equals(that.configMaps) : that.configMaps != null) {
            return false;
        }
        if (this.contextDir != null ? !this.contextDir.equals(that.contextDir) : that.contextDir != null) {
            return false;
        }
        if (this.dockerfile != null ? !this.dockerfile.equals(that.dockerfile) : that.dockerfile != null) {
            return false;
        }
        if (this.git != null ? !this.git.equals(that.git) : that.git != null) {
            return false;
        }
        if (this.images != null ? !this.images.equals(that.images) : that.images != null) {
            return false;
        }
        if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) {
            return false;
        }
        if (this.sourceSecret != null ? !this.sourceSecret.equals(that.sourceSecret) : that.sourceSecret != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        return Objects.hash(this.binary, this.configMaps, this.contextDir, this.dockerfile, this.git, this.images, this.secrets, this.sourceSecret, this.type, super.hashCode());
    }

    public class SourceSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<BuildSourceFluent.SourceSecretNested<N>>
    implements BuildSourceFluent.SourceSecretNested<N>,
    Nested<N> {
        private final LocalObjectReferenceBuilder builder;

        SourceSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        SourceSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.withSourceSecret(this.builder.build());
        }

        @Override
        public N endSourceSecret() {
            return this.and();
        }
    }

    public class SecretsNestedImpl<N>
    extends SecretBuildSourceFluentImpl<BuildSourceFluent.SecretsNested<N>>
    implements BuildSourceFluent.SecretsNested<N>,
    Nested<N> {
        private final SecretBuildSourceBuilder builder;
        private final int index;

        SecretsNestedImpl(int index, SecretBuildSource item) {
            this.index = index;
            this.builder = new SecretBuildSourceBuilder(this, item);
        }

        SecretsNestedImpl() {
            this.index = -1;
            this.builder = new SecretBuildSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.setToSecrets(this.index, this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }

    public class ImagesNestedImpl<N>
    extends ImageSourceFluentImpl<BuildSourceFluent.ImagesNested<N>>
    implements BuildSourceFluent.ImagesNested<N>,
    Nested<N> {
        private final ImageSourceBuilder builder;
        private final int index;

        ImagesNestedImpl(int index, ImageSource item) {
            this.index = index;
            this.builder = new ImageSourceBuilder(this, item);
        }

        ImagesNestedImpl() {
            this.index = -1;
            this.builder = new ImageSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.setToImages(this.index, this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }

    public class GitNestedImpl<N>
    extends GitBuildSourceFluentImpl<BuildSourceFluent.GitNested<N>>
    implements BuildSourceFluent.GitNested<N>,
    Nested<N> {
        private final GitBuildSourceBuilder builder;

        GitNestedImpl(GitBuildSource item) {
            this.builder = new GitBuildSourceBuilder(this, item);
        }

        GitNestedImpl() {
            this.builder = new GitBuildSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.withGit(this.builder.build());
        }

        @Override
        public N endGit() {
            return this.and();
        }
    }

    public class ConfigMapsNestedImpl<N>
    extends ConfigMapBuildSourceFluentImpl<BuildSourceFluent.ConfigMapsNested<N>>
    implements BuildSourceFluent.ConfigMapsNested<N>,
    Nested<N> {
        private final ConfigMapBuildSourceBuilder builder;
        private final int index;

        ConfigMapsNestedImpl(int index, ConfigMapBuildSource item) {
            this.index = index;
            this.builder = new ConfigMapBuildSourceBuilder(this, item);
        }

        ConfigMapsNestedImpl() {
            this.index = -1;
            this.builder = new ConfigMapBuildSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.setToConfigMaps(this.index, this.builder.build());
        }

        @Override
        public N endConfigMap() {
            return this.and();
        }
    }

    public class BinaryNestedImpl<N>
    extends BinaryBuildSourceFluentImpl<BuildSourceFluent.BinaryNested<N>>
    implements BuildSourceFluent.BinaryNested<N>,
    Nested<N> {
        private final BinaryBuildSourceBuilder builder;

        BinaryNestedImpl(BinaryBuildSource item) {
            this.builder = new BinaryBuildSourceBuilder(this, item);
        }

        BinaryNestedImpl() {
            this.builder = new BinaryBuildSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildSourceFluentImpl.this.withBinary(this.builder.build());
        }

        @Override
        public N endBinary() {
            return this.and();
        }
    }
}

