/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperationRequestBuilder;
import io.fabric8.kubernetes.client.utils.ExponentialBackoffIntervalCalculator;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.MalformedURLException;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWatchManager<T extends HasMetadata>
implements Watch {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWatchManager.class);
    final Watcher<T> watcher;
    final AtomicReference<String> resourceVersion;
    final AtomicBoolean forceClosed;
    private final int reconnectLimit;
    private final ExponentialBackoffIntervalCalculator retryIntervalCalculator;
    final AtomicInteger currentReconnectAttempt;
    private ScheduledFuture<?> reconnectAttempt;
    private final BaseOperationRequestBuilder requestBuilder;
    protected final OkHttpClient client;
    private final AtomicBoolean reconnectPending = new AtomicBoolean(false);

    AbstractWatchManager(Watcher<T> watcher, BaseOperation<T, ?, ?> baseOperation, ListOptions listOptions, int reconnectLimit, int reconnectInterval, int maxIntervalExponent, Supplier<OkHttpClient> clientSupplier) throws MalformedURLException {
        this.watcher = watcher;
        this.reconnectLimit = reconnectLimit;
        this.retryIntervalCalculator = new ExponentialBackoffIntervalCalculator(reconnectInterval, maxIntervalExponent);
        this.resourceVersion = new AtomicReference<String>(listOptions.getResourceVersion());
        this.currentReconnectAttempt = new AtomicInteger(0);
        this.forceClosed = new AtomicBoolean();
        this.requestBuilder = new BaseOperationRequestBuilder(baseOperation, listOptions);
        this.client = clientSupplier.get();
        this.runWatch();
    }

    protected abstract void run(Request var1);

    protected abstract void closeRequest();

    final void close(WatcherException cause) {
        this.closeRequest();
        if (!this.watcher.reconnecting() && this.forceClosed.getAndSet(true)) {
            logger.debug("Ignoring duplicate firing of onClose event");
        } else {
            this.watcher.onClose(cause);
        }
        this.close();
    }

    final void closeEvent() {
        if (this.forceClosed.getAndSet(true)) {
            logger.debug("Ignoring duplicate firing of onClose event");
            return;
        }
        this.watcher.onClose();
    }

    final synchronized void cancelReconnect() {
        if (this.reconnectAttempt != null) {
            this.reconnectAttempt.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleReconnect() {
        if (!this.reconnectPending.compareAndSet(false, true)) {
            logger.debug("Reconnect already scheduled");
            return;
        }
        if (this.isForceClosed()) {
            logger.debug("Ignoring error for already closed/closing connection");
            return;
        }
        if (this.cannotReconnect()) {
            this.close(new WatcherException("Exhausted reconnects"));
            return;
        }
        logger.debug("Scheduling reconnect task");
        long delay = this.nextReconnectInterval();
        AbstractWatchManager abstractWatchManager = this;
        synchronized (abstractWatchManager) {
            this.reconnectAttempt = Utils.schedule(Utils.getCommonExecutorSerive(), () -> {
                try {
                    this.runWatch();
                    if (this.isForceClosed()) {
                        this.closeRequest();
                    }
                }
                catch (Exception e) {
                    logger.error("Exception in reconnect", (Throwable)e);
                    this.close(new WatcherException("Unhandled exception in reconnect attempt", e));
                }
                finally {
                    this.reconnectPending.set(false);
                }
            }, delay, TimeUnit.MILLISECONDS);
            if (this.isForceClosed()) {
                this.cancelReconnect();
            }
        }
    }

    final boolean cannotReconnect() {
        return !this.watcher.reconnecting() && this.currentReconnectAttempt.get() >= this.reconnectLimit && this.reconnectLimit >= 0;
    }

    final long nextReconnectInterval() {
        int exponentOfTwo = this.currentReconnectAttempt.getAndIncrement();
        long ret = this.retryIntervalCalculator.getInterval(exponentOfTwo);
        logger.debug("Current reconnect backoff is {} milliseconds (T{})", (Object)ret, (Object)exponentOfTwo);
        return ret;
    }

    void resetReconnectAttempts() {
        this.currentReconnectAttempt.set(0);
    }

    boolean isForceClosed() {
        return this.forceClosed.get();
    }

    void eventReceived(Watcher.Action action, HasMetadata resource) {
        if (resource != null && !this.requestBuilder.getBaseOperation().getType().isAssignableFrom(resource.getClass())) {
            resource = (HasMetadata)Serialization.jsonMapper().convertValue((Object)resource, this.requestBuilder.getBaseOperation().getType());
        }
        this.watcher.eventReceived(action, resource);
    }

    void updateResourceVersion(String newResourceVersion) {
        this.resourceVersion.set(newResourceVersion);
    }

    protected void runWatch() {
        Request request = this.requestBuilder.build(this.resourceVersion.get());
        logger.debug("Watching {}...", (Object)request.url());
        this.closeRequest();
        this.run(request);
    }

    @Override
    public void close() {
        logger.debug("Force closing the watch {}", (Object)this);
        this.closeEvent();
        this.closeRequest();
        this.cancelReconnect();
    }

    protected WatchEvent readWatchEvent(String messageSource) {
        WatchEvent event = Serialization.unmarshal(messageSource, WatchEvent.class);
        KubernetesResource object = null;
        if (event != null) {
            object = event.getObject();
        }
        if (object == null) {
            object = Serialization.unmarshal(messageSource, KubernetesResource.class);
            if (event == null) {
                event = new WatchEvent(object, "MODIFIED");
            } else {
                event.setObject(object);
            }
        }
        if (event.getType() == null) {
            event.setType("MODIFIED");
        }
        return event;
    }

    protected void onMessage(String message) {
        try {
            WatchEvent event = this.readWatchEvent(message);
            KubernetesResource object = event.getObject();
            if (object instanceof HasMetadata) {
                HasMetadata obj = (HasMetadata)object;
                this.updateResourceVersion(obj.getMetadata().getResourceVersion());
                Watcher.Action action = Watcher.Action.valueOf(event.getType());
                this.eventReceived(action, obj);
            } else if (object instanceof KubernetesResourceList) {
                KubernetesResourceList list = (KubernetesResourceList)((Object)object);
                this.updateResourceVersion(list.getMetadata().getResourceVersion());
                Watcher.Action action = Watcher.Action.valueOf(event.getType());
                List items = list.getItems();
                if (items != null) {
                    for (HasMetadata item : items) {
                        this.eventReceived(action, item);
                    }
                }
            } else if (object instanceof Status) {
                Status status = (Status)object;
                this.onStatus(status);
            } else {
                logger.error("Unknown message received: {}", (Object)message);
            }
        }
        catch (ClassCastException e) {
            logger.error("Received wrong type of object for watch", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error("Invalid event type", (Throwable)e);
        }
        catch (Exception e) {
            logger.error("Unhandled exception encountered in watcher event handler", (Throwable)e);
        }
    }

    protected boolean onStatus(Status status) {
        if (status.getCode() == 410) {
            this.close(new WatcherException(status.getMessage(), new KubernetesClientException(status)));
            return true;
        }
        this.eventReceived(Watcher.Action.ERROR, null);
        logger.error("Error received: {}", (Object)status);
        return false;
    }
}

