/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.CSVDescription;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.CSVDescriptionBuilder;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.CSVDescriptionFluentImpl;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.PackageChannel;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.PackageChannelFluent;
import java.util.Objects;

public class PackageChannelFluentImpl<A extends PackageChannelFluent<A>>
extends BaseFluent<A>
implements PackageChannelFluent<A> {
    private String currentCSV;
    private CSVDescriptionBuilder currentCSVDesc;
    private String name;

    public PackageChannelFluentImpl() {
    }

    public PackageChannelFluentImpl(PackageChannel instance) {
        this.withCurrentCSV(instance.getCurrentCSV());
        this.withCurrentCSVDesc(instance.getCurrentCSVDesc());
        this.withName(instance.getName());
    }

    @Override
    public String getCurrentCSV() {
        return this.currentCSV;
    }

    @Override
    public A withCurrentCSV(String currentCSV) {
        this.currentCSV = currentCSV;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentCSV() {
        return this.currentCSV != null;
    }

    @Override
    @Deprecated
    public A withNewCurrentCSV(String arg0) {
        return this.withCurrentCSV(new String(arg0));
    }

    @Override
    @Deprecated
    public CSVDescription getCurrentCSVDesc() {
        return this.currentCSVDesc != null ? this.currentCSVDesc.build() : null;
    }

    @Override
    public CSVDescription buildCurrentCSVDesc() {
        return this.currentCSVDesc != null ? this.currentCSVDesc.build() : null;
    }

    @Override
    public A withCurrentCSVDesc(CSVDescription currentCSVDesc) {
        this._visitables.get("currentCSVDesc").remove(this.currentCSVDesc);
        if (currentCSVDesc != null) {
            this.currentCSVDesc = new CSVDescriptionBuilder(currentCSVDesc);
            this._visitables.get("currentCSVDesc").add(this.currentCSVDesc);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCurrentCSVDesc() {
        return this.currentCSVDesc != null;
    }

    @Override
    public PackageChannelFluent.CurrentCSVDescNested<A> withNewCurrentCSVDesc() {
        return new CurrentCSVDescNestedImpl();
    }

    @Override
    public PackageChannelFluent.CurrentCSVDescNested<A> withNewCurrentCSVDescLike(CSVDescription item) {
        return new CurrentCSVDescNestedImpl(item);
    }

    @Override
    public PackageChannelFluent.CurrentCSVDescNested<A> editCurrentCSVDesc() {
        return this.withNewCurrentCSVDescLike(this.getCurrentCSVDesc());
    }

    @Override
    public PackageChannelFluent.CurrentCSVDescNested<A> editOrNewCurrentCSVDesc() {
        return this.withNewCurrentCSVDescLike(this.getCurrentCSVDesc() != null ? this.getCurrentCSVDesc() : new CSVDescriptionBuilder().build());
    }

    @Override
    public PackageChannelFluent.CurrentCSVDescNested<A> editOrNewCurrentCSVDescLike(CSVDescription item) {
        return this.withNewCurrentCSVDescLike(this.getCurrentCSVDesc() != null ? this.getCurrentCSVDesc() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageChannelFluentImpl that = (PackageChannelFluentImpl)o;
        if (this.currentCSV != null ? !this.currentCSV.equals(that.currentCSV) : that.currentCSV != null) {
            return false;
        }
        if (this.currentCSVDesc != null ? !this.currentCSVDesc.equals(that.currentCSVDesc) : that.currentCSVDesc != null) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return Objects.hash(this.currentCSV, this.currentCSVDesc, this.name, super.hashCode());
    }

    public class CurrentCSVDescNestedImpl<N>
    extends CSVDescriptionFluentImpl<PackageChannelFluent.CurrentCSVDescNested<N>>
    implements PackageChannelFluent.CurrentCSVDescNested<N>,
    Nested<N> {
        private final CSVDescriptionBuilder builder;

        CurrentCSVDescNestedImpl(CSVDescription item) {
            this.builder = new CSVDescriptionBuilder(this, item);
        }

        CurrentCSVDescNestedImpl() {
            this.builder = new CSVDescriptionBuilder(this);
        }

        @Override
        public N and() {
            return (N)PackageChannelFluentImpl.this.withCurrentCSVDesc(this.builder.build());
        }

        @Override
        public N endCurrentCSVDesc() {
            return this.and();
        }
    }
}

