/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.RouteIngress;
import io.fabric8.openshift.api.model.RouteIngressCondition;
import io.fabric8.openshift.api.model.RouteIngressConditionBuilder;
import io.fabric8.openshift.api.model.RouteIngressConditionFluentImpl;
import io.fabric8.openshift.api.model.RouteIngressFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class RouteIngressFluentImpl<A extends RouteIngressFluent<A>>
extends BaseFluent<A>
implements RouteIngressFluent<A> {
    private List<RouteIngressConditionBuilder> conditions = new ArrayList<RouteIngressConditionBuilder>();
    private String host;
    private String routerCanonicalHostname;
    private String routerName;
    private String wildcardPolicy;

    public RouteIngressFluentImpl() {
    }

    public RouteIngressFluentImpl(RouteIngress instance) {
        this.withConditions(instance.getConditions());
        this.withHost(instance.getHost());
        this.withRouterCanonicalHostname(instance.getRouterCanonicalHostname());
        this.withRouterName(instance.getRouterName());
        this.withWildcardPolicy(instance.getWildcardPolicy());
    }

    @Override
    public A addToConditions(Integer index, RouteIngressCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<RouteIngressConditionBuilder>();
        }
        RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, RouteIngressCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<RouteIngressConditionBuilder>();
        }
        RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(RouteIngressCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<RouteIngressConditionBuilder>();
        }
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<RouteIngressCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<RouteIngressConditionBuilder>();
        }
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(RouteIngressCondition ... items) {
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<RouteIngressCondition> items) {
        for (RouteIngressCondition item : items) {
            RouteIngressConditionBuilder builder = new RouteIngressConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<RouteIngressConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<RouteIngressConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            RouteIngressConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<RouteIngressCondition> getConditions() {
        return RouteIngressFluentImpl.build(this.conditions);
    }

    @Override
    public List<RouteIngressCondition> buildConditions() {
        return RouteIngressFluentImpl.build(this.conditions);
    }

    @Override
    public RouteIngressCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public RouteIngressCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public RouteIngressCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public RouteIngressCondition buildMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
        for (RouteIngressConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
        for (RouteIngressConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<RouteIngressCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<RouteIngressConditionBuilder>();
            for (RouteIngressCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(RouteIngressCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (RouteIngressCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new RouteIngressCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> addNewConditionLike(RouteIngressCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> setNewConditionLike(Integer index, RouteIngressCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public RouteIngressFluent.ConditionsNested<A> editMatchingCondition(Predicate<RouteIngressConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public A withHost(String host) {
        this.host = host;
        return (A)this;
    }

    @Override
    public Boolean hasHost() {
        return this.host != null;
    }

    @Override
    @Deprecated
    public A withNewHost(String arg0) {
        return this.withHost(new String(arg0));
    }

    @Override
    public String getRouterCanonicalHostname() {
        return this.routerCanonicalHostname;
    }

    @Override
    public A withRouterCanonicalHostname(String routerCanonicalHostname) {
        this.routerCanonicalHostname = routerCanonicalHostname;
        return (A)this;
    }

    @Override
    public Boolean hasRouterCanonicalHostname() {
        return this.routerCanonicalHostname != null;
    }

    @Override
    @Deprecated
    public A withNewRouterCanonicalHostname(String arg0) {
        return this.withRouterCanonicalHostname(new String(arg0));
    }

    @Override
    public String getRouterName() {
        return this.routerName;
    }

    @Override
    public A withRouterName(String routerName) {
        this.routerName = routerName;
        return (A)this;
    }

    @Override
    public Boolean hasRouterName() {
        return this.routerName != null;
    }

    @Override
    @Deprecated
    public A withNewRouterName(String arg0) {
        return this.withRouterName(new String(arg0));
    }

    @Override
    public String getWildcardPolicy() {
        return this.wildcardPolicy;
    }

    @Override
    public A withWildcardPolicy(String wildcardPolicy) {
        this.wildcardPolicy = wildcardPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasWildcardPolicy() {
        return this.wildcardPolicy != null;
    }

    @Override
    @Deprecated
    public A withNewWildcardPolicy(String arg0) {
        return this.withWildcardPolicy(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteIngressFluentImpl that = (RouteIngressFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.routerCanonicalHostname != null ? !this.routerCanonicalHostname.equals(that.routerCanonicalHostname) : that.routerCanonicalHostname != null) {
            return false;
        }
        if (this.routerName != null ? !this.routerName.equals(that.routerName) : that.routerName != null) {
            return false;
        }
        return !(this.wildcardPolicy != null ? !this.wildcardPolicy.equals(that.wildcardPolicy) : that.wildcardPolicy != null);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.host, this.routerCanonicalHostname, this.routerName, this.wildcardPolicy, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends RouteIngressConditionFluentImpl<RouteIngressFluent.ConditionsNested<N>>
    implements RouteIngressFluent.ConditionsNested<N>,
    Nested<N> {
        RouteIngressConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, RouteIngressCondition item) {
            this.index = index;
            this.builder = new RouteIngressConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new RouteIngressConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)RouteIngressFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

