/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.ParameterFluent;
import io.fabric8.openshift.api.model.ParameterFluentImpl;
import java.util.Objects;

public class ParameterBuilder
extends ParameterFluentImpl<ParameterBuilder>
implements VisitableBuilder<Parameter, ParameterBuilder> {
    ParameterFluent<?> fluent;
    Boolean validationEnabled;

    public ParameterBuilder() {
        this(false);
    }

    public ParameterBuilder(Boolean validationEnabled) {
        this(new Parameter(), validationEnabled);
    }

    public ParameterBuilder(ParameterFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ParameterBuilder(ParameterFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Parameter(), validationEnabled);
    }

    public ParameterBuilder(ParameterFluent<?> fluent, Parameter instance) {
        this(fluent, instance, false);
    }

    public ParameterBuilder(ParameterFluent<?> fluent, Parameter instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDescription(instance.getDescription());
        fluent.withDisplayName(instance.getDisplayName());
        fluent.withFrom(instance.getFrom());
        fluent.withGenerate(instance.getGenerate());
        fluent.withName(instance.getName());
        fluent.withRequired(instance.getRequired());
        fluent.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public ParameterBuilder(Parameter instance) {
        this(instance, (Boolean)false);
    }

    public ParameterBuilder(Parameter instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDescription(instance.getDescription());
        this.withDisplayName(instance.getDisplayName());
        this.withFrom(instance.getFrom());
        this.withGenerate(instance.getGenerate());
        this.withName(instance.getName());
        this.withRequired(instance.getRequired());
        this.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Parameter build() {
        Parameter buildable = new Parameter(this.fluent.getDescription(), this.fluent.getDisplayName(), this.fluent.getFrom(), this.fluent.getGenerate(), this.fluent.getName(), this.fluent.getRequired(), this.fluent.getValue());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterBuilder that = (ParameterBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

