/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookup;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookupCondition;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookupConditionBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookupConditionFluentImpl;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.BundleLookupFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class BundleLookupFluentImpl<A extends BundleLookupFluent<A>>
extends BaseFluent<A>
implements BundleLookupFluent<A> {
    private ObjectReferenceBuilder catalogSourceRef;
    private List<BundleLookupConditionBuilder> conditions = new ArrayList<BundleLookupConditionBuilder>();
    private String identifier;
    private String path;
    private String properties;
    private String replaces;

    public BundleLookupFluentImpl() {
    }

    public BundleLookupFluentImpl(BundleLookup instance) {
        this.withCatalogSourceRef(instance.getCatalogSourceRef());
        this.withConditions(instance.getConditions());
        this.withIdentifier(instance.getIdentifier());
        this.withPath(instance.getPath());
        this.withProperties(instance.getProperties());
        this.withReplaces(instance.getReplaces());
    }

    @Override
    @Deprecated
    public ObjectReference getCatalogSourceRef() {
        return this.catalogSourceRef != null ? this.catalogSourceRef.build() : null;
    }

    @Override
    public ObjectReference buildCatalogSourceRef() {
        return this.catalogSourceRef != null ? this.catalogSourceRef.build() : null;
    }

    @Override
    public A withCatalogSourceRef(ObjectReference catalogSourceRef) {
        this._visitables.get("catalogSourceRef").remove(this.catalogSourceRef);
        if (catalogSourceRef != null) {
            this.catalogSourceRef = new ObjectReferenceBuilder(catalogSourceRef);
            this._visitables.get("catalogSourceRef").add(this.catalogSourceRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCatalogSourceRef() {
        return this.catalogSourceRef != null;
    }

    @Override
    public BundleLookupFluent.CatalogSourceRefNested<A> withNewCatalogSourceRef() {
        return new CatalogSourceRefNestedImpl();
    }

    @Override
    public BundleLookupFluent.CatalogSourceRefNested<A> withNewCatalogSourceRefLike(ObjectReference item) {
        return new CatalogSourceRefNestedImpl(item);
    }

    @Override
    public BundleLookupFluent.CatalogSourceRefNested<A> editCatalogSourceRef() {
        return this.withNewCatalogSourceRefLike(this.getCatalogSourceRef());
    }

    @Override
    public BundleLookupFluent.CatalogSourceRefNested<A> editOrNewCatalogSourceRef() {
        return this.withNewCatalogSourceRefLike(this.getCatalogSourceRef() != null ? this.getCatalogSourceRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public BundleLookupFluent.CatalogSourceRefNested<A> editOrNewCatalogSourceRefLike(ObjectReference item) {
        return this.withNewCatalogSourceRefLike(this.getCatalogSourceRef() != null ? this.getCatalogSourceRef() : item);
    }

    @Override
    public A addToConditions(Integer index, BundleLookupCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<BundleLookupConditionBuilder>();
        }
        BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, BundleLookupCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<BundleLookupConditionBuilder>();
        }
        BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(BundleLookupCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<BundleLookupConditionBuilder>();
        }
        for (BundleLookupCondition item : items) {
            BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<BundleLookupCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<BundleLookupConditionBuilder>();
        }
        for (BundleLookupCondition item : items) {
            BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(BundleLookupCondition ... items) {
        for (BundleLookupCondition item : items) {
            BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<BundleLookupCondition> items) {
        for (BundleLookupCondition item : items) {
            BundleLookupConditionBuilder builder = new BundleLookupConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<BundleLookupConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<BundleLookupConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            BundleLookupConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<BundleLookupCondition> getConditions() {
        return BundleLookupFluentImpl.build(this.conditions);
    }

    @Override
    public List<BundleLookupCondition> buildConditions() {
        return BundleLookupFluentImpl.build(this.conditions);
    }

    @Override
    public BundleLookupCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public BundleLookupCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public BundleLookupCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public BundleLookupCondition buildMatchingCondition(Predicate<BundleLookupConditionBuilder> predicate) {
        for (BundleLookupConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<BundleLookupConditionBuilder> predicate) {
        for (BundleLookupConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<BundleLookupCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<BundleLookupConditionBuilder>();
            for (BundleLookupCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(BundleLookupCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (BundleLookupCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public BundleLookupFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public BundleLookupFluent.ConditionsNested<A> addNewConditionLike(BundleLookupCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public BundleLookupFluent.ConditionsNested<A> setNewConditionLike(Integer index, BundleLookupCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public BundleLookupFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public BundleLookupFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public BundleLookupFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public BundleLookupFluent.ConditionsNested<A> editMatchingCondition(Predicate<BundleLookupConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public A withIdentifier(String identifier) {
        this.identifier = identifier;
        return (A)this;
    }

    @Override
    public Boolean hasIdentifier() {
        return this.identifier != null;
    }

    @Override
    @Deprecated
    public A withNewIdentifier(String arg0) {
        return this.withIdentifier(new String(arg0));
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    @Deprecated
    public A withNewPath(String arg0) {
        return this.withPath(new String(arg0));
    }

    @Override
    public String getProperties() {
        return this.properties;
    }

    @Override
    public A withProperties(String properties) {
        this.properties = properties;
        return (A)this;
    }

    @Override
    public Boolean hasProperties() {
        return this.properties != null;
    }

    @Override
    @Deprecated
    public A withNewProperties(String arg0) {
        return this.withProperties(new String(arg0));
    }

    @Override
    public String getReplaces() {
        return this.replaces;
    }

    @Override
    public A withReplaces(String replaces) {
        this.replaces = replaces;
        return (A)this;
    }

    @Override
    public Boolean hasReplaces() {
        return this.replaces != null;
    }

    @Override
    @Deprecated
    public A withNewReplaces(String arg0) {
        return this.withReplaces(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundleLookupFluentImpl that = (BundleLookupFluentImpl)o;
        if (this.catalogSourceRef != null ? !this.catalogSourceRef.equals(that.catalogSourceRef) : that.catalogSourceRef != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(that.identifier) : that.identifier != null) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.properties != null ? !this.properties.equals(that.properties) : that.properties != null) {
            return false;
        }
        return !(this.replaces != null ? !this.replaces.equals(that.replaces) : that.replaces != null);
    }

    public int hashCode() {
        return Objects.hash(this.catalogSourceRef, this.conditions, this.identifier, this.path, this.properties, this.replaces, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends BundleLookupConditionFluentImpl<BundleLookupFluent.ConditionsNested<N>>
    implements BundleLookupFluent.ConditionsNested<N>,
    Nested<N> {
        BundleLookupConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, BundleLookupCondition item) {
            this.index = index;
            this.builder = new BundleLookupConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new BundleLookupConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)BundleLookupFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    public class CatalogSourceRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<BundleLookupFluent.CatalogSourceRefNested<N>>
    implements BundleLookupFluent.CatalogSourceRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        CatalogSourceRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        CatalogSourceRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BundleLookupFluentImpl.this.withCatalogSourceRef(this.builder.build());
        }

        @Override
        public N endCatalogSourceRef() {
            return this.and();
        }
    }
}

