/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.openshift.api.model.operator.v1.SFlowConfig;
import io.fabric8.openshift.api.model.operator.v1.SFlowConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class SFlowConfigFluentImpl<A extends SFlowConfigFluent<A>>
extends BaseFluent<A>
implements SFlowConfigFluent<A> {
    private List<String> collectors = new ArrayList<String>();

    public SFlowConfigFluentImpl() {
    }

    public SFlowConfigFluentImpl(SFlowConfig instance) {
        this.withCollectors(instance.getCollectors());
    }

    @Override
    public A addToCollectors(Integer index, String item) {
        if (this.collectors == null) {
            this.collectors = new ArrayList<String>();
        }
        this.collectors.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCollectors(Integer index, String item) {
        if (this.collectors == null) {
            this.collectors = new ArrayList<String>();
        }
        this.collectors.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCollectors(String ... items) {
        if (this.collectors == null) {
            this.collectors = new ArrayList<String>();
        }
        for (String item : items) {
            this.collectors.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCollectors(Collection<String> items) {
        if (this.collectors == null) {
            this.collectors = new ArrayList<String>();
        }
        for (String item : items) {
            this.collectors.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCollectors(String ... items) {
        for (String item : items) {
            if (this.collectors == null) continue;
            this.collectors.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCollectors(Collection<String> items) {
        for (String item : items) {
            if (this.collectors == null) continue;
            this.collectors.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCollectors() {
        return this.collectors;
    }

    @Override
    public String getCollector(Integer index) {
        return this.collectors.get(index);
    }

    @Override
    public String getFirstCollector() {
        return this.collectors.get(0);
    }

    @Override
    public String getLastCollector() {
        return this.collectors.get(this.collectors.size() - 1);
    }

    @Override
    public String getMatchingCollector(Predicate<String> predicate) {
        for (String item : this.collectors) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCollector(Predicate<String> predicate) {
        for (String item : this.collectors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCollectors(List<String> collectors) {
        if (collectors != null) {
            this.collectors = new ArrayList<String>();
            for (String item : collectors) {
                this.addToCollectors(item);
            }
        } else {
            this.collectors = null;
        }
        return (A)this;
    }

    @Override
    public A withCollectors(String ... collectors) {
        if (this.collectors != null) {
            this.collectors.clear();
        }
        if (collectors != null) {
            for (String item : collectors) {
                this.addToCollectors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCollectors() {
        return this.collectors != null && !this.collectors.isEmpty();
    }

    @Override
    public A addNewCollector(String arg0) {
        return this.addToCollectors(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SFlowConfigFluentImpl that = (SFlowConfigFluentImpl)o;
        return !(this.collectors != null ? !this.collectors.equals(that.collectors) : that.collectors != null);
    }

    public int hashCode() {
        return Objects.hash(this.collectors, super.hashCode());
    }
}

