/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operator.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNS;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNSFluent;
import io.fabric8.openshift.api.model.operator.v1.StaticIPAMDNSFluentImpl;
import java.util.Objects;

public class StaticIPAMDNSBuilder
extends StaticIPAMDNSFluentImpl<StaticIPAMDNSBuilder>
implements VisitableBuilder<StaticIPAMDNS, StaticIPAMDNSBuilder> {
    StaticIPAMDNSFluent<?> fluent;
    Boolean validationEnabled;

    public StaticIPAMDNSBuilder() {
        this(false);
    }

    public StaticIPAMDNSBuilder(Boolean validationEnabled) {
        this(new StaticIPAMDNS(), validationEnabled);
    }

    public StaticIPAMDNSBuilder(StaticIPAMDNSFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public StaticIPAMDNSBuilder(StaticIPAMDNSFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new StaticIPAMDNS(), validationEnabled);
    }

    public StaticIPAMDNSBuilder(StaticIPAMDNSFluent<?> fluent, StaticIPAMDNS instance) {
        this(fluent, instance, false);
    }

    public StaticIPAMDNSBuilder(StaticIPAMDNSFluent<?> fluent, StaticIPAMDNS instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDomain(instance.getDomain());
        fluent.withNameservers(instance.getNameservers());
        fluent.withSearch(instance.getSearch());
        this.validationEnabled = validationEnabled;
    }

    public StaticIPAMDNSBuilder(StaticIPAMDNS instance) {
        this(instance, (Boolean)false);
    }

    public StaticIPAMDNSBuilder(StaticIPAMDNS instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDomain(instance.getDomain());
        this.withNameservers(instance.getNameservers());
        this.withSearch(instance.getSearch());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public StaticIPAMDNS build() {
        StaticIPAMDNS buildable = new StaticIPAMDNS(this.fluent.getDomain(), this.fluent.getNameservers(), this.fluent.getSearch());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StaticIPAMDNSBuilder that = (StaticIPAMDNSBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

