/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.CSIVolumeSource;
import io.fabric8.kubernetes.api.model.CSIVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class CSIVolumeSourceFluentImpl<A extends CSIVolumeSourceFluent<A>>
extends BaseFluent<A>
implements CSIVolumeSourceFluent<A> {
    private String driver;
    private String fsType;
    private LocalObjectReferenceBuilder nodePublishSecretRef;
    private Boolean readOnly;
    private Map<String, String> volumeAttributes;
    private Map<String, Object> additionalProperties;

    public CSIVolumeSourceFluentImpl() {
    }

    public CSIVolumeSourceFluentImpl(CSIVolumeSource instance) {
        this.withDriver(instance.getDriver());
        this.withFsType(instance.getFsType());
        this.withNodePublishSecretRef(instance.getNodePublishSecretRef());
        this.withReadOnly(instance.getReadOnly());
        this.withVolumeAttributes(instance.getVolumeAttributes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getDriver() {
        return this.driver;
    }

    @Override
    public A withDriver(String driver) {
        this.driver = driver;
        return (A)this;
    }

    @Override
    public Boolean hasDriver() {
        return this.driver != null;
    }

    @Override
    public String getFsType() {
        return this.fsType;
    }

    @Override
    public A withFsType(String fsType) {
        this.fsType = fsType;
        return (A)this;
    }

    @Override
    public Boolean hasFsType() {
        return this.fsType != null;
    }

    @Override
    @Deprecated
    public LocalObjectReference getNodePublishSecretRef() {
        return this.nodePublishSecretRef != null ? this.nodePublishSecretRef.build() : null;
    }

    @Override
    public LocalObjectReference buildNodePublishSecretRef() {
        return this.nodePublishSecretRef != null ? this.nodePublishSecretRef.build() : null;
    }

    @Override
    public A withNodePublishSecretRef(LocalObjectReference nodePublishSecretRef) {
        this._visitables.get("nodePublishSecretRef").remove(this.nodePublishSecretRef);
        if (nodePublishSecretRef != null) {
            this.nodePublishSecretRef = new LocalObjectReferenceBuilder(nodePublishSecretRef);
            this._visitables.get("nodePublishSecretRef").add(this.nodePublishSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNodePublishSecretRef() {
        return this.nodePublishSecretRef != null;
    }

    @Override
    public A withNewNodePublishSecretRef(String name) {
        return this.withNodePublishSecretRef(new LocalObjectReference(name));
    }

    @Override
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRef() {
        return new NodePublishSecretRefNestedImpl();
    }

    @Override
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> withNewNodePublishSecretRefLike(LocalObjectReference item) {
        return new NodePublishSecretRefNestedImpl(item);
    }

    @Override
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(this.getNodePublishSecretRef());
    }

    @Override
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRef() {
        return this.withNewNodePublishSecretRefLike(this.getNodePublishSecretRef() != null ? this.getNodePublishSecretRef() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public CSIVolumeSourceFluent.NodePublishSecretRefNested<A> editOrNewNodePublishSecretRefLike(LocalObjectReference item) {
        return this.withNewNodePublishSecretRefLike(this.getNodePublishSecretRef() != null ? this.getNodePublishSecretRef() : item);
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public A addToVolumeAttributes(String key, String value) {
        if (this.volumeAttributes == null && key != null && value != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.volumeAttributes.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null && map != null) {
            this.volumeAttributes = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.volumeAttributes.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeAttributes(String key) {
        if (this.volumeAttributes == null) {
            return (A)this;
        }
        if (key != null && this.volumeAttributes != null) {
            this.volumeAttributes.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeAttributes(Map<String, String> map) {
        if (this.volumeAttributes == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.volumeAttributes == null) continue;
                this.volumeAttributes.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getVolumeAttributes() {
        return this.volumeAttributes;
    }

    @Override
    public <K, V> A withVolumeAttributes(Map<String, String> volumeAttributes) {
        this.volumeAttributes = volumeAttributes == null ? null : new LinkedHashMap<String, String>(volumeAttributes);
        return (A)this;
    }

    @Override
    public Boolean hasVolumeAttributes() {
        return this.volumeAttributes != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CSIVolumeSourceFluentImpl that = (CSIVolumeSourceFluentImpl)o;
        if (this.driver != null ? !this.driver.equals(that.driver) : that.driver != null) {
            return false;
        }
        if (this.fsType != null ? !this.fsType.equals(that.fsType) : that.fsType != null) {
            return false;
        }
        if (this.nodePublishSecretRef != null ? !this.nodePublishSecretRef.equals(that.nodePublishSecretRef) : that.nodePublishSecretRef != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.volumeAttributes != null ? !this.volumeAttributes.equals(that.volumeAttributes) : that.volumeAttributes != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.driver, this.fsType, this.nodePublishSecretRef, this.readOnly, this.volumeAttributes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver + ",");
        }
        if (this.fsType != null) {
            sb.append("fsType:");
            sb.append(this.fsType + ",");
        }
        if (this.nodePublishSecretRef != null) {
            sb.append("nodePublishSecretRef:");
            sb.append(this.nodePublishSecretRef + ",");
        }
        if (this.readOnly != null) {
            sb.append("readOnly:");
            sb.append(this.readOnly + ",");
        }
        if (this.volumeAttributes != null && !this.volumeAttributes.isEmpty()) {
            sb.append("volumeAttributes:");
            sb.append(this.volumeAttributes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withReadOnly() {
        return this.withReadOnly(true);
    }

    class NodePublishSecretRefNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<CSIVolumeSourceFluent.NodePublishSecretRefNested<N>>
    implements CSIVolumeSourceFluent.NodePublishSecretRefNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        NodePublishSecretRefNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        NodePublishSecretRefNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)CSIVolumeSourceFluentImpl.this.withNodePublishSecretRef(this.builder.build());
        }

        @Override
        public N endNodePublishSecretRef() {
            return this.and();
        }
    }
}

