/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ServicePortFluentImpl<A extends ServicePortFluent<A>>
extends BaseFluent<A>
implements ServicePortFluent<A> {
    private String appProtocol;
    private String name;
    private Integer nodePort;
    private Integer port;
    private String protocol;
    private IntOrStringBuilder targetPort;
    private Map<String, Object> additionalProperties;

    public ServicePortFluentImpl() {
    }

    public ServicePortFluentImpl(ServicePort instance) {
        this.withAppProtocol(instance.getAppProtocol());
        this.withName(instance.getName());
        this.withNodePort(instance.getNodePort());
        this.withPort(instance.getPort());
        this.withProtocol(instance.getProtocol());
        this.withTargetPort(instance.getTargetPort());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getAppProtocol() {
        return this.appProtocol;
    }

    @Override
    public A withAppProtocol(String appProtocol) {
        this.appProtocol = appProtocol;
        return (A)this;
    }

    @Override
    public Boolean hasAppProtocol() {
        return this.appProtocol != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public Integer getNodePort() {
        return this.nodePort;
    }

    @Override
    public A withNodePort(Integer nodePort) {
        this.nodePort = nodePort;
        return (A)this;
    }

    @Override
    public Boolean hasNodePort() {
        return this.nodePort != null;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public A withProtocol(String protocol) {
        this.protocol = protocol;
        return (A)this;
    }

    @Override
    public Boolean hasProtocol() {
        return this.protocol != null;
    }

    @Override
    @Deprecated
    public IntOrString getTargetPort() {
        return this.targetPort != null ? this.targetPort.build() : null;
    }

    @Override
    public IntOrString buildTargetPort() {
        return this.targetPort != null ? this.targetPort.build() : null;
    }

    @Override
    public A withTargetPort(IntOrString targetPort) {
        this._visitables.get("targetPort").remove(this.targetPort);
        if (targetPort != null) {
            this.targetPort = new IntOrStringBuilder(targetPort);
            this._visitables.get("targetPort").add(this.targetPort);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetPort() {
        return this.targetPort != null;
    }

    @Override
    public A withNewTargetPort(Object value) {
        return this.withTargetPort(new IntOrString(value));
    }

    @Override
    public ServicePortFluent.TargetPortNested<A> withNewTargetPort() {
        return new TargetPortNestedImpl();
    }

    @Override
    public ServicePortFluent.TargetPortNested<A> withNewTargetPortLike(IntOrString item) {
        return new TargetPortNestedImpl(item);
    }

    @Override
    public ServicePortFluent.TargetPortNested<A> editTargetPort() {
        return this.withNewTargetPortLike(this.getTargetPort());
    }

    @Override
    public ServicePortFluent.TargetPortNested<A> editOrNewTargetPort() {
        return this.withNewTargetPortLike(this.getTargetPort() != null ? this.getTargetPort() : new IntOrStringBuilder().build());
    }

    @Override
    public ServicePortFluent.TargetPortNested<A> editOrNewTargetPortLike(IntOrString item) {
        return this.withNewTargetPortLike(this.getTargetPort() != null ? this.getTargetPort() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServicePortFluentImpl that = (ServicePortFluentImpl)o;
        if (this.appProtocol != null ? !this.appProtocol.equals(that.appProtocol) : that.appProtocol != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.nodePort != null ? !this.nodePort.equals(that.nodePort) : that.nodePort != null) {
            return false;
        }
        if (this.port != null ? !this.port.equals(that.port) : that.port != null) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals(that.protocol) : that.protocol != null) {
            return false;
        }
        if (this.targetPort != null ? !this.targetPort.equals(that.targetPort) : that.targetPort != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.appProtocol, this.name, this.nodePort, this.port, this.protocol, this.targetPort, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appProtocol != null) {
            sb.append("appProtocol:");
            sb.append(this.appProtocol + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.nodePort != null) {
            sb.append("nodePort:");
            sb.append(this.nodePort + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.protocol != null) {
            sb.append("protocol:");
            sb.append(this.protocol + ",");
        }
        if (this.targetPort != null) {
            sb.append("targetPort:");
            sb.append(this.targetPort + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TargetPortNestedImpl<N>
    extends IntOrStringFluentImpl<ServicePortFluent.TargetPortNested<N>>
    implements ServicePortFluent.TargetPortNested<N>,
    Nested<N> {
        IntOrStringBuilder builder;

        TargetPortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        TargetPortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServicePortFluentImpl.this.withTargetPort(this.builder.build());
        }

        @Override
        public N endTargetPort() {
            return this.and();
        }
    }
}

