/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import io.fabric8.kubernetes.api.model.apps.ControllerRevision;
import io.fabric8.kubernetes.api.model.apps.ControllerRevisionBuilder;
import io.fabric8.kubernetes.api.model.apps.ControllerRevisionFluent;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.DaemonSetBuilder;
import io.fabric8.kubernetes.api.model.apps.DaemonSetFluentImpl;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.apps.DeploymentFluentImpl;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetBuilder;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetFluentImpl;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSetBuilder;
import io.fabric8.kubernetes.api.model.apps.StatefulSetFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ControllerRevisionFluentImpl<A extends ControllerRevisionFluent<A>>
extends BaseFluent<A>
implements ControllerRevisionFluent<A> {
    private String apiVersion;
    private VisitableBuilder<? extends HasMetadata, ?> data;
    private String kind;
    private ObjectMetaBuilder metadata;
    private Long revision;
    private Map<String, Object> additionalProperties;

    public ControllerRevisionFluentImpl() {
    }

    public ControllerRevisionFluentImpl(ControllerRevision instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withData(instance.getData());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRevision(instance.getRevision());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public HasMetadata getData() {
        return this.data != null ? (HasMetadata)this.data.build() : null;
    }

    @Override
    public HasMetadata buildData() {
        return this.data != null ? (HasMetadata)this.data.build() : null;
    }

    @Override
    public A withData(HasMetadata data) {
        if (data instanceof ReplicaSet) {
            this.data = new ReplicaSetBuilder((ReplicaSet)data);
            this._visitables.get("data").add(this.data);
        }
        if (data instanceof DaemonSet) {
            this.data = new DaemonSetBuilder((DaemonSet)data);
            this._visitables.get("data").add(this.data);
        }
        if (data instanceof ControllerRevision) {
            this.data = new ControllerRevisionBuilder((ControllerRevision)data);
            this._visitables.get("data").add(this.data);
        }
        if (data instanceof StatefulSet) {
            this.data = new StatefulSetBuilder((StatefulSet)data);
            this._visitables.get("data").add(this.data);
        }
        if (data instanceof PersistentVolumeClaim) {
            this.data = new PersistentVolumeClaimBuilder((PersistentVolumeClaim)data);
            this._visitables.get("data").add(this.data);
        }
        if (data instanceof Deployment) {
            this.data = new DeploymentBuilder((Deployment)data);
            this._visitables.get("data").add(this.data);
        }
        return (A)this;
    }

    @Override
    public Boolean hasData() {
        return this.data != null;
    }

    @Override
    public A withReplicaSetData(ReplicaSet replicaSetData) {
        this._visitables.get("data").remove(this.data);
        if (replicaSetData != null) {
            this.data = new ReplicaSetBuilder(replicaSetData);
            this._visitables.get("data").add(this.data);
        }
        return (A)this;
    }

    @Override
    public ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetData() {
        return new ReplicaSetDataNestedImpl();
    }

    @Override
    public ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetDataLike(ReplicaSet item) {
        return new ReplicaSetDataNestedImpl(item);
    }

    @Override
    public A withDaemonSetData(DaemonSet daemonSetData) {
        this._visitables.get("data").remove(this.data);
        if (daemonSetData != null) {
            this.data = new DaemonSetBuilder(daemonSetData);
            this._visitables.get("data").add(this.data);
        }
        return (A)this;
    }

    @Override
    public ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetData() {
        return new DaemonSetDataNestedImpl();
    }

    @Override
    public ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetDataLike(DaemonSet item) {
        return new DaemonSetDataNestedImpl(item);
    }

    @Override
    public A withControllerRevisionData(ControllerRevision controllerRevisionData) {
        this._visitables.get("data").remove(this.data);
        if (controllerRevisionData != null) {
            this.data = new ControllerRevisionBuilder(controllerRevisionData);
            this._visitables.get("data").add(this.data);
        }
        return (A)this;
    }

    @Override
    public ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionData() {
        return new ControllerRevisionDataNestedImpl();
    }

    @Override
    public ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionDataLike(ControllerRevision item) {
        return new ControllerRevisionDataNestedImpl(item);
    }

    @Override
    public A withStatefulSetData(StatefulSet statefulSetData) {
        this._visitables.get("data").remove(this.data);
        if (statefulSetData != null) {
            this.data = new StatefulSetBuilder(statefulSetData);
            this._visitables.get("data").add(this.data);
        }
        return (A)this;
    }

    @Override
    public ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetData() {
        return new StatefulSetDataNestedImpl();
    }

    @Override
    public ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetDataLike(StatefulSet item) {
        return new StatefulSetDataNestedImpl(item);
    }

    @Override
    public A withPersistentVolumeClaimData(PersistentVolumeClaim persistentVolumeClaimData) {
        this._visitables.get("data").remove(this.data);
        if (persistentVolumeClaimData != null) {
            this.data = new PersistentVolumeClaimBuilder(persistentVolumeClaimData);
            this._visitables.get("data").add(this.data);
        }
        return (A)this;
    }

    @Override
    public ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimData() {
        return new PersistentVolumeClaimDataNestedImpl();
    }

    @Override
    public ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimDataLike(PersistentVolumeClaim item) {
        return new PersistentVolumeClaimDataNestedImpl(item);
    }

    @Override
    public A withDeploymentData(Deployment deploymentData) {
        this._visitables.get("data").remove(this.data);
        if (deploymentData != null) {
            this.data = new DeploymentBuilder(deploymentData);
            this._visitables.get("data").add(this.data);
        }
        return (A)this;
    }

    @Override
    public ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentData() {
        return new DeploymentDataNestedImpl();
    }

    @Override
    public ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentDataLike(Deployment item) {
        return new DeploymentDataNestedImpl(item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ControllerRevisionFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ControllerRevisionFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ControllerRevisionFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ControllerRevisionFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ControllerRevisionFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public Long getRevision() {
        return this.revision;
    }

    @Override
    public A withRevision(Long revision) {
        this.revision = revision;
        return (A)this;
    }

    @Override
    public Boolean hasRevision() {
        return this.revision != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ControllerRevisionFluentImpl that = (ControllerRevisionFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.revision != null ? !this.revision.equals(that.revision) : that.revision != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.data, this.kind, this.metadata, this.revision, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.data != null) {
            sb.append("data:");
            sb.append(this.data + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.revision != null) {
            sb.append("revision:");
            sb.append(this.revision + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ControllerRevisionFluent.MetadataNested<N>>
    implements ControllerRevisionFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ControllerRevisionFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class DeploymentDataNestedImpl<N>
    extends DeploymentFluentImpl<ControllerRevisionFluent.DeploymentDataNested<N>>
    implements ControllerRevisionFluent.DeploymentDataNested<N>,
    Nested<N> {
        DeploymentBuilder builder;

        DeploymentDataNestedImpl(Deployment item) {
            this.builder = new DeploymentBuilder(this, item);
        }

        DeploymentDataNestedImpl() {
            this.builder = new DeploymentBuilder(this);
        }

        @Override
        public N and() {
            return (N)ControllerRevisionFluentImpl.this.withData(this.builder.build());
        }

        @Override
        public N endDeploymentData() {
            return this.and();
        }
    }

    class PersistentVolumeClaimDataNestedImpl<N>
    extends PersistentVolumeClaimFluentImpl<ControllerRevisionFluent.PersistentVolumeClaimDataNested<N>>
    implements ControllerRevisionFluent.PersistentVolumeClaimDataNested<N>,
    Nested<N> {
        PersistentVolumeClaimBuilder builder;

        PersistentVolumeClaimDataNestedImpl(PersistentVolumeClaim item) {
            this.builder = new PersistentVolumeClaimBuilder(this, item);
        }

        PersistentVolumeClaimDataNestedImpl() {
            this.builder = new PersistentVolumeClaimBuilder(this);
        }

        @Override
        public N and() {
            return (N)ControllerRevisionFluentImpl.this.withData(this.builder.build());
        }

        @Override
        public N endPersistentVolumeClaimData() {
            return this.and();
        }
    }

    class StatefulSetDataNestedImpl<N>
    extends StatefulSetFluentImpl<ControllerRevisionFluent.StatefulSetDataNested<N>>
    implements ControllerRevisionFluent.StatefulSetDataNested<N>,
    Nested<N> {
        StatefulSetBuilder builder;

        StatefulSetDataNestedImpl(StatefulSet item) {
            this.builder = new StatefulSetBuilder(this, item);
        }

        StatefulSetDataNestedImpl() {
            this.builder = new StatefulSetBuilder(this);
        }

        @Override
        public N and() {
            return (N)ControllerRevisionFluentImpl.this.withData(this.builder.build());
        }

        @Override
        public N endStatefulSetData() {
            return this.and();
        }
    }

    class ControllerRevisionDataNestedImpl<N>
    extends ControllerRevisionFluentImpl<ControllerRevisionFluent.ControllerRevisionDataNested<N>>
    implements ControllerRevisionFluent.ControllerRevisionDataNested<N>,
    Nested<N> {
        ControllerRevisionBuilder builder;

        ControllerRevisionDataNestedImpl(ControllerRevision item) {
            this.builder = new ControllerRevisionBuilder(this, item);
        }

        ControllerRevisionDataNestedImpl() {
            this.builder = new ControllerRevisionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ControllerRevisionFluentImpl.this.withData(this.builder.build());
        }

        @Override
        public N endControllerRevisionData() {
            return this.and();
        }
    }

    class DaemonSetDataNestedImpl<N>
    extends DaemonSetFluentImpl<ControllerRevisionFluent.DaemonSetDataNested<N>>
    implements ControllerRevisionFluent.DaemonSetDataNested<N>,
    Nested<N> {
        DaemonSetBuilder builder;

        DaemonSetDataNestedImpl(DaemonSet item) {
            this.builder = new DaemonSetBuilder(this, item);
        }

        DaemonSetDataNestedImpl() {
            this.builder = new DaemonSetBuilder(this);
        }

        @Override
        public N and() {
            return (N)ControllerRevisionFluentImpl.this.withData(this.builder.build());
        }

        @Override
        public N endDaemonSetData() {
            return this.and();
        }
    }

    class ReplicaSetDataNestedImpl<N>
    extends ReplicaSetFluentImpl<ControllerRevisionFluent.ReplicaSetDataNested<N>>
    implements ControllerRevisionFluent.ReplicaSetDataNested<N>,
    Nested<N> {
        ReplicaSetBuilder builder;

        ReplicaSetDataNestedImpl(ReplicaSet item) {
            this.builder = new ReplicaSetBuilder(this, item);
        }

        ReplicaSetDataNestedImpl() {
            this.builder = new ReplicaSetBuilder(this);
        }

        @Override
        public N and() {
            return (N)ControllerRevisionFluentImpl.this.withData(this.builder.build());
        }

        @Override
        public N endReplicaSetData() {
            return this.and();
        }
    }
}

