/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.batch.v1.JobCondition;
import io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.JobConditionFluentImpl;
import io.fabric8.kubernetes.api.model.batch.v1.JobStatus;
import io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent;
import io.fabric8.kubernetes.api.model.batch.v1.UncountedTerminatedPods;
import io.fabric8.kubernetes.api.model.batch.v1.UncountedTerminatedPodsBuilder;
import io.fabric8.kubernetes.api.model.batch.v1.UncountedTerminatedPodsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class JobStatusFluentImpl<A extends JobStatusFluent<A>>
extends BaseFluent<A>
implements JobStatusFluent<A> {
    private Integer active;
    private String completedIndexes;
    private String completionTime;
    private ArrayList<JobConditionBuilder> conditions = new ArrayList();
    private Integer failed;
    private Integer ready;
    private String startTime;
    private Integer succeeded;
    private UncountedTerminatedPodsBuilder uncountedTerminatedPods;
    private Map<String, Object> additionalProperties;

    public JobStatusFluentImpl() {
    }

    public JobStatusFluentImpl(JobStatus instance) {
        this.withActive(instance.getActive());
        this.withCompletedIndexes(instance.getCompletedIndexes());
        this.withCompletionTime(instance.getCompletionTime());
        this.withConditions(instance.getConditions());
        this.withFailed(instance.getFailed());
        this.withReady(instance.getReady());
        this.withStartTime(instance.getStartTime());
        this.withSucceeded(instance.getSucceeded());
        this.withUncountedTerminatedPods(instance.getUncountedTerminatedPods());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Integer getActive() {
        return this.active;
    }

    @Override
    public A withActive(Integer active) {
        this.active = active;
        return (A)this;
    }

    @Override
    public Boolean hasActive() {
        return this.active != null;
    }

    @Override
    public String getCompletedIndexes() {
        return this.completedIndexes;
    }

    @Override
    public A withCompletedIndexes(String completedIndexes) {
        this.completedIndexes = completedIndexes;
        return (A)this;
    }

    @Override
    public Boolean hasCompletedIndexes() {
        return this.completedIndexes != null;
    }

    @Override
    public String getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public A withCompletionTime(String completionTime) {
        this.completionTime = completionTime;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionTime() {
        return this.completionTime != null;
    }

    @Override
    public A addToConditions(Integer index, JobCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        JobConditionBuilder builder = new JobConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, JobCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        JobConditionBuilder builder = new JobConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(JobCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<JobCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(JobCondition ... items) {
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<JobCondition> items) {
        for (JobCondition item : items) {
            JobConditionBuilder builder = new JobConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<JobConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<JobConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            JobConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<JobCondition> getConditions() {
        return this.conditions != null ? JobStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<JobCondition> buildConditions() {
        return this.conditions != null ? JobStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public JobCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public JobCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public JobCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public JobCondition buildMatchingCondition(Predicate<JobConditionBuilder> predicate) {
        for (JobConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<JobConditionBuilder> predicate) {
        for (JobConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<JobCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (JobCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(JobCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (JobCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> addNewConditionLike(JobCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, JobCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public JobStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<JobConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Integer getFailed() {
        return this.failed;
    }

    @Override
    public A withFailed(Integer failed) {
        this.failed = failed;
        return (A)this;
    }

    @Override
    public Boolean hasFailed() {
        return this.failed != null;
    }

    @Override
    public Integer getReady() {
        return this.ready;
    }

    @Override
    public A withReady(Integer ready) {
        this.ready = ready;
        return (A)this;
    }

    @Override
    public Boolean hasReady() {
        return this.ready != null;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(String startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    @Override
    public Integer getSucceeded() {
        return this.succeeded;
    }

    @Override
    public A withSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
        return (A)this;
    }

    @Override
    public Boolean hasSucceeded() {
        return this.succeeded != null;
    }

    @Override
    @Deprecated
    public UncountedTerminatedPods getUncountedTerminatedPods() {
        return this.uncountedTerminatedPods != null ? this.uncountedTerminatedPods.build() : null;
    }

    @Override
    public UncountedTerminatedPods buildUncountedTerminatedPods() {
        return this.uncountedTerminatedPods != null ? this.uncountedTerminatedPods.build() : null;
    }

    @Override
    public A withUncountedTerminatedPods(UncountedTerminatedPods uncountedTerminatedPods) {
        this._visitables.get("uncountedTerminatedPods").remove(this.uncountedTerminatedPods);
        if (uncountedTerminatedPods != null) {
            this.uncountedTerminatedPods = new UncountedTerminatedPodsBuilder(uncountedTerminatedPods);
            this._visitables.get("uncountedTerminatedPods").add(this.uncountedTerminatedPods);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUncountedTerminatedPods() {
        return this.uncountedTerminatedPods != null;
    }

    @Override
    public JobStatusFluent.UncountedTerminatedPodsNested<A> withNewUncountedTerminatedPods() {
        return new UncountedTerminatedPodsNestedImpl();
    }

    @Override
    public JobStatusFluent.UncountedTerminatedPodsNested<A> withNewUncountedTerminatedPodsLike(UncountedTerminatedPods item) {
        return new UncountedTerminatedPodsNestedImpl(item);
    }

    @Override
    public JobStatusFluent.UncountedTerminatedPodsNested<A> editUncountedTerminatedPods() {
        return this.withNewUncountedTerminatedPodsLike(this.getUncountedTerminatedPods());
    }

    @Override
    public JobStatusFluent.UncountedTerminatedPodsNested<A> editOrNewUncountedTerminatedPods() {
        return this.withNewUncountedTerminatedPodsLike(this.getUncountedTerminatedPods() != null ? this.getUncountedTerminatedPods() : new UncountedTerminatedPodsBuilder().build());
    }

    @Override
    public JobStatusFluent.UncountedTerminatedPodsNested<A> editOrNewUncountedTerminatedPodsLike(UncountedTerminatedPods item) {
        return this.withNewUncountedTerminatedPodsLike(this.getUncountedTerminatedPods() != null ? this.getUncountedTerminatedPods() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobStatusFluentImpl that = (JobStatusFluentImpl)o;
        if (this.active != null ? !this.active.equals(that.active) : that.active != null) {
            return false;
        }
        if (this.completedIndexes != null ? !this.completedIndexes.equals(that.completedIndexes) : that.completedIndexes != null) {
            return false;
        }
        if (this.completionTime != null ? !this.completionTime.equals(that.completionTime) : that.completionTime != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.failed != null ? !this.failed.equals(that.failed) : that.failed != null) {
            return false;
        }
        if (this.ready != null ? !this.ready.equals(that.ready) : that.ready != null) {
            return false;
        }
        if (this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null) {
            return false;
        }
        if (this.succeeded != null ? !this.succeeded.equals(that.succeeded) : that.succeeded != null) {
            return false;
        }
        if (this.uncountedTerminatedPods != null ? !this.uncountedTerminatedPods.equals(that.uncountedTerminatedPods) : that.uncountedTerminatedPods != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.active, this.completedIndexes, this.completionTime, this.conditions, this.failed, this.ready, this.startTime, this.succeeded, this.uncountedTerminatedPods, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.active != null) {
            sb.append("active:");
            sb.append(this.active + ",");
        }
        if (this.completedIndexes != null) {
            sb.append("completedIndexes:");
            sb.append(this.completedIndexes + ",");
        }
        if (this.completionTime != null) {
            sb.append("completionTime:");
            sb.append(this.completionTime + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.failed != null) {
            sb.append("failed:");
            sb.append(this.failed + ",");
        }
        if (this.ready != null) {
            sb.append("ready:");
            sb.append(this.ready + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime + ",");
        }
        if (this.succeeded != null) {
            sb.append("succeeded:");
            sb.append(this.succeeded + ",");
        }
        if (this.uncountedTerminatedPods != null) {
            sb.append("uncountedTerminatedPods:");
            sb.append(this.uncountedTerminatedPods + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class UncountedTerminatedPodsNestedImpl<N>
    extends UncountedTerminatedPodsFluentImpl<JobStatusFluent.UncountedTerminatedPodsNested<N>>
    implements JobStatusFluent.UncountedTerminatedPodsNested<N>,
    Nested<N> {
        UncountedTerminatedPodsBuilder builder;

        UncountedTerminatedPodsNestedImpl(UncountedTerminatedPods item) {
            this.builder = new UncountedTerminatedPodsBuilder(this, item);
        }

        UncountedTerminatedPodsNestedImpl() {
            this.builder = new UncountedTerminatedPodsBuilder(this);
        }

        @Override
        public N and() {
            return (N)JobStatusFluentImpl.this.withUncountedTerminatedPods(this.builder.build());
        }

        @Override
        public N endUncountedTerminatedPods() {
            return this.and();
        }
    }

    class ConditionsNestedImpl<N>
    extends JobConditionFluentImpl<JobStatusFluent.ConditionsNested<N>>
    implements JobStatusFluent.ConditionsNested<N>,
    Nested<N> {
        JobConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, JobCondition item) {
            this.index = index;
            this.builder = new JobConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new JobConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)JobStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

