/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.Proxy;
import io.fabric8.openshift.api.model.ProxyFluent;
import io.fabric8.openshift.api.model.ProxySpec;
import io.fabric8.openshift.api.model.ProxySpecBuilder;
import io.fabric8.openshift.api.model.ProxySpecFluentImpl;
import io.fabric8.openshift.api.model.ProxyStatus;
import io.fabric8.openshift.api.model.ProxyStatusBuilder;
import io.fabric8.openshift.api.model.ProxyStatusFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ProxyFluentImpl<A extends ProxyFluent<A>>
extends BaseFluent<A>
implements ProxyFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ProxySpecBuilder spec;
    private ProxyStatusBuilder status;
    private Map<String, Object> additionalProperties;

    public ProxyFluentImpl() {
    }

    public ProxyFluentImpl(Proxy instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ProxyFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ProxyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ProxyFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ProxyFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ProxyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ProxySpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ProxySpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ProxySpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new ProxySpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ProxyFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ProxyFluent.SpecNested<A> withNewSpecLike(ProxySpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ProxyFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ProxyFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ProxySpecBuilder().build());
    }

    @Override
    public ProxyFluent.SpecNested<A> editOrNewSpecLike(ProxySpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ProxyStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ProxyStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ProxyStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new ProxyStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public A withNewStatus(String httpProxy, String httpsProxy, String noProxy) {
        return this.withStatus(new ProxyStatus(httpProxy, httpsProxy, noProxy));
    }

    @Override
    public ProxyFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ProxyFluent.StatusNested<A> withNewStatusLike(ProxyStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ProxyFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ProxyFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ProxyStatusBuilder().build());
    }

    @Override
    public ProxyFluent.StatusNested<A> editOrNewStatusLike(ProxyStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProxyFluentImpl that = (ProxyFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends ProxyStatusFluentImpl<ProxyFluent.StatusNested<N>>
    implements ProxyFluent.StatusNested<N>,
    Nested<N> {
        ProxyStatusBuilder builder;

        StatusNestedImpl(ProxyStatus item) {
            this.builder = new ProxyStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ProxyStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProxyFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends ProxySpecFluentImpl<ProxyFluent.SpecNested<N>>
    implements ProxyFluent.SpecNested<N>,
    Nested<N> {
        ProxySpecBuilder builder;

        SpecNestedImpl(ProxySpec item) {
            this.builder = new ProxySpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ProxySpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProxyFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ProxyFluent.MetadataNested<N>>
    implements ProxyFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProxyFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

