/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.console.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpec;
import io.fabric8.openshift.api.model.console.v1.ConsoleNotificationSpecFluent;
import io.fabric8.openshift.api.model.console.v1.Link;
import io.fabric8.openshift.api.model.console.v1.LinkBuilder;
import io.fabric8.openshift.api.model.console.v1.LinkFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ConsoleNotificationSpecFluentImpl<A extends ConsoleNotificationSpecFluent<A>>
extends BaseFluent<A>
implements ConsoleNotificationSpecFluent<A> {
    private String backgroundColor;
    private String color;
    private LinkBuilder link;
    private String location;
    private String text;
    private Map<String, Object> additionalProperties;

    public ConsoleNotificationSpecFluentImpl() {
    }

    public ConsoleNotificationSpecFluentImpl(ConsoleNotificationSpec instance) {
        this.withBackgroundColor(instance.getBackgroundColor());
        this.withColor(instance.getColor());
        this.withLink(instance.getLink());
        this.withLocation(instance.getLocation());
        this.withText(instance.getText());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public A withBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
        return (A)this;
    }

    @Override
    public Boolean hasBackgroundColor() {
        return this.backgroundColor != null;
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public A withColor(String color) {
        this.color = color;
        return (A)this;
    }

    @Override
    public Boolean hasColor() {
        return this.color != null;
    }

    @Override
    @Deprecated
    public Link getLink() {
        return this.link != null ? this.link.build() : null;
    }

    @Override
    public Link buildLink() {
        return this.link != null ? this.link.build() : null;
    }

    @Override
    public A withLink(Link link) {
        this._visitables.get("link").remove(this.link);
        if (link != null) {
            this.link = new LinkBuilder(link);
            this._visitables.get("link").add(this.link);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLink() {
        return this.link != null;
    }

    @Override
    public A withNewLink(String href, String text) {
        return this.withLink(new Link(href, text));
    }

    @Override
    public ConsoleNotificationSpecFluent.LinkNested<A> withNewLink() {
        return new LinkNestedImpl();
    }

    @Override
    public ConsoleNotificationSpecFluent.LinkNested<A> withNewLinkLike(Link item) {
        return new LinkNestedImpl(item);
    }

    @Override
    public ConsoleNotificationSpecFluent.LinkNested<A> editLink() {
        return this.withNewLinkLike(this.getLink());
    }

    @Override
    public ConsoleNotificationSpecFluent.LinkNested<A> editOrNewLink() {
        return this.withNewLinkLike(this.getLink() != null ? this.getLink() : new LinkBuilder().build());
    }

    @Override
    public ConsoleNotificationSpecFluent.LinkNested<A> editOrNewLinkLike(Link item) {
        return this.withNewLinkLike(this.getLink() != null ? this.getLink() : item);
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public A withLocation(String location) {
        this.location = location;
        return (A)this;
    }

    @Override
    public Boolean hasLocation() {
        return this.location != null;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public A withText(String text) {
        this.text = text;
        return (A)this;
    }

    @Override
    public Boolean hasText() {
        return this.text != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsoleNotificationSpecFluentImpl that = (ConsoleNotificationSpecFluentImpl)o;
        if (this.backgroundColor != null ? !this.backgroundColor.equals(that.backgroundColor) : that.backgroundColor != null) {
            return false;
        }
        if (this.color != null ? !this.color.equals(that.color) : that.color != null) {
            return false;
        }
        if (this.link != null ? !this.link.equals(that.link) : that.link != null) {
            return false;
        }
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        if (this.text != null ? !this.text.equals(that.text) : that.text != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.backgroundColor, this.color, this.link, this.location, this.text, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backgroundColor != null) {
            sb.append("backgroundColor:");
            sb.append(this.backgroundColor + ",");
        }
        if (this.color != null) {
            sb.append("color:");
            sb.append(this.color + ",");
        }
        if (this.link != null) {
            sb.append("link:");
            sb.append(this.link + ",");
        }
        if (this.location != null) {
            sb.append("location:");
            sb.append(this.location + ",");
        }
        if (this.text != null) {
            sb.append("text:");
            sb.append(this.text + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class LinkNestedImpl<N>
    extends LinkFluentImpl<ConsoleNotificationSpecFluent.LinkNested<N>>
    implements ConsoleNotificationSpecFluent.LinkNested<N>,
    Nested<N> {
        LinkBuilder builder;

        LinkNestedImpl(Link item) {
            this.builder = new LinkBuilder(this, item);
        }

        LinkNestedImpl() {
            this.builder = new LinkBuilder(this);
        }

        @Override
        public N and() {
            return (N)ConsoleNotificationSpecFluentImpl.this.withLink(this.builder.build());
        }

        @Override
        public N endLink() {
            return this.and();
        }
    }
}

