/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluentImpl;

public class HTTPConfigBuilder
extends HTTPConfigFluentImpl<HTTPConfigBuilder>
implements VisitableBuilder<HTTPConfig, HTTPConfigBuilder> {
    HTTPConfigFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPConfigBuilder() {
        this(false);
    }

    public HTTPConfigBuilder(Boolean validationEnabled) {
        this(new HTTPConfig(), validationEnabled);
    }

    public HTTPConfigBuilder(HTTPConfigFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public HTTPConfigBuilder(HTTPConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HTTPConfig(), validationEnabled);
    }

    public HTTPConfigBuilder(HTTPConfigFluent<?> fluent, HTTPConfig instance) {
        this(fluent, instance, false);
    }

    public HTTPConfigBuilder(HTTPConfigFluent<?> fluent, HTTPConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAuthorization(instance.getAuthorization());
        fluent.withBasicAuth(instance.getBasicAuth());
        fluent.withBearerTokenSecret(instance.getBearerTokenSecret());
        fluent.withProxyURL(instance.getProxyURL());
        fluent.withTlsConfig(instance.getTlsConfig());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public HTTPConfigBuilder(HTTPConfig instance) {
        this(instance, (Boolean)false);
    }

    public HTTPConfigBuilder(HTTPConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAuthorization(instance.getAuthorization());
        this.withBasicAuth(instance.getBasicAuth());
        this.withBearerTokenSecret(instance.getBearerTokenSecret());
        this.withProxyURL(instance.getProxyURL());
        this.withTlsConfig(instance.getTlsConfig());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public HTTPConfig build() {
        HTTPConfig buildable = new HTTPConfig(this.fluent.getAuthorization(), this.fluent.getBasicAuth(), this.fluent.getBearerTokenSecret(), this.fluent.getProxyURL(), this.fluent.getTlsConfig());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

