/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.client.internal;

import com.mifmif.common.regex.Generex;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import io.fabric8.kubernetes.client.dsl.internal.NamespaceVisitOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.openshift.api.model.Parameter;
import io.fabric8.openshift.api.model.Template;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl
extends NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl {
    public OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(Client client, Object item) {
        super(client, item);
    }

    public OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(OperationContext context, NamespaceVisitOperationContext namespaceVisitOperationContext) {
        super(context, namespaceVisitOperationContext);
    }

    @Override
    protected List<HasMetadata> asHasMetadata(Object item) {
        if (item instanceof Template) {
            return OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.processTemplateList((Template)item, true);
        }
        return super.asHasMetadata(item);
    }

    private static List<HasMetadata> processTemplate(Template template, Boolean failOnMissing) {
        List<Parameter> parameters = template != null ? template.getParameters() : null;
        List<HasMetadata> objects = template != null ? template.getObjects() : Collections.emptyList();
        KubernetesList list = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(objects)).build();
        try {
            String json = OBJECT_MAPPER.writeValueAsString((Object)list);
            if (parameters != null && !parameters.isEmpty()) {
                for (int i = 0; i < 5; ++i) {
                    for (Parameter parameter : parameters) {
                        String value;
                        String name = parameter.getName();
                        String regex = "${" + name + "}";
                        if (Utils.isNotNullOrEmpty((String)parameter.getValue())) {
                            value = parameter.getValue();
                        } else if ("expression".equals(parameter.getGenerate())) {
                            Generex generex = new Generex(parameter.getFrom());
                            value = generex.random();
                        } else {
                            if (Boolean.TRUE.equals(failOnMissing)) {
                                throw new IllegalArgumentException("No value available for parameter name: " + name);
                            }
                            value = "";
                        }
                        json = json.replace(regex, value);
                    }
                }
            }
            list = (KubernetesList)OBJECT_MAPPER.readValue(json, KubernetesList.class);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
        return list.getItems();
    }

    private static List<HasMetadata> processTemplateList(Template item, Boolean enableProccessing) {
        ArrayList<HasMetadata> result = new ArrayList<HasMetadata>();
        if (Boolean.FALSE.equals(enableProccessing)) {
            result.addAll(item.getObjects());
        } else {
            result.addAll(OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl.processTemplate(item, false));
        }
        return result;
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl newInstance(OperationContext context, NamespaceVisitOperationContext namespaceVisitOperationContext) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(context, namespaceVisitOperationContext);
    }
}

