/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.core.type.TypeReference;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.DefaultKubernetesResourceList;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.ListOptionsBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusDetails;
import io.fabric8.kubernetes.api.model.StatusDetailsBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v1.Scale;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.KubernetesClientTimeoutException;
import io.fabric8.kubernetes.client.OperationInfo;
import io.fabric8.kubernetes.client.ResourceNotFoundException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.FieldValidateable;
import io.fabric8.kubernetes.client.dsl.FilterNested;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonDeletingOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.Waitable;
import io.fabric8.kubernetes.client.dsl.base.PatchContext;
import io.fabric8.kubernetes.client.dsl.base.PatchType;
import io.fabric8.kubernetes.client.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.client.dsl.internal.CreateOnlyResourceOperation;
import io.fabric8.kubernetes.client.dsl.internal.DefaultOperationInfo;
import io.fabric8.kubernetes.client.dsl.internal.FilterNestedImpl;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.WatchConnectionManager;
import io.fabric8.kubernetes.client.dsl.internal.WatchHTTPManager;
import io.fabric8.kubernetes.client.extension.ExtensibleResource;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.impl.BaseClient;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.impl.DefaultSharedIndexInformer;
import io.fabric8.kubernetes.client.informers.impl.ListerWatcher;
import io.fabric8.kubernetes.client.readiness.Readiness;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.client.utils.internal.CreateOrReplaceHelper;
import io.fabric8.kubernetes.client.utils.internal.WatcherToggle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends CreateOnlyResourceOperation<T, T>
implements OperationInfo,
MixedOperation<T, L, R>,
ExtensibleResource<T>,
ListerWatcher<T, L> {
    static final Logger LOGGER = LoggerFactory.getLogger(BaseOperation.class);
    private static final String WATCH = "watch";
    private static final String READ_ONLY_UPDATE_EXCEPTION_MESSAGE = "Cannot update read-only resources";
    private static final String READ_ONLY_EDIT_EXCEPTION_MESSAGE = "Cannot edit read-only resources";
    private final T item;
    private final String resourceVersion;
    private final long gracePeriodSeconds;
    private final DeletionPropagation propagationPolicy;
    protected String apiVersion;
    protected Class<L> listType;
    private Map<String, Function<T, List<String>>> indexers;
    private Long limit;

    protected BaseOperation(OperationContext ctx) {
        super(ctx);
        this.item = (HasMetadata)ctx.getItem();
        this.resourceVersion = ctx.getResourceVersion();
        this.gracePeriodSeconds = ctx.getGracePeriodSeconds();
        this.propagationPolicy = ctx.getPropagationPolicy();
        this.apiVersion = ApiVersionUtil.joinApiGroupAndVersion((String)this.getAPIGroupName(), (String)this.getAPIGroupVersion());
    }

    public BaseOperation<T, L, R> newInstance(OperationContext context) {
        return new BaseOperation<T, L, R>(context);
    }

    protected R newResource(OperationContext context) {
        return (R)this.newInstance(context);
    }

    protected URL fetchListUrl(URL url, ListOptions listOptions) {
        return this.appendListOptionParams(url, listOptions);
    }

    public T get() {
        try {
            return this.requireFromServer();
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 404) {
                throw e;
            }
            return null;
        }
    }

    public T require() {
        try {
            return this.requireFromServer();
        }
        catch (KubernetesClientException e) {
            throw new ResourceNotFoundException("Resource couldn't be fetched : " + e.getMessage(), (Throwable)e);
        }
    }

    public T getItemOrRequireFromServer() {
        if (this.item != null) {
            return (T)((HasMetadata)this.getKubernetesSerialization().clone(this.item));
        }
        return this.requireFromServer();
    }

    protected T requireFromServer() {
        if (Utils.isNullOrEmpty((String)this.getName())) {
            throw new KubernetesClientException("name not specified for an operation requiring one.");
        }
        try {
            URL requestUrl = this.getCompleteResourceUrl();
            return this.handleGet(requestUrl);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("get"), (Throwable)e);
        }
    }

    public T edit(UnaryOperator<T> function) {
        throw new KubernetesClientException(READ_ONLY_EDIT_EXCEPTION_MESSAGE);
    }

    public T editStatus(UnaryOperator<T> function) {
        throw new KubernetesClientException(READ_ONLY_EDIT_EXCEPTION_MESSAGE);
    }

    public T edit(Visitor ... visitors) {
        throw new KubernetesClientException(READ_ONLY_EDIT_EXCEPTION_MESSAGE);
    }

    public <V> T edit(final Class<V> visitorType, final Visitor<V> visitor) {
        return (T)this.edit(new Visitor[]{new TypedVisitor<V>(){

            @Override
            public Class<V> getType() {
                return visitorType;
            }

            @Override
            public void visit(V item) {
                visitor.visit(item);
            }
        }});
    }

    public T accept(Consumer<T> consumer) {
        throw new KubernetesClientException(READ_ONLY_EDIT_EXCEPTION_MESSAGE);
    }

    public R withName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Name must be provided.");
        }
        return this.newResource(this.context.withName(name));
    }

    public ExtensibleResource<T> lockResourceVersion(String resourceVersion) {
        if (resourceVersion == null) {
            throw new KubernetesClientException("resourceVersion cannot be null");
        }
        return this.newInstance(this.context.withResourceVersion(resourceVersion));
    }

    public BaseOperation<T, L, R> inNamespace(String namespace) {
        if (namespace == null) {
            throw new KubernetesClientException("namespace cannot be null");
        }
        return this.newInstance(this.context.withNamespace(namespace));
    }

    public BaseOperation<T, L, R> inAnyNamespace() {
        return this.newInstance(this.context.withNamespace(null));
    }

    public R load(InputStream is) {
        HasMetadata unmarshal = (HasMetadata)this.getKubernetesSerialization().unmarshal(is, this.type);
        unmarshal.setApiVersion(this.apiVersion);
        return this.resource((T)unmarshal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R load(URL url) {
        try (InputStream inputStream = url.openStream();){
            R r = this.load(inputStream);
            return r;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public R load(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            R r = this.load(fis);
            return r;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    public R load(String path) {
        return this.load(new File(path));
    }

    public BaseOperation<T, L, R> fromServer() {
        return this;
    }

    public final T createOrReplace() {
        if (this.item == null) {
            throw new IllegalArgumentException("Nothing to create.");
        }
        Object resource = this.resource(this.item);
        CreateOrReplaceHelper<T> createOrReplaceHelper = new CreateOrReplaceHelper<T>(arg_0 -> resource.create(arg_0), arg_0 -> resource.replace(arg_0), m -> (HasMetadata)resource.waitUntilCondition(Objects::nonNull, 1L, TimeUnit.SECONDS), m -> (HasMetadata)resource.fromServer().get(), this.getKubernetesSerialization());
        return createOrReplaceHelper.createOrReplace(this.item);
    }

    public T createOr(Function<NonDeletingOperation<T>, T> conflictAction) {
        try {
            return (T)this.create();
        }
        catch (KubernetesClientException e) {
            if (e.getCode() == 409) {
                return (T)((HasMetadata)conflictAction.apply((NonDeletingOperation<BaseOperation>)this));
            }
            throw e;
        }
    }

    public ExtensibleResource<T> unlock() {
        T current = this.getItemOrRequireFromServer();
        if (current.getMetadata() != null) {
            current.getMetadata().setResourceVersion(null);
        }
        return this.newInstance(this.context.withItem(current));
    }

    public FilterWatchListDeletable<T, L, R> withLabels(Map<String, String> labels) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabels(labels)).endFilter();
    }

    public FilterWatchListDeletable<T, L, R> withLabelSelector(LabelSelector selector) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabelSelector(selector)).endFilter();
    }

    public FilterWatchListDeletable<T, L, R> withoutLabels(Map<String, String> labels) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withoutLabels(labels)).endFilter();
    }

    public FilterWatchListDeletable<T, L, R> withLabelIn(String key, String ... values) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabelIn(key, values)).endFilter();
    }

    public FilterWatchListDeletable<T, L, R> withLabelNotIn(String key, String ... values) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabelNotIn(key, values)).endFilter();
    }

    public FilterWatchListDeletable<T, L, R> withLabel(String key, String value) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabel(key, value)).endFilter();
    }

    public FilterWatchListDeletable<T, L, R> withoutLabel(String key, String value) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withoutLabel(key, value)).endFilter();
    }

    public FilterWatchListDeletable<T, L, R> withLabelSelector(String selectorAsString) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withLabelSelector(selectorAsString)).endFilter();
    }

    public FilterWatchListDeletable<T, L, R> withFields(Map<String, String> fields) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withFields(fields)).endFilter();
    }

    public FilterWatchListDeletable<T, L, R> withField(String key, String value) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withField(key, value)).endFilter();
    }

    public FilterWatchListDeletable<T, L, R> withInvolvedObject(ObjectReference objectReference) {
        if (objectReference != null) {
            return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withInvolvedObject(objectReference)).endFilter();
        }
        return this;
    }

    public FilterNested<FilterWatchListDeletable<T, L, R>> withNewFilter() {
        return new FilterNestedImpl(this);
    }

    public FilterWatchListDeletable<T, L, R> withoutFields(Map<String, String> fields) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withoutFields(fields)).endFilter();
    }

    public FilterWatchListDeletable<T, L, R> withoutField(String key, String value) {
        return (FilterWatchListDeletable)((FilterNested)this.withNewFilter().withoutField(key, value)).endFilter();
    }

    public String getFieldQueryParam() {
        return this.context.getFieldQueryParam();
    }

    public L list() {
        return (L)this.list(new ListOptions());
    }

    public L list(Integer limitVal, String continueVal) {
        return (L)this.list(((ListOptionsBuilder)((ListOptionsBuilder)new ListOptionsBuilder().withLimit(limitVal.longValue())).withContinue(continueVal)).build());
    }

    @Override
    public CompletableFuture<L> submitList(ListOptions listOptions) {
        try {
            URL fetchListUrl = this.fetchListUrl(this.getNamespacedUrl(), this.defaultListOptions(listOptions, null));
            HttpRequest.Builder requestBuilder = this.withRequestTimeout(this.httpClient.newHttpRequestBuilder()).url(fetchListUrl);
            final Class<L> refinedType = this.listType.equals(DefaultKubernetesResourceList.class) ? this.getKubernetesSerialization().constructParametricType(this.listType, new Class[]{this.type}) : this.listType;
            TypeReference listTypeReference = new TypeReference<L>(){

                public Type getType() {
                    return refinedType;
                }
            };
            CompletableFuture futureAnswer = this.handleResponse(this.httpClient, requestBuilder, listTypeReference);
            return futureAnswer.thenApply(this::updateListItems);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("list"), (Throwable)e);
        }
    }

    public L list(ListOptions listOptions) {
        try {
            return (L)((KubernetesResourceList)this.waitForResult(this.submitList(listOptions)));
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("list"), (Throwable)e);
        }
    }

    private ListOptions defaultListOptions(ListOptions options, Boolean watch) {
        String labelQueryParam;
        options.setWatch(watch);
        String fieldQueryParam = this.context.getFieldQueryParam();
        if (fieldQueryParam != null) {
            options.setFieldSelector(fieldQueryParam);
        }
        if ((labelQueryParam = this.context.getLabelQueryParam()) != null) {
            options.setLabelSelector(labelQueryParam);
        }
        if (this.resourceVersion != null) {
            options.setResourceVersion(this.resourceVersion);
        }
        return options;
    }

    static void toStatusDetails(KubernetesResource obj, List<StatusDetails> details) {
        List items;
        if (obj instanceof HasMetadata) {
            HasMetadata meta = (HasMetadata)obj;
            ObjectMeta metadata = meta.getMetadata();
            details.add(((StatusDetailsBuilder)((StatusDetailsBuilder)((StatusDetailsBuilder)((StatusDetailsBuilder)new StatusDetailsBuilder().withGroup(ApiVersionUtil.trimGroup((String)meta.getApiVersion()))).withKind(meta.getKind())).withName(metadata == null ? null : metadata.getName())).withUid(metadata == null ? null : metadata.getUid())).build());
        } else if (obj instanceof Status) {
            details.add(((Status)obj).getDetails());
        } else if (obj instanceof KubernetesResourceList && (items = ((KubernetesResourceList)((Object)obj)).getItems()) != null) {
            items.forEach(i -> BaseOperation.toStatusDetails(i, details));
        }
    }

    public List<StatusDetails> delete() {
        List<StatusDetails> deleted = this.deleteAll();
        BaseOperation.waitForDelete(deleted, this.context, this);
        return deleted;
    }

    static void waitForDelete(List<StatusDetails> deleted, OperationContext context, Waitable<?, ? extends HasMetadata> waitable) {
        if (context.getTimeout() > 0L) {
            Set uids = deleted.stream().map(StatusDetails::getUid).collect(Collectors.toSet());
            waitable.waitUntilCondition(h -> h == null || !uids.contains(h.getMetadata().getUid()), context.getTimeout(), context.getTimeoutUnit());
        }
    }

    protected List<StatusDetails> deleteAll() {
        if (Utils.isNotNullOrEmpty((String)this.name) || Utils.isNotNullOrEmpty((String)this.namespace) || !this.isResourceNamespaced()) {
            try {
                URL resourceURLForWriteOperation = this.getResourceURLForWriteOperation(this.getResourceUrl());
                ListOptions options = new ListOptions();
                boolean useOptions = false;
                if (Utils.isNullOrEmpty((String)this.name)) {
                    String labelQueryParam;
                    String fieldQueryParam = this.context.getFieldQueryParam();
                    if (fieldQueryParam != null) {
                        options.setFieldSelector(fieldQueryParam);
                        useOptions = true;
                    }
                    if ((labelQueryParam = this.context.getLabelQueryParam()) != null) {
                        options.setLabelSelector(labelQueryParam);
                        useOptions = true;
                    }
                }
                if (useOptions) {
                    resourceURLForWriteOperation = this.appendListOptionParams(resourceURLForWriteOperation, options);
                }
                KubernetesResource result = this.handleDelete(resourceURLForWriteOperation, this.gracePeriodSeconds, this.propagationPolicy, this.resourceVersion);
                ArrayList<StatusDetails> details = new ArrayList<StatusDetails>();
                BaseOperation.toStatusDetails(result, details);
                return details;
            }
            catch (Exception e) {
                RuntimeException re = KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("delete"), (Throwable)e);
                if (re instanceof KubernetesClientException) {
                    KubernetesClientException ke = (KubernetesClientException)((Object)re);
                    if (Utils.isNotNullOrEmpty((String)this.name)) {
                        if (ke.getCode() == 404) {
                            return Collections.emptyList();
                        }
                    } else if (ke.getCode() == 405) {
                        return this.list().getItems().stream().flatMap(i -> this.resource((T)i).delete().stream()).collect(Collectors.toList());
                    }
                }
                throw re;
            }
        }
        Set namespaces = this.list().getItems().stream().map(i -> i.getMetadata().getNamespace()).collect(Collectors.toSet());
        return namespaces.stream().flatMap(n -> ((BaseOperation)this.inNamespace((String)n)).delete().stream()).collect(Collectors.toList());
    }

    public boolean delete(List<T> items) {
        if (items != null) {
            for (HasMetadata toDelete : items) {
                if (toDelete == null) continue;
                try {
                    this.resource((T)toDelete).delete();
                }
                catch (KubernetesClientException e) {
                    if (e.getCode() == 404) continue;
                    throw e;
                }
            }
        }
        return true;
    }

    public T patchStatus(T item) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    public T patchStatus() {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    public T patch() {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    public T patch(PatchContext patchContext) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    protected T getNonNullItem() {
        Object result = this.getItem();
        if (result == null) {
            throw new KubernetesClientException("item required");
        }
        return (T)result;
    }

    public R resource(T item) {
        item = (HasMetadata)this.correctNamespace(item);
        this.updateApiVersion((HasMetadata)item);
        String itemNs = KubernetesResourceUtil.getNamespace(item);
        OperationContext ctx = this.context.withName(this.checkName(item)).withItem(item);
        if (Utils.isNotNullOrEmpty((String)itemNs)) {
            ctx = ctx.withNamespace(itemNs);
        }
        return this.newResource(ctx);
    }

    public BaseOperation<T, L, R> withResourceVersion(String resourceVersion) {
        return this.newInstance(this.context.withResourceVersion(resourceVersion));
    }

    public Watch watch(Watcher<T> watcher) {
        return this.watch(new ListOptions(), watcher);
    }

    public Watch watch(String resourceVersion, Watcher<T> watcher) {
        return this.watch(((ListOptionsBuilder)new ListOptionsBuilder().withResourceVersion(resourceVersion)).build(), watcher);
    }

    public Watch watch(ListOptions options, Watcher<T> watcher) {
        CompletableFuture<AbstractWatchManager<T>> startedFuture = this.submitWatch(options, watcher);
        Utils.waitUntilReadyOrFail(startedFuture, (long)-1L, (TimeUnit)TimeUnit.SECONDS);
        return startedFuture.join();
    }

    @Override
    public CompletableFuture<AbstractWatchManager<T>> submitWatch(ListOptions options, Watcher<T> watcher) {
        WatchConnectionManager watch;
        ListOptions optionsToUse = this.defaultListOptions(options, true);
        if (this.getConfig().isOnlyHttpWatches()) {
            return CompletableFuture.completedFuture(this.httpWatch(watcher, optionsToUse));
        }
        WatcherToggle<T> watcherToggle = new WatcherToggle<T>(watcher, true);
        try {
            watch = new WatchConnectionManager(this.httpClient, this, optionsToUse, watcherToggle, this.getRequestConfig().getWatchReconnectInterval(), this.getRequestConfig().getWatchReconnectLimit(), this.getRequestConfig().getRequestTimeout());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType(WATCH), (Throwable)e);
        }
        return watch.getWebsocketFuture().handle((w, t) -> {
            if (t != null) {
                try {
                    if (t instanceof CompletionException) {
                        t = t.getCause();
                    }
                    boolean httpWatch = false;
                    if (t instanceof KubernetesClientException) {
                        KubernetesClientException ke = (KubernetesClientException)((Object)t);
                        List<Integer> furtherProcessedCodes = Arrays.asList(200, 503);
                        if (furtherProcessedCodes.contains(ke.getCode())) {
                            LOGGER.debug("Websocket hanshake failed with code {}, but an httpwatch may be possible.  Use Config.onlyHttpWatches to disable websocket watches.", (Object)ke.getCode());
                            httpWatch = true;
                        }
                    } else {
                        LOGGER.debug("Failed to establish a websocket watch, will try regular http instead.  Use Config.onlyHttpWatches to disable websocket watches.", t);
                        httpWatch = true;
                    }
                    if (httpWatch) {
                        watcherToggle.disable();
                        AbstractWatchManager<T> abstractWatchManager = this.httpWatch(watcher, optionsToUse);
                        return abstractWatchManager;
                    }
                    throw KubernetesClientException.launderThrowable((Throwable)t);
                }
                finally {
                    watch.close();
                }
            }
            return watch;
        });
    }

    private AbstractWatchManager<T> httpWatch(Watcher<T> watcher, ListOptions optionsToUse) {
        try {
            return new WatchHTTPManager(this.httpClient, this, optionsToUse, watcher, this.getRequestConfig().getWatchReconnectInterval(), this.getRequestConfig().getWatchReconnectLimit());
        }
        catch (MalformedURLException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType(WATCH), (Throwable)e);
        }
    }

    public T replace() {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    public T replaceStatus() {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    public T patch(PatchContext patchContext, String patch) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    public T patch(PatchContext patchContext, T item) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    @Override
    public boolean isResourceNamespaced() {
        return Utils.isResourceNamespaced(this.getType());
    }

    protected T handleResponse(HttpRequest.Builder requestBuilder) throws InterruptedException, IOException {
        return (T)((HasMetadata)this.handleResponse(requestBuilder, this.getType()));
    }

    @Override
    protected T handleCreate(T resource) throws InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)resource);
        return (T)((HasMetadata)this.handleCreate(resource, this.getType()));
    }

    protected T handleUpdate(T updated) throws InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)updated);
        return (T)((HasMetadata)this.handleUpdate(updated, this.getType()));
    }

    protected T handlePatch(PatchContext context, T current, T updated) throws InterruptedException, IOException {
        this.updateApiVersion((HasMetadata)updated);
        return (T)((HasMetadata)this.handlePatch(context, current, updated, this.getType()));
    }

    public <S> S handleScale(S scaleParam, Class<S> scaleType) {
        try {
            return this.handleScale(this.getCompleteResourceUrl().toString(), scaleParam, scaleType);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("scale"), (Throwable)ie);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("scale"), (Throwable)e);
        }
    }

    protected Status handleDeploymentRollback(DeploymentRollback deploymentRollback) {
        try {
            return this.handleDeploymentRollback(this.getCompleteResourceUrl().toString(), deploymentRollback);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("rollback"), (Throwable)ie);
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("rollback"), (Throwable)e);
        }
    }

    protected T handleGet(URL resourceUrl) throws IOException {
        HasMetadata answer = (HasMetadata)this.handleGet(resourceUrl, this.getType());
        this.updateApiVersion(answer);
        return (T)answer;
    }

    private URL getCompleteResourceUrl() throws MalformedURLException {
        URL requestUrl = this.getNamespacedUrl(this.checkNamespace(this.item));
        if (this.name != null) {
            requestUrl = new URL(URLUtils.join((String[])new String[]{requestUrl.toString(), this.name}));
        }
        return requestUrl;
    }

    public T item() {
        return (T)this.getItem();
    }

    public final T getItem() {
        return this.item;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public Long getGracePeriodSeconds() {
        return this.gracePeriodSeconds;
    }

    public DeletionPropagation getPropagationPolicy() {
        return this.propagationPolicy;
    }

    public Class<L> getListType() {
        return this.listType;
    }

    public String getKind() {
        return this.type != null ? HasMetadata.getKind(this.type) : "Resource";
    }

    public String getGroup() {
        return this.getAPIGroupName();
    }

    public String getPlural() {
        return this.getResourceT();
    }

    public String getVersion() {
        return this.getAPIGroupVersion();
    }

    public String getOperationType() {
        return null;
    }

    public OperationInfo forOperationType(String type) {
        return new DefaultOperationInfo(this.getKind(), type, this.name, this.namespace, this.getGroup(), this.getPlural(), this.getVersion());
    }

    public ExtensibleResource<T> withGracePeriod(long gracePeriodSeconds) {
        return this.newInstance(this.context.withGracePeriodSeconds(gracePeriodSeconds));
    }

    public ExtensibleResource<T> withPropagationPolicy(DeletionPropagation propagationPolicy) {
        return this.newInstance(this.context.withPropagationPolicy(propagationPolicy));
    }

    protected Class<? extends Config> getConfigType() {
        return Config.class;
    }

    protected L updateListItems(L list) {
        if (list != null && list.getItems() != null) {
            boolean updateApiVersion = Utils.isNotNullOrEmpty((String)this.apiVersion);
            boolean updateKind = GenericKubernetesResource.class.isAssignableFrom(this.getType());
            if (updateApiVersion || updateKind) {
                for (HasMetadata item : list.getItems()) {
                    this.updateApiVersion(item);
                    if (!updateKind || item == null || item.getKind() != null) continue;
                    ((GenericKubernetesResource)item).setKind(this.getKind());
                }
            }
        }
        return list;
    }

    protected void updateApiVersion(HasMetadata hasMetadata) {
        String current;
        String version = this.apiVersion;
        if (hasMetadata != null && Utils.isNotNullOrEmpty((String)version) && ((current = hasMetadata.getApiVersion()) == null || "v1".equals(current) || current.indexOf(47) < 0 && version.indexOf(47) > 0)) {
            hasMetadata.setApiVersion(version);
        }
    }

    public Readiness getReadiness() {
        return this.config.getReadiness();
    }

    public final boolean isReady() {
        Object item = this.get();
        if (item == null) {
            return false;
        }
        return this.getReadiness().isReady((HasMetadata)item);
    }

    public T waitUntilReady(long amount, TimeUnit timeUnit) {
        return (T)this.waitUntilCondition(resource -> Objects.nonNull(resource) && this.getReadiness().isReady(resource), amount, timeUnit);
    }

    public T waitUntilCondition(Predicate<T> condition, long amount, TimeUnit timeUnit) {
        CompletableFuture<List<T>> futureCondition = this.informOnCondition(l -> {
            if (l.isEmpty()) {
                return condition.test(null);
            }
            return l.stream().allMatch(condition);
        });
        if (!Utils.waitUntilReady(futureCondition, (long)amount, (TimeUnit)timeUnit)) {
            futureCondition.cancel(true);
            Object i = this.getItem();
            if (i != null) {
                throw new KubernetesClientTimeoutException((HasMetadata)i, amount, timeUnit);
            }
            throw new KubernetesClientTimeoutException(this.getKind(), this.getName(), this.getNamespace(), amount, timeUnit);
        }
        return (T)((HasMetadata)((CompletableFuture)futureCondition.thenApply(l -> l.isEmpty() ? null : (HasMetadata)l.get(0))).getNow(null));
    }

    public CompletableFuture<List<T>> informOnCondition(Predicate<List<T>> condition) {
        CompletableFuture future = new CompletableFuture();
        final DefaultSharedIndexInformer informer = this.createInformer(0L, Runnable::run);
        informer.initialState(Stream.empty());
        future.whenComplete((r, t) -> informer.stop());
        final Consumer<List> test = list -> {
            try {
                if (condition.test((List)list)) {
                    future.complete((List)list);
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        };
        informer.addEventHandler(new ResourceEventHandler<T>(){

            public void onAdd(T obj) {
                test.accept(informer.getStore().list());
            }

            public void onDelete(T obj, boolean deletedFinalStateUnknown) {
                test.accept(informer.getStore().list());
            }

            public void onUpdate(T oldObj, T newObj) {
                test.accept(informer.getStore().list());
            }

            public void onNothing() {
                test.accept(informer.getStore().list());
            }
        }).start().whenComplete((v, t) -> {
            if (t != null) {
                future.completeExceptionally((Throwable)t);
            }
        });
        informer.stopped().whenComplete((v, t) -> {
            if (t != null) {
                future.completeExceptionally((Throwable)t);
            } else {
                future.completeExceptionally(new KubernetesClientException("Informer was stopped"));
            }
        });
        return future;
    }

    public void setType(Class<T> type) {
        this.type = type;
    }

    public void setListType(Class<L> listType) {
        this.listType = listType;
    }

    public ExtensibleResource<T> dryRun(boolean isDryRun) {
        return this.newInstance(this.context.withDryRun(isDryRun));
    }

    public ExtensibleResource<T> fieldValidation(FieldValidateable.Validation fieldValidation) {
        return this.newInstance(this.context.withFieldValidation(fieldValidation));
    }

    public ExtensibleResource<T> withIndexers(Map<String, Function<T, List<String>>> indexers) {
        BaseOperation<T, L, R> result = this.newInstance(this.context);
        result.indexers = indexers;
        result.limit = this.limit;
        return result;
    }

    public BaseOperation<T, L, R> withLimit(Long limit) {
        BaseOperation<T, L, R> result = this.newInstance(this.context);
        result.indexers = this.indexers;
        result.limit = limit;
        return result;
    }

    @Override
    public Long getLimit() {
        return this.limit;
    }

    public SharedIndexInformer<T> inform(ResourceEventHandler<? super T> handler, long resync) {
        SharedIndexInformer<T> result = this.runnableInformer(resync);
        if (handler != null) {
            result.addEventHandler(handler);
        }
        result.run();
        return result;
    }

    public SharedIndexInformer<T> runnableInformer(long resync) {
        return this.createInformer(resync, this.context.getExecutor());
    }

    private DefaultSharedIndexInformer<T, L> createInformer(long resync, Executor executor) {
        Object i = this.getItem();
        if (Utils.isNotNullOrEmpty((String)this.getName()) && i != null) {
            this.checkName(i);
        }
        DefaultSharedIndexInformer informer = new DefaultSharedIndexInformer(this.getType(), this.withResourceVersion(null).withLimit(this.limit), resync, executor);
        if (this.indexers != null) {
            informer.addIndexers(this.indexers);
        }
        informer.started().whenComplete((ignored, throwable) -> {
            if (throwable == null) {
                BaseClient baseClient = (BaseClient)this.context.getClient().adapt(BaseClient.class);
                baseClient.addToCloseable((AutoCloseable)((Object)informer));
                ((CompletableFuture)informer.stopped()).whenComplete((x, y) -> baseClient.removeFromCloseable((AutoCloseable)((Object)informer)));
            }
        });
        return informer;
    }

    public URL appendListOptionParams(URL base, ListOptions listOptions) {
        if (listOptions == null) {
            return base;
        }
        URLUtils.URLBuilder urlBuilder = new URLUtils.URLBuilder(base);
        Map values = (Map)this.getKubernetesSerialization().convertValue((Object)listOptions, TreeMap.class);
        values.remove("apiVersion");
        values.remove("kind");
        values.forEach((k, v) -> urlBuilder.addQueryParameter(k, v.toString()));
        return urlBuilder.build();
    }

    public <C extends Client> C inWriteContext(Class<C> clazz) {
        return this.context.clientInWriteContext(clazz);
    }

    @Override
    public int getWatchReconnectInterval() {
        return this.config.getWatchReconnectInterval();
    }

    public Stream<R> resources() {
        return this.list().getItems().stream().map(this::resource);
    }

    public T createOrReplace(T item) {
        return (T)((HasMetadata)this.resource(item).createOrReplace());
    }

    public T replace(T item) {
        return (T)((HasMetadata)this.resource(item).replace());
    }

    public T replaceStatus(T item) {
        return (T)((HasMetadata)this.resource(item).replaceStatus());
    }

    public List<StatusDetails> delete(T item) {
        return this.resource(item).delete();
    }

    public ExtensibleResource<T> dryRun() {
        return this.dryRun(true);
    }

    public ExtensibleResource<T> lockResourceVersion() {
        return this.lockResourceVersion(KubernetesResourceUtil.getResourceVersion(this.getNonNullItem()));
    }

    public T updateStatus(T item) {
        return (T)((HasMetadata)this.resource(item).updateStatus());
    }

    public T create() {
        return (T)((HasMetadata)this.create(this.getNonNullItem()));
    }

    @Override
    public String getApiEndpointPath() {
        List<String> parts = this.getRootUrlParts();
        parts.remove(0);
        parts.remove(0);
        this.addNamespacedUrlPathParts(parts, this.namespace, this.resourceT);
        return parts.stream().collect(Collectors.joining("/"));
    }

    public ExtensibleResource<T> fieldManager(String manager) {
        return this.newInstance(this.context.withFieldManager(manager));
    }

    public ExtensibleResource<T> forceConflicts() {
        return this.newInstance(this.context.withForceConflicts());
    }

    public T serverSideApply() {
        return (T)this.patch(PatchContext.of((PatchType)PatchType.SERVER_SIDE_APPLY));
    }

    public ExtensibleResource<T> withTimeout(long timeout, TimeUnit unit) {
        return this.newInstance(this.context.withTimeout(timeout, unit));
    }

    public T updateStatus() {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    public T update() {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    public T scale(int count) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    public T scale(int count, boolean wait) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    public Scale scale(Scale scale) {
        throw new KubernetesClientException(READ_ONLY_UPDATE_EXCEPTION_MESSAGE);
    }

    public ExtensibleResource<T> subresource(String subresource) {
        return this.newInstance(this.context.withSubresource(subresource));
    }
}

