/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.ReplicaSetList;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import io.fabric8.kubernetes.client.dsl.RollableScalableResource;
import io.fabric8.kubernetes.client.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.ReplicaSetRollingUpdater;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.client.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.client.utils.internal.PodOperationUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class ReplicaSetOperationsImpl
extends RollableScalableResourceOperation<ReplicaSet, ReplicaSetList, RollableScalableResource<ReplicaSet>>
implements TimeoutImageEditReplacePatchable<ReplicaSet> {
    public ReplicaSetOperationsImpl(Client client) {
        this(new RollingOperationContext(), HasMetadataOperationsImpl.defaultContext(client));
    }

    ReplicaSetOperationsImpl(RollingOperationContext context, OperationContext superContext) {
        super(context, superContext.withApiGroupName("apps").withApiGroupVersion("v1").withPlural("replicasets"), ReplicaSet.class, ReplicaSetList.class);
    }

    @Override
    public ReplicaSetOperationsImpl newInstance(OperationContext context) {
        return new ReplicaSetOperationsImpl(this.rollingOperationContext, context);
    }

    public ReplicaSetOperationsImpl newInstance(RollingOperationContext context) {
        return new ReplicaSetOperationsImpl(context, this.context);
    }

    public ReplicaSet pause() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" pausing is not supported");
    }

    public ReplicaSet resume() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" resuming is not supported");
    }

    public ReplicaSet restart() {
        throw new UnsupportedOperationException(this.context.getPlural() + " \"" + this.name + "\" restarting is not supported");
    }

    public ReplicaSet undo() {
        throw new UnsupportedOperationException("no rollbacker has been implemented for \"" + ((ReplicaSet)this.get()).getKind() + "\"");
    }

    @Override
    public ReplicaSet withReplicas(int count) {
        return (ReplicaSet)this.accept(r -> r.getSpec().setReplicas(count));
    }

    @Override
    public RollingUpdater<ReplicaSet, ReplicaSetList> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new ReplicaSetRollingUpdater(this.context.getClient(), this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    public int getCurrentReplicas(ReplicaSet current) {
        return current.getStatus().getReplicas();
    }

    @Override
    public int getDesiredReplicas(ReplicaSet item) {
        return item.getSpec().getReplicas();
    }

    @Override
    public long getObservedGeneration(ReplicaSet current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    public Status rollback(DeploymentRollback deploymentRollback) {
        throw new KubernetesClientException("rollback not supported in case of ReplicaSets");
    }

    public String getLog(boolean isPretty) {
        return PodOperationUtil.getLog(new ReplicaSetOperationsImpl(this.rollingOperationContext.withPrettyOutput(isPretty), this.context).doGetLog(), isPretty);
    }

    private List<PodResource> doGetLog() {
        ReplicaSet replicaSet = (ReplicaSet)this.requireFromServer();
        return PodOperationUtil.getPodOperationsForController(this.context, this.rollingOperationContext.getPodOperationContext(), replicaSet.getMetadata().getUid(), ReplicaSetOperationsImpl.getReplicaSetSelectorLabels(replicaSet));
    }

    public Reader getLogReader() {
        return PodOperationUtil.getLogReader(this.doGetLog());
    }

    public InputStream getLogInputStream() {
        return PodOperationUtil.getLogInputStream(this.doGetLog());
    }

    public LogWatch watchLog(OutputStream out) {
        return PodOperationUtil.watchLog(this.doGetLog(), out);
    }

    static Map<String, String> getReplicaSetSelectorLabels(ReplicaSet replicaSet) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (replicaSet != null && replicaSet.getSpec() != null && replicaSet.getSpec().getSelector() != null) {
            labels.putAll(replicaSet.getSpec().getSelector().getMatchLabels());
        }
        return labels;
    }

    @Override
    protected List<Container> getContainers(ReplicaSet value) {
        return value.getSpec().getTemplate().getSpec().getContainers();
    }

    public TimeTailPrettyLoggable limitBytes(int limitBytes) {
        return new ReplicaSetOperationsImpl(this.rollingOperationContext.withLimitBytes(limitBytes), this.context);
    }

    public TimeTailPrettyLoggable terminated() {
        return new ReplicaSetOperationsImpl(this.rollingOperationContext.withTerminatedStatus(true), this.context);
    }

    public Loggable withPrettyOutput() {
        return new ReplicaSetOperationsImpl(this.rollingOperationContext.withPrettyOutput(true), this.context);
    }

    public PrettyLoggable tailingLines(int lines) {
        return new ReplicaSetOperationsImpl(this.rollingOperationContext.withTailingLines(lines), this.context);
    }

    public TailPrettyLoggable sinceTime(String timestamp) {
        return new ReplicaSetOperationsImpl(this.rollingOperationContext.withSinceTimestamp(timestamp), this.context);
    }

    public TailPrettyLoggable sinceSeconds(int seconds) {
        return new ReplicaSetOperationsImpl(this.rollingOperationContext.withSinceSeconds(seconds), this.context);
    }

    public BytesLimitTerminateTimeTailPrettyLoggable usingTimestamps() {
        return new ReplicaSetOperationsImpl(this.rollingOperationContext.withTimestamps(true), this.context);
    }
}

