/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentStrategy;
import io.fabric8.openshift.api.model.DeploymentStrategyBuilder;
import io.fabric8.openshift.api.model.DeploymentStrategyFluentImpl;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicy;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyBuilder;
import io.fabric8.openshift.api.model.DeploymentTriggerPolicyFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeploymentConfigSpecFluentImpl<A extends DeploymentConfigSpecFluent<A>>
extends BaseFluent<A>
implements DeploymentConfigSpecFluent<A> {
    private Integer minReadySeconds;
    private Boolean paused;
    private Integer replicas;
    private Integer revisionHistoryLimit;
    private Map<String, String> selector;
    private DeploymentStrategyBuilder strategy;
    private PodTemplateSpecBuilder template;
    private Boolean test;
    private ArrayList<DeploymentTriggerPolicyBuilder> triggers = new ArrayList();
    private Map<String, Object> additionalProperties;

    public DeploymentConfigSpecFluentImpl() {
    }

    public DeploymentConfigSpecFluentImpl(DeploymentConfigSpec instance) {
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPaused(instance.getPaused());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
        this.withTest(instance.getTest());
        this.withTriggers(instance.getTriggers());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    @Override
    public A withMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMinReadySeconds() {
        return this.minReadySeconds != null;
    }

    @Override
    public Boolean getPaused() {
        return this.paused;
    }

    @Override
    public A withPaused(Boolean paused) {
        this.paused = paused;
        return (A)this;
    }

    @Override
    public Boolean hasPaused() {
        return this.paused != null;
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    @Override
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasRevisionHistoryLimit() {
        return this.revisionHistoryLimit != null;
    }

    @Override
    public A addToSelector(String key, String value) {
        if (this.selector == null && key != null && value != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.selector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToSelector(Map<String, String> map) {
        if (this.selector == null && map != null) {
            this.selector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.selector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(String key) {
        if (this.selector == null) {
            return (A)this;
        }
        if (key != null && this.selector != null) {
            this.selector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromSelector(Map<String, String> map) {
        if (this.selector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.selector == null) continue;
                this.selector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getSelector() {
        return this.selector;
    }

    @Override
    public <K, V> A withSelector(Map<String, String> selector) {
        this.selector = selector == null ? null : new LinkedHashMap<String, String>(selector);
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    @Deprecated
    public DeploymentStrategy getStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    @Override
    public DeploymentStrategy buildStrategy() {
        return this.strategy != null ? this.strategy.build() : null;
    }

    @Override
    public A withStrategy(DeploymentStrategy strategy) {
        this._visitables.get("strategy").remove(this.strategy);
        if (strategy != null) {
            this.strategy = new DeploymentStrategyBuilder(strategy);
            this._visitables.get("strategy").add(this.strategy);
        } else {
            this.strategy = null;
            this._visitables.get("strategy").remove(this.strategy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategy() {
        return new StrategyNestedImpl();
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item) {
        return new StrategyNestedImpl(item);
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<A> editStrategy() {
        return this.withNewStrategyLike(this.getStrategy());
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<A> editOrNewStrategy() {
        return this.withNewStrategyLike(this.getStrategy() != null ? this.getStrategy() : new DeploymentStrategyBuilder().build());
    }

    @Override
    public DeploymentConfigSpecFluent.StrategyNested<A> editOrNewStrategyLike(DeploymentStrategy item) {
        return this.withNewStrategyLike(this.getStrategy() != null ? this.getStrategy() : item);
    }

    @Override
    @Deprecated
    public PodTemplateSpec getTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public PodTemplateSpec buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    @Override
    public A withTemplate(PodTemplateSpec template) {
        this._visitables.get("template").remove(this.template);
        if (template != null) {
            this.template = new PodTemplateSpecBuilder(template);
            this._visitables.get("template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get("template").remove(this.template);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplate() {
        return this.template != null;
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplate() {
        return new TemplateNestedImpl();
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
        return new TemplateNestedImpl(item);
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<A> editTemplate() {
        return this.withNewTemplateLike(this.getTemplate());
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : new PodTemplateSpecBuilder().build());
    }

    @Override
    public DeploymentConfigSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
        return this.withNewTemplateLike(this.getTemplate() != null ? this.getTemplate() : item);
    }

    @Override
    public Boolean getTest() {
        return this.test;
    }

    @Override
    public A withTest(Boolean test) {
        this.test = test;
        return (A)this;
    }

    @Override
    public Boolean hasTest() {
        return this.test != null;
    }

    @Override
    public A addToTriggers(Integer index, DeploymentTriggerPolicy item) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
        this._visitables.get("triggers").add(index >= 0 ? index.intValue() : this._visitables.get("triggers").size(), builder);
        this.triggers.add(index >= 0 ? index.intValue() : this.triggers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTriggers(Integer index, DeploymentTriggerPolicy item) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
        if (index < 0 || index >= this._visitables.get("triggers").size()) {
            this._visitables.get("triggers").add(builder);
        } else {
            this._visitables.get("triggers").set(index, builder);
        }
        if (index < 0 || index >= this.triggers.size()) {
            this.triggers.add(builder);
        } else {
            this.triggers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTriggers(DeploymentTriggerPolicy ... items) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.get("triggers").add(builder);
            this.triggers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTriggers(Collection<DeploymentTriggerPolicy> items) {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
        }
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.get("triggers").add(builder);
            this.triggers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTriggers(DeploymentTriggerPolicy ... items) {
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.get("triggers").remove(builder);
            if (this.triggers == null) continue;
            this.triggers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTriggers(Collection<DeploymentTriggerPolicy> items) {
        for (DeploymentTriggerPolicy item : items) {
            DeploymentTriggerPolicyBuilder builder = new DeploymentTriggerPolicyBuilder(item);
            this._visitables.get("triggers").remove(builder);
            if (this.triggers == null) continue;
            this.triggers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTriggers(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
        if (this.triggers == null) {
            return (A)this;
        }
        Iterator<DeploymentTriggerPolicyBuilder> each = this.triggers.iterator();
        Object visitables = this._visitables.get("triggers");
        while (each.hasNext()) {
            DeploymentTriggerPolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<DeploymentTriggerPolicy> getTriggers() {
        return this.triggers != null ? DeploymentConfigSpecFluentImpl.build(this.triggers) : null;
    }

    @Override
    public List<DeploymentTriggerPolicy> buildTriggers() {
        return this.triggers != null ? DeploymentConfigSpecFluentImpl.build(this.triggers) : null;
    }

    @Override
    public DeploymentTriggerPolicy buildTrigger(Integer index) {
        return this.triggers.get(index).build();
    }

    @Override
    public DeploymentTriggerPolicy buildFirstTrigger() {
        return this.triggers.get(0).build();
    }

    @Override
    public DeploymentTriggerPolicy buildLastTrigger() {
        return this.triggers.get(this.triggers.size() - 1).build();
    }

    @Override
    public DeploymentTriggerPolicy buildMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
        for (DeploymentTriggerPolicyBuilder item : this.triggers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
        for (DeploymentTriggerPolicyBuilder item : this.triggers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTriggers(List<DeploymentTriggerPolicy> triggers) {
        if (this.triggers != null) {
            this._visitables.get("triggers").removeAll(this.triggers);
        }
        if (triggers != null) {
            this.triggers = new ArrayList();
            for (DeploymentTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        } else {
            this.triggers = null;
        }
        return (A)this;
    }

    @Override
    public A withTriggers(DeploymentTriggerPolicy ... triggers) {
        if (this.triggers != null) {
            this.triggers.clear();
        }
        if (triggers != null) {
            for (DeploymentTriggerPolicy item : triggers) {
                this.addToTriggers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTriggers() {
        return this.triggers != null && !this.triggers.isEmpty();
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> addNewTrigger() {
        return new TriggersNestedImpl();
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> addNewTriggerLike(DeploymentTriggerPolicy item) {
        return new TriggersNestedImpl(-1, item);
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> setNewTriggerLike(Integer index, DeploymentTriggerPolicy item) {
        return new TriggersNestedImpl(index, item);
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> editTrigger(Integer index) {
        if (this.triggers.size() <= index) {
            throw new RuntimeException("Can't edit triggers. Index exceeds size.");
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> editFirstTrigger() {
        if (this.triggers.size() == 0) {
            throw new RuntimeException("Can't edit first triggers. The list is empty.");
        }
        return this.setNewTriggerLike(0, this.buildTrigger(0));
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> editLastTrigger() {
        int index = this.triggers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last triggers. The list is empty.");
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    @Override
    public DeploymentConfigSpecFluent.TriggersNested<A> editMatchingTrigger(Predicate<DeploymentTriggerPolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.triggers.size(); ++i) {
            if (!predicate.test(this.triggers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching triggers. No match found.");
        }
        return this.setNewTriggerLike(index, this.buildTrigger(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentConfigSpecFluentImpl that = (DeploymentConfigSpecFluentImpl)o;
        if (this.minReadySeconds != null ? !this.minReadySeconds.equals(that.minReadySeconds) : that.minReadySeconds != null) {
            return false;
        }
        if (this.paused != null ? !this.paused.equals(that.paused) : that.paused != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.revisionHistoryLimit != null ? !this.revisionHistoryLimit.equals(that.revisionHistoryLimit) : that.revisionHistoryLimit != null) {
            return false;
        }
        if (this.selector != null ? !this.selector.equals(that.selector) : that.selector != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        if (this.template != null ? !this.template.equals(that.template) : that.template != null) {
            return false;
        }
        if (this.test != null ? !this.test.equals(that.test) : that.test != null) {
            return false;
        }
        if (this.triggers != null ? !this.triggers.equals(that.triggers) : that.triggers != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.paused, this.replicas, this.revisionHistoryLimit, this.selector, this.strategy, this.template, this.test, this.triggers, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.minReadySeconds != null) {
            sb.append("minReadySeconds:");
            sb.append(this.minReadySeconds + ",");
        }
        if (this.paused != null) {
            sb.append("paused:");
            sb.append(this.paused + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.revisionHistoryLimit != null) {
            sb.append("revisionHistoryLimit:");
            sb.append(this.revisionHistoryLimit + ",");
        }
        if (this.selector != null && !this.selector.isEmpty()) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.strategy != null) {
            sb.append("strategy:");
            sb.append(this.strategy + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.test != null) {
            sb.append("test:");
            sb.append(this.test + ",");
        }
        if (this.triggers != null && !this.triggers.isEmpty()) {
            sb.append("triggers:");
            sb.append(this.triggers + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withPaused() {
        return this.withPaused(true);
    }

    @Override
    public A withTest() {
        return this.withTest(true);
    }

    class TriggersNestedImpl<N>
    extends DeploymentTriggerPolicyFluentImpl<DeploymentConfigSpecFluent.TriggersNested<N>>
    implements DeploymentConfigSpecFluent.TriggersNested<N>,
    Nested<N> {
        DeploymentTriggerPolicyBuilder builder;
        Integer index;

        TriggersNestedImpl(Integer index, DeploymentTriggerPolicy item) {
            this.index = index;
            this.builder = new DeploymentTriggerPolicyBuilder(this, item);
        }

        TriggersNestedImpl() {
            this.index = -1;
            this.builder = new DeploymentTriggerPolicyBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigSpecFluentImpl.this.setToTriggers(this.index, this.builder.build());
        }

        @Override
        public N endTrigger() {
            return this.and();
        }
    }

    class TemplateNestedImpl<N>
    extends PodTemplateSpecFluentImpl<DeploymentConfigSpecFluent.TemplateNested<N>>
    implements DeploymentConfigSpecFluent.TemplateNested<N>,
    Nested<N> {
        PodTemplateSpecBuilder builder;

        TemplateNestedImpl(PodTemplateSpec item) {
            this.builder = new PodTemplateSpecBuilder(this, item);
        }

        TemplateNestedImpl() {
            this.builder = new PodTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigSpecFluentImpl.this.withTemplate(this.builder.build());
        }

        @Override
        public N endTemplate() {
            return this.and();
        }
    }

    class StrategyNestedImpl<N>
    extends DeploymentStrategyFluentImpl<DeploymentConfigSpecFluent.StrategyNested<N>>
    implements DeploymentConfigSpecFluent.StrategyNested<N>,
    Nested<N> {
        DeploymentStrategyBuilder builder;

        StrategyNestedImpl(DeploymentStrategy item) {
            this.builder = new DeploymentStrategyBuilder(this, item);
        }

        StrategyNestedImpl() {
            this.builder = new DeploymentStrategyBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentConfigSpecFluentImpl.this.withStrategy(this.builder.build());
        }

        @Override
        public N endStrategy() {
            return this.and();
        }
    }
}

