/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.vsphere.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.vsphere.v1.MachinePool;
import io.fabric8.openshift.api.model.installer.vsphere.v1.MachinePoolBuilder;
import io.fabric8.openshift.api.model.installer.vsphere.v1.MachinePoolFluentImpl;
import io.fabric8.openshift.api.model.installer.vsphere.v1.Platform;
import io.fabric8.openshift.api.model.installer.vsphere.v1.PlatformFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PlatformFluentImpl<A extends PlatformFluent<A>>
extends BaseFluent<A>
implements PlatformFluent<A> {
    private String apiVIP;
    private String cluster;
    private String clusterOSImage;
    private String datacenter;
    private String defaultDatastore;
    private MachinePoolBuilder defaultMachinePlatform;
    private String diskType;
    private String folder;
    private String ingressVIP;
    private String network;
    private String password;
    private String resourcePool;
    private String username;
    private String vCenter;
    private Map<String, Object> additionalProperties;

    public PlatformFluentImpl() {
    }

    public PlatformFluentImpl(Platform instance) {
        this.withApiVIP(instance.getApiVIP());
        this.withCluster(instance.getCluster());
        this.withClusterOSImage(instance.getClusterOSImage());
        this.withDatacenter(instance.getDatacenter());
        this.withDefaultDatastore(instance.getDefaultDatastore());
        this.withDefaultMachinePlatform(instance.getDefaultMachinePlatform());
        this.withDiskType(instance.getDiskType());
        this.withFolder(instance.getFolder());
        this.withIngressVIP(instance.getIngressVIP());
        this.withNetwork(instance.getNetwork());
        this.withPassword(instance.getPassword());
        this.withResourcePool(instance.getResourcePool());
        this.withUsername(instance.getUsername());
        this.withVCenter(instance.getVCenter());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVIP() {
        return this.apiVIP;
    }

    @Override
    public A withApiVIP(String apiVIP) {
        this.apiVIP = apiVIP;
        return (A)this;
    }

    @Override
    public Boolean hasApiVIP() {
        return this.apiVIP != null;
    }

    @Override
    public String getCluster() {
        return this.cluster;
    }

    @Override
    public A withCluster(String cluster) {
        this.cluster = cluster;
        return (A)this;
    }

    @Override
    public Boolean hasCluster() {
        return this.cluster != null;
    }

    @Override
    public String getClusterOSImage() {
        return this.clusterOSImage;
    }

    @Override
    public A withClusterOSImage(String clusterOSImage) {
        this.clusterOSImage = clusterOSImage;
        return (A)this;
    }

    @Override
    public Boolean hasClusterOSImage() {
        return this.clusterOSImage != null;
    }

    @Override
    public String getDatacenter() {
        return this.datacenter;
    }

    @Override
    public A withDatacenter(String datacenter) {
        this.datacenter = datacenter;
        return (A)this;
    }

    @Override
    public Boolean hasDatacenter() {
        return this.datacenter != null;
    }

    @Override
    public String getDefaultDatastore() {
        return this.defaultDatastore;
    }

    @Override
    public A withDefaultDatastore(String defaultDatastore) {
        this.defaultDatastore = defaultDatastore;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultDatastore() {
        return this.defaultDatastore != null;
    }

    @Override
    @Deprecated
    public MachinePool getDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public MachinePool buildDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null ? this.defaultMachinePlatform.build() : null;
    }

    @Override
    public A withDefaultMachinePlatform(MachinePool defaultMachinePlatform) {
        this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        if (defaultMachinePlatform != null) {
            this.defaultMachinePlatform = new MachinePoolBuilder(defaultMachinePlatform);
            this._visitables.get("defaultMachinePlatform").add(this.defaultMachinePlatform);
        } else {
            this.defaultMachinePlatform = null;
            this._visitables.get("defaultMachinePlatform").remove(this.defaultMachinePlatform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMachinePlatform() {
        return this.defaultMachinePlatform != null;
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatform() {
        return new DefaultMachinePlatformNestedImpl();
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> withNewDefaultMachinePlatformLike(MachinePool item) {
        return new DefaultMachinePlatformNestedImpl(item);
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatform() {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : new MachinePoolBuilder().build());
    }

    @Override
    public PlatformFluent.DefaultMachinePlatformNested<A> editOrNewDefaultMachinePlatformLike(MachinePool item) {
        return this.withNewDefaultMachinePlatformLike(this.getDefaultMachinePlatform() != null ? this.getDefaultMachinePlatform() : item);
    }

    @Override
    public String getDiskType() {
        return this.diskType;
    }

    @Override
    public A withDiskType(String diskType) {
        this.diskType = diskType;
        return (A)this;
    }

    @Override
    public Boolean hasDiskType() {
        return this.diskType != null;
    }

    @Override
    public String getFolder() {
        return this.folder;
    }

    @Override
    public A withFolder(String folder) {
        this.folder = folder;
        return (A)this;
    }

    @Override
    public Boolean hasFolder() {
        return this.folder != null;
    }

    @Override
    public String getIngressVIP() {
        return this.ingressVIP;
    }

    @Override
    public A withIngressVIP(String ingressVIP) {
        this.ingressVIP = ingressVIP;
        return (A)this;
    }

    @Override
    public Boolean hasIngressVIP() {
        return this.ingressVIP != null;
    }

    @Override
    public String getNetwork() {
        return this.network;
    }

    @Override
    public A withNetwork(String network) {
        this.network = network;
        return (A)this;
    }

    @Override
    public Boolean hasNetwork() {
        return this.network != null;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public A withPassword(String password) {
        this.password = password;
        return (A)this;
    }

    @Override
    public Boolean hasPassword() {
        return this.password != null;
    }

    @Override
    public String getResourcePool() {
        return this.resourcePool;
    }

    @Override
    public A withResourcePool(String resourcePool) {
        this.resourcePool = resourcePool;
        return (A)this;
    }

    @Override
    public Boolean hasResourcePool() {
        return this.resourcePool != null;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    @Override
    public Boolean hasUsername() {
        return this.username != null;
    }

    @Override
    public String getVCenter() {
        return this.vCenter;
    }

    @Override
    public A withVCenter(String vCenter) {
        this.vCenter = vCenter;
        return (A)this;
    }

    @Override
    public Boolean hasVCenter() {
        return this.vCenter != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformFluentImpl that = (PlatformFluentImpl)o;
        if (this.apiVIP != null ? !this.apiVIP.equals(that.apiVIP) : that.apiVIP != null) {
            return false;
        }
        if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) {
            return false;
        }
        if (this.clusterOSImage != null ? !this.clusterOSImage.equals(that.clusterOSImage) : that.clusterOSImage != null) {
            return false;
        }
        if (this.datacenter != null ? !this.datacenter.equals(that.datacenter) : that.datacenter != null) {
            return false;
        }
        if (this.defaultDatastore != null ? !this.defaultDatastore.equals(that.defaultDatastore) : that.defaultDatastore != null) {
            return false;
        }
        if (this.defaultMachinePlatform != null ? !this.defaultMachinePlatform.equals(that.defaultMachinePlatform) : that.defaultMachinePlatform != null) {
            return false;
        }
        if (this.diskType != null ? !this.diskType.equals(that.diskType) : that.diskType != null) {
            return false;
        }
        if (this.folder != null ? !this.folder.equals(that.folder) : that.folder != null) {
            return false;
        }
        if (this.ingressVIP != null ? !this.ingressVIP.equals(that.ingressVIP) : that.ingressVIP != null) {
            return false;
        }
        if (this.network != null ? !this.network.equals(that.network) : that.network != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(that.password) : that.password != null) {
            return false;
        }
        if (this.resourcePool != null ? !this.resourcePool.equals(that.resourcePool) : that.resourcePool != null) {
            return false;
        }
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        if (this.vCenter != null ? !this.vCenter.equals(that.vCenter) : that.vCenter != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVIP, this.cluster, this.clusterOSImage, this.datacenter, this.defaultDatastore, this.defaultMachinePlatform, this.diskType, this.folder, this.ingressVIP, this.network, this.password, this.resourcePool, this.username, this.vCenter, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVIP != null) {
            sb.append("apiVIP:");
            sb.append(this.apiVIP + ",");
        }
        if (this.cluster != null) {
            sb.append("cluster:");
            sb.append(this.cluster + ",");
        }
        if (this.clusterOSImage != null) {
            sb.append("clusterOSImage:");
            sb.append(this.clusterOSImage + ",");
        }
        if (this.datacenter != null) {
            sb.append("datacenter:");
            sb.append(this.datacenter + ",");
        }
        if (this.defaultDatastore != null) {
            sb.append("defaultDatastore:");
            sb.append(this.defaultDatastore + ",");
        }
        if (this.defaultMachinePlatform != null) {
            sb.append("defaultMachinePlatform:");
            sb.append(this.defaultMachinePlatform + ",");
        }
        if (this.diskType != null) {
            sb.append("diskType:");
            sb.append(this.diskType + ",");
        }
        if (this.folder != null) {
            sb.append("folder:");
            sb.append(this.folder + ",");
        }
        if (this.ingressVIP != null) {
            sb.append("ingressVIP:");
            sb.append(this.ingressVIP + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network + ",");
        }
        if (this.password != null) {
            sb.append("password:");
            sb.append(this.password + ",");
        }
        if (this.resourcePool != null) {
            sb.append("resourcePool:");
            sb.append(this.resourcePool + ",");
        }
        if (this.username != null) {
            sb.append("username:");
            sb.append(this.username + ",");
        }
        if (this.vCenter != null) {
            sb.append("vCenter:");
            sb.append(this.vCenter + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class DefaultMachinePlatformNestedImpl<N>
    extends MachinePoolFluentImpl<PlatformFluent.DefaultMachinePlatformNested<N>>
    implements PlatformFluent.DefaultMachinePlatformNested<N>,
    Nested<N> {
        MachinePoolBuilder builder;

        DefaultMachinePlatformNestedImpl(MachinePool item) {
            this.builder = new MachinePoolBuilder(this, item);
        }

        DefaultMachinePlatformNestedImpl() {
            this.builder = new MachinePoolBuilder(this);
        }

        @Override
        public N and() {
            return (N)PlatformFluentImpl.this.withDefaultMachinePlatform(this.builder.build());
        }

        @Override
        public N endDefaultMachinePlatform() {
            return this.and();
        }
    }
}

