/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ContainerImage;
import io.fabric8.kubernetes.api.model.ContainerImageFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ContainerImageFluentImpl<A extends ContainerImageFluent<A>>
extends BaseFluent<A>
implements ContainerImageFluent<A> {
    private List<String> names = new ArrayList<String>();
    private Long sizeBytes;
    private Map<String, Object> additionalProperties;

    public ContainerImageFluentImpl() {
    }

    public ContainerImageFluentImpl(ContainerImage instance) {
        this.withNames(instance.getNames());
        this.withSizeBytes(instance.getSizeBytes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToNames(Integer index, String item) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        this.names.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNames(Integer index, String item) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        this.names.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNames(String ... items) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        for (String item : items) {
            this.names.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNames(Collection<String> items) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        for (String item : items) {
            this.names.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNames(String ... items) {
        for (String item : items) {
            if (this.names == null) continue;
            this.names.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNames(Collection<String> items) {
        for (String item : items) {
            if (this.names == null) continue;
            this.names.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public String getName(Integer index) {
        return this.names.get(index);
    }

    @Override
    public String getFirstName() {
        return this.names.get(0);
    }

    @Override
    public String getLastName() {
        return this.names.get(this.names.size() - 1);
    }

    @Override
    public String getMatchingName(Predicate<String> predicate) {
        for (String item : this.names) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingName(Predicate<String> predicate) {
        for (String item : this.names) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNames(List<String> names) {
        if (names != null) {
            this.names = new ArrayList<String>();
            for (String item : names) {
                this.addToNames(item);
            }
        } else {
            this.names = null;
        }
        return (A)this;
    }

    @Override
    public A withNames(String ... names) {
        if (this.names != null) {
            this.names.clear();
        }
        if (names != null) {
            for (String item : names) {
                this.addToNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNames() {
        return this.names != null && !this.names.isEmpty();
    }

    @Override
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    @Override
    public A withSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
        return (A)this;
    }

    @Override
    public Boolean hasSizeBytes() {
        return this.sizeBytes != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerImageFluentImpl that = (ContainerImageFluentImpl)o;
        if (this.names != null ? !this.names.equals(that.names) : that.names != null) {
            return false;
        }
        if (this.sizeBytes != null ? !this.sizeBytes.equals(that.sizeBytes) : that.sizeBytes != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.names, this.sizeBytes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.names != null && !this.names.isEmpty()) {
            sb.append("names:");
            sb.append(this.names + ",");
        }
        if (this.sizeBytes != null) {
            sb.append("sizeBytes:");
            sb.append(this.sizeBytes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

