/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleFluent;
import io.fabric8.openshift.api.model.RoleFluentImpl;

public class RoleBuilder
extends RoleFluentImpl<RoleBuilder>
implements VisitableBuilder<Role, RoleBuilder> {
    RoleFluent<?> fluent;
    Boolean validationEnabled;

    public RoleBuilder() {
        this(false);
    }

    public RoleBuilder(Boolean validationEnabled) {
        this(new Role(), validationEnabled);
    }

    public RoleBuilder(RoleFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public RoleBuilder(RoleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Role(), validationEnabled);
    }

    public RoleBuilder(RoleFluent<?> fluent, Role instance) {
        this(fluent, instance, false);
    }

    public RoleBuilder(RoleFluent<?> fluent, Role instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withRules(instance.getRules());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public RoleBuilder(Role instance) {
        this(instance, (Boolean)false);
    }

    public RoleBuilder(Role instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRules(instance.getRules());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Role build() {
        Role buildable = new Role(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRules());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

