/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupStatus;
import io.fabric8.openshift.api.model.operatorhub.v1.OperatorGroupStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OperatorGroupStatusFluentImpl<A extends OperatorGroupStatusFluent<A>>
extends BaseFluent<A>
implements OperatorGroupStatusFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private String lastUpdated;
    private List<String> namespaces = new ArrayList<String>();
    private ObjectReferenceBuilder serviceAccountRef;
    private Map<String, Object> additionalProperties;

    public OperatorGroupStatusFluentImpl() {
    }

    public OperatorGroupStatusFluentImpl(OperatorGroupStatus instance) {
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withLastUpdated(instance.getLastUpdated());
            this.withNamespaces(instance.getNamespaces());
            this.withServiceAccountRef(instance.getServiceAccountRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(Condition ... items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.conditions == null) continue;
            this.conditions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getConditions() {
        return this.conditions;
    }

    @Override
    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    @Override
    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    @Override
    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    @Override
    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public String getLastUpdated() {
        return this.lastUpdated;
    }

    @Override
    public A withLastUpdated(String lastUpdated) {
        this.lastUpdated = lastUpdated;
        return (A)this;
    }

    @Override
    public Boolean hasLastUpdated() {
        return this.lastUpdated != null;
    }

    @Override
    public A addToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNamespaces(String ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNamespaces(String ... items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    @Override
    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    @Override
    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    @Override
    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNamespaces(List<String> namespaces) {
        if (namespaces != null) {
            this.namespaces = new ArrayList<String>();
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)this;
    }

    @Override
    public A withNamespaces(String ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
            this._visitables.remove("namespaces");
        }
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    @Override
    @Deprecated
    public ObjectReference getServiceAccountRef() {
        return this.serviceAccountRef != null ? this.serviceAccountRef.build() : null;
    }

    @Override
    public ObjectReference buildServiceAccountRef() {
        return this.serviceAccountRef != null ? this.serviceAccountRef.build() : null;
    }

    @Override
    public A withServiceAccountRef(ObjectReference serviceAccountRef) {
        this._visitables.get("serviceAccountRef").remove(this.serviceAccountRef);
        if (serviceAccountRef != null) {
            this.serviceAccountRef = new ObjectReferenceBuilder(serviceAccountRef);
            this._visitables.get("serviceAccountRef").add(this.serviceAccountRef);
        } else {
            this.serviceAccountRef = null;
            this._visitables.get("serviceAccountRef").remove(this.serviceAccountRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountRef() {
        return this.serviceAccountRef != null;
    }

    @Override
    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> withNewServiceAccountRef() {
        return new ServiceAccountRefNestedImpl();
    }

    @Override
    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> withNewServiceAccountRefLike(ObjectReference item) {
        return new ServiceAccountRefNestedImpl(item);
    }

    @Override
    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> editServiceAccountRef() {
        return this.withNewServiceAccountRefLike(this.getServiceAccountRef());
    }

    @Override
    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> editOrNewServiceAccountRef() {
        return this.withNewServiceAccountRefLike(this.getServiceAccountRef() != null ? this.getServiceAccountRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public OperatorGroupStatusFluent.ServiceAccountRefNested<A> editOrNewServiceAccountRefLike(ObjectReference item) {
        return this.withNewServiceAccountRefLike(this.getServiceAccountRef() != null ? this.getServiceAccountRef() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OperatorGroupStatusFluentImpl that = (OperatorGroupStatusFluentImpl)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.lastUpdated, that.lastUpdated)) {
            return false;
        }
        if (!Objects.equals(this.namespaces, that.namespaces)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountRef, that.serviceAccountRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.lastUpdated, this.namespaces, this.serviceAccountRef, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.lastUpdated != null) {
            sb.append("lastUpdated:");
            sb.append(this.lastUpdated + ",");
        }
        if (this.namespaces != null && !this.namespaces.isEmpty()) {
            sb.append("namespaces:");
            sb.append(this.namespaces + ",");
        }
        if (this.serviceAccountRef != null) {
            sb.append("serviceAccountRef:");
            sb.append(this.serviceAccountRef + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ServiceAccountRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<OperatorGroupStatusFluent.ServiceAccountRefNested<N>>
    implements OperatorGroupStatusFluent.ServiceAccountRefNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        ServiceAccountRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ServiceAccountRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)OperatorGroupStatusFluentImpl.this.withServiceAccountRef(this.builder.build());
        }

        @Override
        public N endServiceAccountRef() {
            return this.and();
        }
    }
}

