/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.ClusterVersionSpec;
import io.fabric8.openshift.api.model.config.v1.ClusterVersionSpecFluent;
import io.fabric8.openshift.api.model.config.v1.ComponentOverride;
import io.fabric8.openshift.api.model.config.v1.ComponentOverrideBuilder;
import io.fabric8.openshift.api.model.config.v1.ComponentOverrideFluentImpl;
import io.fabric8.openshift.api.model.config.v1.Update;
import io.fabric8.openshift.api.model.config.v1.UpdateBuilder;
import io.fabric8.openshift.api.model.config.v1.UpdateFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterVersionSpecFluentImpl<A extends ClusterVersionSpecFluent<A>>
extends BaseFluent<A>
implements ClusterVersionSpecFluent<A> {
    private String channel;
    private String clusterID;
    private UpdateBuilder desiredUpdate;
    private ArrayList<ComponentOverrideBuilder> overrides = new ArrayList();
    private String upstream;
    private Map<String, Object> additionalProperties;

    public ClusterVersionSpecFluentImpl() {
    }

    public ClusterVersionSpecFluentImpl(ClusterVersionSpec instance) {
        if (instance != null) {
            this.withChannel(instance.getChannel());
            this.withClusterID(instance.getClusterID());
            this.withDesiredUpdate(instance.getDesiredUpdate());
            this.withOverrides(instance.getOverrides());
            this.withUpstream(instance.getUpstream());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getChannel() {
        return this.channel;
    }

    @Override
    public A withChannel(String channel) {
        this.channel = channel;
        return (A)this;
    }

    @Override
    public Boolean hasChannel() {
        return this.channel != null;
    }

    @Override
    public String getClusterID() {
        return this.clusterID;
    }

    @Override
    public A withClusterID(String clusterID) {
        this.clusterID = clusterID;
        return (A)this;
    }

    @Override
    public Boolean hasClusterID() {
        return this.clusterID != null;
    }

    @Override
    @Deprecated
    public Update getDesiredUpdate() {
        return this.desiredUpdate != null ? this.desiredUpdate.build() : null;
    }

    @Override
    public Update buildDesiredUpdate() {
        return this.desiredUpdate != null ? this.desiredUpdate.build() : null;
    }

    @Override
    public A withDesiredUpdate(Update desiredUpdate) {
        this._visitables.get("desiredUpdate").remove(this.desiredUpdate);
        if (desiredUpdate != null) {
            this.desiredUpdate = new UpdateBuilder(desiredUpdate);
            this._visitables.get("desiredUpdate").add(this.desiredUpdate);
        } else {
            this.desiredUpdate = null;
            this._visitables.get("desiredUpdate").remove(this.desiredUpdate);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDesiredUpdate() {
        return this.desiredUpdate != null;
    }

    @Override
    public A withNewDesiredUpdate(Boolean force, String image, String version) {
        return this.withDesiredUpdate(new Update(force, image, version));
    }

    @Override
    public ClusterVersionSpecFluent.DesiredUpdateNested<A> withNewDesiredUpdate() {
        return new DesiredUpdateNestedImpl();
    }

    @Override
    public ClusterVersionSpecFluent.DesiredUpdateNested<A> withNewDesiredUpdateLike(Update item) {
        return new DesiredUpdateNestedImpl(item);
    }

    @Override
    public ClusterVersionSpecFluent.DesiredUpdateNested<A> editDesiredUpdate() {
        return this.withNewDesiredUpdateLike(this.getDesiredUpdate());
    }

    @Override
    public ClusterVersionSpecFluent.DesiredUpdateNested<A> editOrNewDesiredUpdate() {
        return this.withNewDesiredUpdateLike(this.getDesiredUpdate() != null ? this.getDesiredUpdate() : new UpdateBuilder().build());
    }

    @Override
    public ClusterVersionSpecFluent.DesiredUpdateNested<A> editOrNewDesiredUpdateLike(Update item) {
        return this.withNewDesiredUpdateLike(this.getDesiredUpdate() != null ? this.getDesiredUpdate() : item);
    }

    @Override
    public A addToOverrides(int index, ComponentOverride item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
        if (index < 0 || index >= this.overrides.size()) {
            this._visitables.get("overrides").add(builder);
            this.overrides.add(builder);
        } else {
            this._visitables.get("overrides").add(index, builder);
            this.overrides.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToOverrides(int index, ComponentOverride item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
        if (index < 0 || index >= this.overrides.size()) {
            this._visitables.get("overrides").add(builder);
            this.overrides.add(builder);
        } else {
            this._visitables.get("overrides").set(index, builder);
            this.overrides.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToOverrides(ComponentOverride ... items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        for (ComponentOverride item : items) {
            ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
            this._visitables.get("overrides").add(builder);
            this.overrides.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToOverrides(Collection<ComponentOverride> items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList();
        }
        for (ComponentOverride item : items) {
            ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
            this._visitables.get("overrides").add(builder);
            this.overrides.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromOverrides(ComponentOverride ... items) {
        for (ComponentOverride item : items) {
            ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
            this._visitables.get("overrides").remove(builder);
            if (this.overrides == null) continue;
            this.overrides.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOverrides(Collection<ComponentOverride> items) {
        for (ComponentOverride item : items) {
            ComponentOverrideBuilder builder = new ComponentOverrideBuilder(item);
            this._visitables.get("overrides").remove(builder);
            if (this.overrides == null) continue;
            this.overrides.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromOverrides(Predicate<ComponentOverrideBuilder> predicate) {
        if (this.overrides == null) {
            return (A)this;
        }
        Iterator<ComponentOverrideBuilder> each = this.overrides.iterator();
        Object visitables = this._visitables.get("overrides");
        while (each.hasNext()) {
            ComponentOverrideBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ComponentOverride> getOverrides() {
        return this.overrides != null ? ClusterVersionSpecFluentImpl.build(this.overrides) : null;
    }

    @Override
    public List<ComponentOverride> buildOverrides() {
        return this.overrides != null ? ClusterVersionSpecFluentImpl.build(this.overrides) : null;
    }

    @Override
    public ComponentOverride buildOverride(int index) {
        return this.overrides.get(index).build();
    }

    @Override
    public ComponentOverride buildFirstOverride() {
        return this.overrides.get(0).build();
    }

    @Override
    public ComponentOverride buildLastOverride() {
        return this.overrides.get(this.overrides.size() - 1).build();
    }

    @Override
    public ComponentOverride buildMatchingOverride(Predicate<ComponentOverrideBuilder> predicate) {
        for (ComponentOverrideBuilder item : this.overrides) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOverride(Predicate<ComponentOverrideBuilder> predicate) {
        for (ComponentOverrideBuilder item : this.overrides) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOverrides(List<ComponentOverride> overrides) {
        if (this.overrides != null) {
            this._visitables.get("overrides").clear();
        }
        if (overrides != null) {
            this.overrides = new ArrayList();
            for (ComponentOverride item : overrides) {
                this.addToOverrides(item);
            }
        } else {
            this.overrides = null;
        }
        return (A)this;
    }

    @Override
    public A withOverrides(ComponentOverride ... overrides) {
        if (this.overrides != null) {
            this.overrides.clear();
            this._visitables.remove("overrides");
        }
        if (overrides != null) {
            for (ComponentOverride item : overrides) {
                this.addToOverrides(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOverrides() {
        return this.overrides != null && !this.overrides.isEmpty();
    }

    @Override
    public A addNewOverride(String group, String kind, String name, String namespace, Boolean unmanaged) {
        return this.addToOverrides(new ComponentOverride(group, kind, name, namespace, unmanaged));
    }

    @Override
    public ClusterVersionSpecFluent.OverridesNested<A> addNewOverride() {
        return new OverridesNestedImpl();
    }

    @Override
    public ClusterVersionSpecFluent.OverridesNested<A> addNewOverrideLike(ComponentOverride item) {
        return new OverridesNestedImpl(-1, item);
    }

    @Override
    public ClusterVersionSpecFluent.OverridesNested<A> setNewOverrideLike(int index, ComponentOverride item) {
        return new OverridesNestedImpl(index, item);
    }

    @Override
    public ClusterVersionSpecFluent.OverridesNested<A> editOverride(int index) {
        if (this.overrides.size() <= index) {
            throw new RuntimeException("Can't edit overrides. Index exceeds size.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    @Override
    public ClusterVersionSpecFluent.OverridesNested<A> editFirstOverride() {
        if (this.overrides.size() == 0) {
            throw new RuntimeException("Can't edit first overrides. The list is empty.");
        }
        return this.setNewOverrideLike(0, this.buildOverride(0));
    }

    @Override
    public ClusterVersionSpecFluent.OverridesNested<A> editLastOverride() {
        int index = this.overrides.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last overrides. The list is empty.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    @Override
    public ClusterVersionSpecFluent.OverridesNested<A> editMatchingOverride(Predicate<ComponentOverrideBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.overrides.size(); ++i) {
            if (!predicate.test(this.overrides.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching overrides. No match found.");
        }
        return this.setNewOverrideLike(index, this.buildOverride(index));
    }

    @Override
    public String getUpstream() {
        return this.upstream;
    }

    @Override
    public A withUpstream(String upstream) {
        this.upstream = upstream;
        return (A)this;
    }

    @Override
    public Boolean hasUpstream() {
        return this.upstream != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterVersionSpecFluentImpl that = (ClusterVersionSpecFluentImpl)o;
        if (!Objects.equals(this.channel, that.channel)) {
            return false;
        }
        if (!Objects.equals(this.clusterID, that.clusterID)) {
            return false;
        }
        if (!Objects.equals(this.desiredUpdate, that.desiredUpdate)) {
            return false;
        }
        if (!Objects.equals(this.overrides, that.overrides)) {
            return false;
        }
        if (!Objects.equals(this.upstream, that.upstream)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.channel, this.clusterID, this.desiredUpdate, this.overrides, this.upstream, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.channel != null) {
            sb.append("channel:");
            sb.append(this.channel + ",");
        }
        if (this.clusterID != null) {
            sb.append("clusterID:");
            sb.append(this.clusterID + ",");
        }
        if (this.desiredUpdate != null) {
            sb.append("desiredUpdate:");
            sb.append(this.desiredUpdate + ",");
        }
        if (this.overrides != null) {
            sb.append("overrides:");
            sb.append(this.overrides + ",");
        }
        if (this.upstream != null) {
            sb.append("upstream:");
            sb.append(this.upstream + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class OverridesNestedImpl<N>
    extends ComponentOverrideFluentImpl<ClusterVersionSpecFluent.OverridesNested<N>>
    implements ClusterVersionSpecFluent.OverridesNested<N>,
    Nested<N> {
        ComponentOverrideBuilder builder;
        int index;

        OverridesNestedImpl(int index, ComponentOverride item) {
            this.index = index;
            this.builder = new ComponentOverrideBuilder(this, item);
        }

        OverridesNestedImpl() {
            this.index = -1;
            this.builder = new ComponentOverrideBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterVersionSpecFluentImpl.this.setToOverrides(this.index, this.builder.build());
        }

        @Override
        public N endOverride() {
            return this.and();
        }
    }

    class DesiredUpdateNestedImpl<N>
    extends UpdateFluentImpl<ClusterVersionSpecFluent.DesiredUpdateNested<N>>
    implements ClusterVersionSpecFluent.DesiredUpdateNested<N>,
    Nested<N> {
        UpdateBuilder builder;

        DesiredUpdateNestedImpl(Update item) {
            this.builder = new UpdateBuilder(this, item);
        }

        DesiredUpdateNestedImpl() {
            this.builder = new UpdateBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterVersionSpecFluentImpl.this.withDesiredUpdate(this.builder.build());
        }

        @Override
        public N endDesiredUpdate() {
            return this.and();
        }
    }
}

