/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.IdentityProvider;
import io.fabric8.openshift.api.model.config.v1.IdentityProviderBuilder;
import io.fabric8.openshift.api.model.config.v1.IdentityProviderFluentImpl;
import io.fabric8.openshift.api.model.config.v1.OAuthSpec;
import io.fabric8.openshift.api.model.config.v1.OAuthSpecFluent;
import io.fabric8.openshift.api.model.config.v1.OAuthTemplates;
import io.fabric8.openshift.api.model.config.v1.OAuthTemplatesBuilder;
import io.fabric8.openshift.api.model.config.v1.OAuthTemplatesFluentImpl;
import io.fabric8.openshift.api.model.config.v1.TokenConfig;
import io.fabric8.openshift.api.model.config.v1.TokenConfigBuilder;
import io.fabric8.openshift.api.model.config.v1.TokenConfigFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OAuthSpecFluentImpl<A extends OAuthSpecFluent<A>>
extends BaseFluent<A>
implements OAuthSpecFluent<A> {
    private ArrayList<IdentityProviderBuilder> identityProviders = new ArrayList();
    private OAuthTemplatesBuilder templates;
    private TokenConfigBuilder tokenConfig;
    private Map<String, Object> additionalProperties;

    public OAuthSpecFluentImpl() {
    }

    public OAuthSpecFluentImpl(OAuthSpec instance) {
        if (instance != null) {
            this.withIdentityProviders(instance.getIdentityProviders());
            this.withTemplates(instance.getTemplates());
            this.withTokenConfig(instance.getTokenConfig());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToIdentityProviders(int index, IdentityProvider item) {
        if (this.identityProviders == null) {
            this.identityProviders = new ArrayList();
        }
        IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
        if (index < 0 || index >= this.identityProviders.size()) {
            this._visitables.get("identityProviders").add(builder);
            this.identityProviders.add(builder);
        } else {
            this._visitables.get("identityProviders").add(index, builder);
            this.identityProviders.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToIdentityProviders(int index, IdentityProvider item) {
        if (this.identityProviders == null) {
            this.identityProviders = new ArrayList();
        }
        IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
        if (index < 0 || index >= this.identityProviders.size()) {
            this._visitables.get("identityProviders").add(builder);
            this.identityProviders.add(builder);
        } else {
            this._visitables.get("identityProviders").set(index, builder);
            this.identityProviders.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIdentityProviders(IdentityProvider ... items) {
        if (this.identityProviders == null) {
            this.identityProviders = new ArrayList();
        }
        for (IdentityProvider item : items) {
            IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
            this._visitables.get("identityProviders").add(builder);
            this.identityProviders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIdentityProviders(Collection<IdentityProvider> items) {
        if (this.identityProviders == null) {
            this.identityProviders = new ArrayList();
        }
        for (IdentityProvider item : items) {
            IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
            this._visitables.get("identityProviders").add(builder);
            this.identityProviders.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIdentityProviders(IdentityProvider ... items) {
        for (IdentityProvider item : items) {
            IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
            this._visitables.get("identityProviders").remove(builder);
            if (this.identityProviders == null) continue;
            this.identityProviders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIdentityProviders(Collection<IdentityProvider> items) {
        for (IdentityProvider item : items) {
            IdentityProviderBuilder builder = new IdentityProviderBuilder(item);
            this._visitables.get("identityProviders").remove(builder);
            if (this.identityProviders == null) continue;
            this.identityProviders.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromIdentityProviders(Predicate<IdentityProviderBuilder> predicate) {
        if (this.identityProviders == null) {
            return (A)this;
        }
        Iterator<IdentityProviderBuilder> each = this.identityProviders.iterator();
        Object visitables = this._visitables.get("identityProviders");
        while (each.hasNext()) {
            IdentityProviderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<IdentityProvider> getIdentityProviders() {
        return this.identityProviders != null ? OAuthSpecFluentImpl.build(this.identityProviders) : null;
    }

    @Override
    public List<IdentityProvider> buildIdentityProviders() {
        return this.identityProviders != null ? OAuthSpecFluentImpl.build(this.identityProviders) : null;
    }

    @Override
    public IdentityProvider buildIdentityProvider(int index) {
        return this.identityProviders.get(index).build();
    }

    @Override
    public IdentityProvider buildFirstIdentityProvider() {
        return this.identityProviders.get(0).build();
    }

    @Override
    public IdentityProvider buildLastIdentityProvider() {
        return this.identityProviders.get(this.identityProviders.size() - 1).build();
    }

    @Override
    public IdentityProvider buildMatchingIdentityProvider(Predicate<IdentityProviderBuilder> predicate) {
        for (IdentityProviderBuilder item : this.identityProviders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIdentityProvider(Predicate<IdentityProviderBuilder> predicate) {
        for (IdentityProviderBuilder item : this.identityProviders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIdentityProviders(List<IdentityProvider> identityProviders) {
        if (this.identityProviders != null) {
            this._visitables.get("identityProviders").clear();
        }
        if (identityProviders != null) {
            this.identityProviders = new ArrayList();
            for (IdentityProvider item : identityProviders) {
                this.addToIdentityProviders(item);
            }
        } else {
            this.identityProviders = null;
        }
        return (A)this;
    }

    @Override
    public A withIdentityProviders(IdentityProvider ... identityProviders) {
        if (this.identityProviders != null) {
            this.identityProviders.clear();
            this._visitables.remove("identityProviders");
        }
        if (identityProviders != null) {
            for (IdentityProvider item : identityProviders) {
                this.addToIdentityProviders(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIdentityProviders() {
        return this.identityProviders != null && !this.identityProviders.isEmpty();
    }

    @Override
    public OAuthSpecFluent.IdentityProvidersNested<A> addNewIdentityProvider() {
        return new IdentityProvidersNestedImpl();
    }

    @Override
    public OAuthSpecFluent.IdentityProvidersNested<A> addNewIdentityProviderLike(IdentityProvider item) {
        return new IdentityProvidersNestedImpl(-1, item);
    }

    @Override
    public OAuthSpecFluent.IdentityProvidersNested<A> setNewIdentityProviderLike(int index, IdentityProvider item) {
        return new IdentityProvidersNestedImpl(index, item);
    }

    @Override
    public OAuthSpecFluent.IdentityProvidersNested<A> editIdentityProvider(int index) {
        if (this.identityProviders.size() <= index) {
            throw new RuntimeException("Can't edit identityProviders. Index exceeds size.");
        }
        return this.setNewIdentityProviderLike(index, this.buildIdentityProvider(index));
    }

    @Override
    public OAuthSpecFluent.IdentityProvidersNested<A> editFirstIdentityProvider() {
        if (this.identityProviders.size() == 0) {
            throw new RuntimeException("Can't edit first identityProviders. The list is empty.");
        }
        return this.setNewIdentityProviderLike(0, this.buildIdentityProvider(0));
    }

    @Override
    public OAuthSpecFluent.IdentityProvidersNested<A> editLastIdentityProvider() {
        int index = this.identityProviders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last identityProviders. The list is empty.");
        }
        return this.setNewIdentityProviderLike(index, this.buildIdentityProvider(index));
    }

    @Override
    public OAuthSpecFluent.IdentityProvidersNested<A> editMatchingIdentityProvider(Predicate<IdentityProviderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.identityProviders.size(); ++i) {
            if (!predicate.test(this.identityProviders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching identityProviders. No match found.");
        }
        return this.setNewIdentityProviderLike(index, this.buildIdentityProvider(index));
    }

    @Override
    @Deprecated
    public OAuthTemplates getTemplates() {
        return this.templates != null ? this.templates.build() : null;
    }

    @Override
    public OAuthTemplates buildTemplates() {
        return this.templates != null ? this.templates.build() : null;
    }

    @Override
    public A withTemplates(OAuthTemplates templates) {
        this._visitables.get("templates").remove(this.templates);
        if (templates != null) {
            this.templates = new OAuthTemplatesBuilder(templates);
            this._visitables.get("templates").add(this.templates);
        } else {
            this.templates = null;
            this._visitables.get("templates").remove(this.templates);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTemplates() {
        return this.templates != null;
    }

    @Override
    public OAuthSpecFluent.TemplatesNested<A> withNewTemplates() {
        return new TemplatesNestedImpl();
    }

    @Override
    public OAuthSpecFluent.TemplatesNested<A> withNewTemplatesLike(OAuthTemplates item) {
        return new TemplatesNestedImpl(item);
    }

    @Override
    public OAuthSpecFluent.TemplatesNested<A> editTemplates() {
        return this.withNewTemplatesLike(this.getTemplates());
    }

    @Override
    public OAuthSpecFluent.TemplatesNested<A> editOrNewTemplates() {
        return this.withNewTemplatesLike(this.getTemplates() != null ? this.getTemplates() : new OAuthTemplatesBuilder().build());
    }

    @Override
    public OAuthSpecFluent.TemplatesNested<A> editOrNewTemplatesLike(OAuthTemplates item) {
        return this.withNewTemplatesLike(this.getTemplates() != null ? this.getTemplates() : item);
    }

    @Override
    @Deprecated
    public TokenConfig getTokenConfig() {
        return this.tokenConfig != null ? this.tokenConfig.build() : null;
    }

    @Override
    public TokenConfig buildTokenConfig() {
        return this.tokenConfig != null ? this.tokenConfig.build() : null;
    }

    @Override
    public A withTokenConfig(TokenConfig tokenConfig) {
        this._visitables.get("tokenConfig").remove(this.tokenConfig);
        if (tokenConfig != null) {
            this.tokenConfig = new TokenConfigBuilder(tokenConfig);
            this._visitables.get("tokenConfig").add(this.tokenConfig);
        } else {
            this.tokenConfig = null;
            this._visitables.get("tokenConfig").remove(this.tokenConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTokenConfig() {
        return this.tokenConfig != null;
    }

    @Override
    public OAuthSpecFluent.TokenConfigNested<A> withNewTokenConfig() {
        return new TokenConfigNestedImpl();
    }

    @Override
    public OAuthSpecFluent.TokenConfigNested<A> withNewTokenConfigLike(TokenConfig item) {
        return new TokenConfigNestedImpl(item);
    }

    @Override
    public OAuthSpecFluent.TokenConfigNested<A> editTokenConfig() {
        return this.withNewTokenConfigLike(this.getTokenConfig());
    }

    @Override
    public OAuthSpecFluent.TokenConfigNested<A> editOrNewTokenConfig() {
        return this.withNewTokenConfigLike(this.getTokenConfig() != null ? this.getTokenConfig() : new TokenConfigBuilder().build());
    }

    @Override
    public OAuthSpecFluent.TokenConfigNested<A> editOrNewTokenConfigLike(TokenConfig item) {
        return this.withNewTokenConfigLike(this.getTokenConfig() != null ? this.getTokenConfig() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuthSpecFluentImpl that = (OAuthSpecFluentImpl)o;
        if (!Objects.equals(this.identityProviders, that.identityProviders)) {
            return false;
        }
        if (!Objects.equals(this.templates, that.templates)) {
            return false;
        }
        if (!Objects.equals(this.tokenConfig, that.tokenConfig)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.identityProviders, this.templates, this.tokenConfig, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.identityProviders != null) {
            sb.append("identityProviders:");
            sb.append(this.identityProviders + ",");
        }
        if (this.templates != null) {
            sb.append("templates:");
            sb.append(this.templates + ",");
        }
        if (this.tokenConfig != null) {
            sb.append("tokenConfig:");
            sb.append(this.tokenConfig + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TokenConfigNestedImpl<N>
    extends TokenConfigFluentImpl<OAuthSpecFluent.TokenConfigNested<N>>
    implements OAuthSpecFluent.TokenConfigNested<N>,
    Nested<N> {
        TokenConfigBuilder builder;

        TokenConfigNestedImpl(TokenConfig item) {
            this.builder = new TokenConfigBuilder(this, item);
        }

        TokenConfigNestedImpl() {
            this.builder = new TokenConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuthSpecFluentImpl.this.withTokenConfig(this.builder.build());
        }

        @Override
        public N endTokenConfig() {
            return this.and();
        }
    }

    class TemplatesNestedImpl<N>
    extends OAuthTemplatesFluentImpl<OAuthSpecFluent.TemplatesNested<N>>
    implements OAuthSpecFluent.TemplatesNested<N>,
    Nested<N> {
        OAuthTemplatesBuilder builder;

        TemplatesNestedImpl(OAuthTemplates item) {
            this.builder = new OAuthTemplatesBuilder(this, item);
        }

        TemplatesNestedImpl() {
            this.builder = new OAuthTemplatesBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuthSpecFluentImpl.this.withTemplates(this.builder.build());
        }

        @Override
        public N endTemplates() {
            return this.and();
        }
    }

    class IdentityProvidersNestedImpl<N>
    extends IdentityProviderFluentImpl<OAuthSpecFluent.IdentityProvidersNested<N>>
    implements OAuthSpecFluent.IdentityProvidersNested<N>,
    Nested<N> {
        IdentityProviderBuilder builder;
        int index;

        IdentityProvidersNestedImpl(int index, IdentityProvider item) {
            this.index = index;
            this.builder = new IdentityProviderBuilder(this, item);
        }

        IdentityProvidersNestedImpl() {
            this.index = -1;
            this.builder = new IdentityProviderBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuthSpecFluentImpl.this.setToIdentityProviders(this.index, this.builder.build());
        }

        @Override
        public N endIdentityProvider() {
            return this.and();
        }
    }
}

