/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.installer.v1.Proxy;
import io.fabric8.openshift.api.model.installer.v1.ProxyFluent;
import io.fabric8.openshift.api.model.installer.v1.ProxyFluentImpl;

public class ProxyBuilder
extends ProxyFluentImpl<ProxyBuilder>
implements VisitableBuilder<Proxy, ProxyBuilder> {
    ProxyFluent<?> fluent;
    Boolean validationEnabled;

    public ProxyBuilder() {
        this(false);
    }

    public ProxyBuilder(Boolean validationEnabled) {
        this(new Proxy(), validationEnabled);
    }

    public ProxyBuilder(ProxyFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ProxyBuilder(ProxyFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Proxy(), validationEnabled);
    }

    public ProxyBuilder(ProxyFluent<?> fluent, Proxy instance) {
        this(fluent, instance, false);
    }

    public ProxyBuilder(ProxyFluent<?> fluent, Proxy instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withHttpProxy(instance.getHttpProxy());
            fluent.withHttpsProxy(instance.getHttpsProxy());
            fluent.withNoProxy(instance.getNoProxy());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ProxyBuilder(Proxy instance) {
        this(instance, (Boolean)false);
    }

    public ProxyBuilder(Proxy instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withHttpProxy(instance.getHttpProxy());
            this.withHttpsProxy(instance.getHttpsProxy());
            this.withNoProxy(instance.getNoProxy());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Proxy build() {
        Proxy buildable = new Proxy(this.fluent.getHttpProxy(), this.fluent.getHttpsProxy(), this.fluent.getNoProxy());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

