/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfig;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.SafeTLSConfigFluentImpl;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.EmailConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValue;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.KeyValueFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EmailConfigFluentImpl<A extends EmailConfigFluent<A>>
extends BaseFluent<A>
implements EmailConfigFluent<A> {
    private String authIdentity;
    private SecretKeySelector authPassword;
    private SecretKeySelector authSecret;
    private String authUsername;
    private String from;
    private ArrayList<KeyValueBuilder> headers = new ArrayList();
    private String hello;
    private String html;
    private Boolean requireTLS;
    private Boolean sendResolved;
    private String smarthost;
    private String text;
    private SafeTLSConfigBuilder tlsConfig;
    private String to;
    private Map<String, Object> additionalProperties;

    public EmailConfigFluentImpl() {
    }

    public EmailConfigFluentImpl(EmailConfig instance) {
        if (instance != null) {
            this.withAuthIdentity(instance.getAuthIdentity());
            this.withAuthPassword(instance.getAuthPassword());
            this.withAuthSecret(instance.getAuthSecret());
            this.withAuthUsername(instance.getAuthUsername());
            this.withFrom(instance.getFrom());
            this.withHeaders(instance.getHeaders());
            this.withHello(instance.getHello());
            this.withHtml(instance.getHtml());
            this.withRequireTLS(instance.getRequireTLS());
            this.withSendResolved(instance.getSendResolved());
            this.withSmarthost(instance.getSmarthost());
            this.withText(instance.getText());
            this.withTlsConfig(instance.getTlsConfig());
            this.withTo(instance.getTo());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getAuthIdentity() {
        return this.authIdentity;
    }

    @Override
    public A withAuthIdentity(String authIdentity) {
        this.authIdentity = authIdentity;
        return (A)this;
    }

    @Override
    public Boolean hasAuthIdentity() {
        return this.authIdentity != null;
    }

    @Override
    public SecretKeySelector getAuthPassword() {
        return this.authPassword;
    }

    @Override
    public A withAuthPassword(SecretKeySelector authPassword) {
        this.authPassword = authPassword;
        return (A)this;
    }

    @Override
    public Boolean hasAuthPassword() {
        return this.authPassword != null;
    }

    @Override
    public A withNewAuthPassword(String key, String name, Boolean optional) {
        return this.withAuthPassword(new SecretKeySelector(key, name, optional));
    }

    @Override
    public SecretKeySelector getAuthSecret() {
        return this.authSecret;
    }

    @Override
    public A withAuthSecret(SecretKeySelector authSecret) {
        this.authSecret = authSecret;
        return (A)this;
    }

    @Override
    public Boolean hasAuthSecret() {
        return this.authSecret != null;
    }

    @Override
    public A withNewAuthSecret(String key, String name, Boolean optional) {
        return this.withAuthSecret(new SecretKeySelector(key, name, optional));
    }

    @Override
    public String getAuthUsername() {
        return this.authUsername;
    }

    @Override
    public A withAuthUsername(String authUsername) {
        this.authUsername = authUsername;
        return (A)this;
    }

    @Override
    public Boolean hasAuthUsername() {
        return this.authUsername != null;
    }

    @Override
    public String getFrom() {
        return this.from;
    }

    @Override
    public A withFrom(String from) {
        this.from = from;
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public A addToHeaders(int index, KeyValue item) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        KeyValueBuilder builder = new KeyValueBuilder(item);
        if (index < 0 || index >= this.headers.size()) {
            this._visitables.get("headers").add(builder);
            this.headers.add(builder);
        } else {
            this._visitables.get("headers").add(index, builder);
            this.headers.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToHeaders(int index, KeyValue item) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        KeyValueBuilder builder = new KeyValueBuilder(item);
        if (index < 0 || index >= this.headers.size()) {
            this._visitables.get("headers").add(builder);
            this.headers.add(builder);
        } else {
            this._visitables.get("headers").set(index, builder);
            this.headers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToHeaders(KeyValue ... items) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get("headers").add(builder);
            this.headers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToHeaders(Collection<KeyValue> items) {
        if (this.headers == null) {
            this.headers = new ArrayList();
        }
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get("headers").add(builder);
            this.headers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromHeaders(KeyValue ... items) {
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get("headers").remove(builder);
            if (this.headers == null) continue;
            this.headers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHeaders(Collection<KeyValue> items) {
        for (KeyValue item : items) {
            KeyValueBuilder builder = new KeyValueBuilder(item);
            this._visitables.get("headers").remove(builder);
            if (this.headers == null) continue;
            this.headers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromHeaders(Predicate<KeyValueBuilder> predicate) {
        if (this.headers == null) {
            return (A)this;
        }
        Iterator<KeyValueBuilder> each = this.headers.iterator();
        Object visitables = this._visitables.get("headers");
        while (each.hasNext()) {
            KeyValueBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<KeyValue> getHeaders() {
        return this.headers != null ? EmailConfigFluentImpl.build(this.headers) : null;
    }

    @Override
    public List<KeyValue> buildHeaders() {
        return this.headers != null ? EmailConfigFluentImpl.build(this.headers) : null;
    }

    @Override
    public KeyValue buildHeader(int index) {
        return this.headers.get(index).build();
    }

    @Override
    public KeyValue buildFirstHeader() {
        return this.headers.get(0).build();
    }

    @Override
    public KeyValue buildLastHeader() {
        return this.headers.get(this.headers.size() - 1).build();
    }

    @Override
    public KeyValue buildMatchingHeader(Predicate<KeyValueBuilder> predicate) {
        for (KeyValueBuilder item : this.headers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHeader(Predicate<KeyValueBuilder> predicate) {
        for (KeyValueBuilder item : this.headers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHeaders(List<KeyValue> headers) {
        if (this.headers != null) {
            this._visitables.get("headers").clear();
        }
        if (headers != null) {
            this.headers = new ArrayList();
            for (KeyValue item : headers) {
                this.addToHeaders(item);
            }
        } else {
            this.headers = null;
        }
        return (A)this;
    }

    @Override
    public A withHeaders(KeyValue ... headers) {
        if (this.headers != null) {
            this.headers.clear();
            this._visitables.remove("headers");
        }
        if (headers != null) {
            for (KeyValue item : headers) {
                this.addToHeaders(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHeaders() {
        return this.headers != null && !this.headers.isEmpty();
    }

    @Override
    public A addNewHeader(String key, String value) {
        return this.addToHeaders(new KeyValue(key, value));
    }

    @Override
    public EmailConfigFluent.HeadersNested<A> addNewHeader() {
        return new HeadersNestedImpl();
    }

    @Override
    public EmailConfigFluent.HeadersNested<A> addNewHeaderLike(KeyValue item) {
        return new HeadersNestedImpl(-1, item);
    }

    @Override
    public EmailConfigFluent.HeadersNested<A> setNewHeaderLike(int index, KeyValue item) {
        return new HeadersNestedImpl(index, item);
    }

    @Override
    public EmailConfigFluent.HeadersNested<A> editHeader(int index) {
        if (this.headers.size() <= index) {
            throw new RuntimeException("Can't edit headers. Index exceeds size.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    @Override
    public EmailConfigFluent.HeadersNested<A> editFirstHeader() {
        if (this.headers.size() == 0) {
            throw new RuntimeException("Can't edit first headers. The list is empty.");
        }
        return this.setNewHeaderLike(0, this.buildHeader(0));
    }

    @Override
    public EmailConfigFluent.HeadersNested<A> editLastHeader() {
        int index = this.headers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last headers. The list is empty.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    @Override
    public EmailConfigFluent.HeadersNested<A> editMatchingHeader(Predicate<KeyValueBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.headers.size(); ++i) {
            if (!predicate.test(this.headers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching headers. No match found.");
        }
        return this.setNewHeaderLike(index, this.buildHeader(index));
    }

    @Override
    public String getHello() {
        return this.hello;
    }

    @Override
    public A withHello(String hello) {
        this.hello = hello;
        return (A)this;
    }

    @Override
    public Boolean hasHello() {
        return this.hello != null;
    }

    @Override
    public String getHtml() {
        return this.html;
    }

    @Override
    public A withHtml(String html) {
        this.html = html;
        return (A)this;
    }

    @Override
    public Boolean hasHtml() {
        return this.html != null;
    }

    @Override
    public Boolean getRequireTLS() {
        return this.requireTLS;
    }

    @Override
    public A withRequireTLS(Boolean requireTLS) {
        this.requireTLS = requireTLS;
        return (A)this;
    }

    @Override
    public Boolean hasRequireTLS() {
        return this.requireTLS != null;
    }

    @Override
    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    @Override
    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)this;
    }

    @Override
    public Boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    @Override
    public String getSmarthost() {
        return this.smarthost;
    }

    @Override
    public A withSmarthost(String smarthost) {
        this.smarthost = smarthost;
        return (A)this;
    }

    @Override
    public Boolean hasSmarthost() {
        return this.smarthost != null;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public A withText(String text) {
        this.text = text;
        return (A)this;
    }

    @Override
    public Boolean hasText() {
        return this.text != null;
    }

    @Override
    @Deprecated
    public SafeTLSConfig getTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    @Override
    public SafeTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    @Override
    public A withTlsConfig(SafeTLSConfig tlsConfig) {
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
        if (tlsConfig != null) {
            this.tlsConfig = new SafeTLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get("tlsConfig").remove(this.tlsConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    @Override
    public EmailConfigFluent.TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNestedImpl();
    }

    @Override
    public EmailConfigFluent.TlsConfigNested<A> withNewTlsConfigLike(SafeTLSConfig item) {
        return new TlsConfigNestedImpl(item);
    }

    @Override
    public EmailConfigFluent.TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(this.getTlsConfig());
    }

    @Override
    public EmailConfigFluent.TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(this.getTlsConfig() != null ? this.getTlsConfig() : new SafeTLSConfigBuilder().build());
    }

    @Override
    public EmailConfigFluent.TlsConfigNested<A> editOrNewTlsConfigLike(SafeTLSConfig item) {
        return this.withNewTlsConfigLike(this.getTlsConfig() != null ? this.getTlsConfig() : item);
    }

    @Override
    public String getTo() {
        return this.to;
    }

    @Override
    public A withTo(String to) {
        this.to = to;
        return (A)this;
    }

    @Override
    public Boolean hasTo() {
        return this.to != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EmailConfigFluentImpl that = (EmailConfigFluentImpl)o;
        if (!Objects.equals(this.authIdentity, that.authIdentity)) {
            return false;
        }
        if (!Objects.equals(this.authPassword, that.authPassword)) {
            return false;
        }
        if (!Objects.equals(this.authSecret, that.authSecret)) {
            return false;
        }
        if (!Objects.equals(this.authUsername, that.authUsername)) {
            return false;
        }
        if (!Objects.equals(this.from, that.from)) {
            return false;
        }
        if (!Objects.equals(this.headers, that.headers)) {
            return false;
        }
        if (!Objects.equals(this.hello, that.hello)) {
            return false;
        }
        if (!Objects.equals(this.html, that.html)) {
            return false;
        }
        if (!Objects.equals(this.requireTLS, that.requireTLS)) {
            return false;
        }
        if (!Objects.equals(this.sendResolved, that.sendResolved)) {
            return false;
        }
        if (!Objects.equals(this.smarthost, that.smarthost)) {
            return false;
        }
        if (!Objects.equals(this.text, that.text)) {
            return false;
        }
        if (!Objects.equals(this.tlsConfig, that.tlsConfig)) {
            return false;
        }
        if (!Objects.equals(this.to, that.to)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.authIdentity, this.authPassword, this.authSecret, this.authUsername, this.from, this.headers, this.hello, this.html, this.requireTLS, this.sendResolved, this.smarthost, this.text, this.tlsConfig, this.to, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authIdentity != null) {
            sb.append("authIdentity:");
            sb.append(this.authIdentity + ",");
        }
        if (this.authPassword != null) {
            sb.append("authPassword:");
            sb.append(this.authPassword + ",");
        }
        if (this.authSecret != null) {
            sb.append("authSecret:");
            sb.append(this.authSecret + ",");
        }
        if (this.authUsername != null) {
            sb.append("authUsername:");
            sb.append(this.authUsername + ",");
        }
        if (this.from != null) {
            sb.append("from:");
            sb.append(this.from + ",");
        }
        if (this.headers != null && !this.headers.isEmpty()) {
            sb.append("headers:");
            sb.append(this.headers + ",");
        }
        if (this.hello != null) {
            sb.append("hello:");
            sb.append(this.hello + ",");
        }
        if (this.html != null) {
            sb.append("html:");
            sb.append(this.html + ",");
        }
        if (this.requireTLS != null) {
            sb.append("requireTLS:");
            sb.append(this.requireTLS + ",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved + ",");
        }
        if (this.smarthost != null) {
            sb.append("smarthost:");
            sb.append(this.smarthost + ",");
        }
        if (this.text != null) {
            sb.append("text:");
            sb.append(this.text + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(this.tlsConfig + ",");
        }
        if (this.to != null) {
            sb.append("to:");
            sb.append(this.to + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withRequireTLS() {
        return this.withRequireTLS(true);
    }

    @Override
    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    class TlsConfigNestedImpl<N>
    extends SafeTLSConfigFluentImpl<EmailConfigFluent.TlsConfigNested<N>>
    implements EmailConfigFluent.TlsConfigNested<N>,
    Nested<N> {
        SafeTLSConfigBuilder builder;

        TlsConfigNestedImpl(SafeTLSConfig item) {
            this.builder = new SafeTLSConfigBuilder(this, item);
        }

        TlsConfigNestedImpl() {
            this.builder = new SafeTLSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)EmailConfigFluentImpl.this.withTlsConfig(this.builder.build());
        }

        @Override
        public N endTlsConfig() {
            return this.and();
        }
    }

    class HeadersNestedImpl<N>
    extends KeyValueFluentImpl<EmailConfigFluent.HeadersNested<N>>
    implements EmailConfigFluent.HeadersNested<N>,
    Nested<N> {
        KeyValueBuilder builder;
        int index;

        HeadersNestedImpl(int index, KeyValue item) {
            this.index = index;
            this.builder = new KeyValueBuilder(this, item);
        }

        HeadersNestedImpl() {
            this.index = -1;
            this.builder = new KeyValueBuilder(this);
        }

        @Override
        public N and() {
            return (N)EmailConfigFluentImpl.this.setToHeaders(this.index, this.builder.build());
        }

        @Override
        public N endHeader() {
            return this.and();
        }
    }
}

