/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.CSVDescription;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.CSVDescriptionBuilder;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.CSVDescriptionFluentImpl;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.PackageChannel;
import io.fabric8.openshift.api.model.operatorhub.lifecyclemanager.v1.PackageChannelFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PackageChannelFluentImpl<A extends PackageChannelFluent<A>>
extends BaseFluent<A>
implements PackageChannelFluent<A> {
    private String currentCSV;
    private CSVDescriptionBuilder currentCSVDesc;
    private String name;
    private Map<String, Object> additionalProperties;

    public PackageChannelFluentImpl() {
    }

    public PackageChannelFluentImpl(PackageChannel instance) {
        if (instance != null) {
            this.withCurrentCSV(instance.getCurrentCSV());
            this.withCurrentCSVDesc(instance.getCurrentCSVDesc());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getCurrentCSV() {
        return this.currentCSV;
    }

    @Override
    public A withCurrentCSV(String currentCSV) {
        this.currentCSV = currentCSV;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentCSV() {
        return this.currentCSV != null;
    }

    @Override
    @Deprecated
    public CSVDescription getCurrentCSVDesc() {
        return this.currentCSVDesc != null ? this.currentCSVDesc.build() : null;
    }

    @Override
    public CSVDescription buildCurrentCSVDesc() {
        return this.currentCSVDesc != null ? this.currentCSVDesc.build() : null;
    }

    @Override
    public A withCurrentCSVDesc(CSVDescription currentCSVDesc) {
        this._visitables.get("currentCSVDesc").remove(this.currentCSVDesc);
        if (currentCSVDesc != null) {
            this.currentCSVDesc = new CSVDescriptionBuilder(currentCSVDesc);
            this._visitables.get("currentCSVDesc").add(this.currentCSVDesc);
        } else {
            this.currentCSVDesc = null;
            this._visitables.get("currentCSVDesc").remove(this.currentCSVDesc);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCurrentCSVDesc() {
        return this.currentCSVDesc != null;
    }

    @Override
    public PackageChannelFluent.CurrentCSVDescNested<A> withNewCurrentCSVDesc() {
        return new CurrentCSVDescNestedImpl();
    }

    @Override
    public PackageChannelFluent.CurrentCSVDescNested<A> withNewCurrentCSVDescLike(CSVDescription item) {
        return new CurrentCSVDescNestedImpl(item);
    }

    @Override
    public PackageChannelFluent.CurrentCSVDescNested<A> editCurrentCSVDesc() {
        return this.withNewCurrentCSVDescLike(this.getCurrentCSVDesc());
    }

    @Override
    public PackageChannelFluent.CurrentCSVDescNested<A> editOrNewCurrentCSVDesc() {
        return this.withNewCurrentCSVDescLike(this.getCurrentCSVDesc() != null ? this.getCurrentCSVDesc() : new CSVDescriptionBuilder().build());
    }

    @Override
    public PackageChannelFluent.CurrentCSVDescNested<A> editOrNewCurrentCSVDescLike(CSVDescription item) {
        return this.withNewCurrentCSVDescLike(this.getCurrentCSVDesc() != null ? this.getCurrentCSVDesc() : item);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PackageChannelFluentImpl that = (PackageChannelFluentImpl)o;
        if (!Objects.equals(this.currentCSV, that.currentCSV)) {
            return false;
        }
        if (!Objects.equals(this.currentCSVDesc, that.currentCSVDesc)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.currentCSV, this.currentCSVDesc, this.name, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.currentCSV != null) {
            sb.append("currentCSV:");
            sb.append(this.currentCSV + ",");
        }
        if (this.currentCSVDesc != null) {
            sb.append("currentCSVDesc:");
            sb.append(this.currentCSVDesc + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class CurrentCSVDescNestedImpl<N>
    extends CSVDescriptionFluentImpl<PackageChannelFluent.CurrentCSVDescNested<N>>
    implements PackageChannelFluent.CurrentCSVDescNested<N>,
    Nested<N> {
        CSVDescriptionBuilder builder;

        CurrentCSVDescNestedImpl(CSVDescription item) {
            this.builder = new CSVDescriptionBuilder(this, item);
        }

        CurrentCSVDescNestedImpl() {
            this.builder = new CSVDescriptionBuilder(this);
        }

        @Override
        public N and() {
            return (N)PackageChannelFluentImpl.this.withCurrentCSVDesc(this.builder.build());
        }

        @Override
        public N endCurrentCSVDesc() {
            return this.and();
        }
    }
}

