/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.openshift.api.model.PolicyRule;
import io.fabric8.openshift.api.model.PolicyRuleBuilder;
import io.fabric8.openshift.api.model.PolicyRuleFluent;
import io.fabric8.openshift.api.model.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class RoleFluent<A extends RoleFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ArrayList<PolicyRuleBuilder> rules = new ArrayList();
    private Map<String, Object> additionalProperties;

    public RoleFluent() {
    }

    public RoleFluent(Role instance) {
        Role role = instance = instance != null ? instance : new Role();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRules(instance.getRules());
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withRules(instance.getRules());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public A addToRules(int index, PolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").add(index, builder);
            this.rules.add(index, builder);
        }
        return (A)this;
    }

    public A setToRules(int index, PolicyRule item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").set(index, builder);
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    public A addToRules(PolicyRule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (PolicyRule item : items) {
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    public A addAllToRules(Collection<PolicyRule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (PolicyRule item : items) {
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    public A removeFromRules(PolicyRule ... items) {
        if (this.rules == null) {
            return (A)this;
        }
        for (PolicyRule item : items) {
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromRules(Collection<PolicyRule> items) {
        if (this.rules == null) {
            return (A)this;
        }
        for (PolicyRule item : items) {
            PolicyRuleBuilder builder = new PolicyRuleBuilder(item);
            this._visitables.get("rules").remove(builder);
            this.rules.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromRules(Predicate<PolicyRuleBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<PolicyRuleBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            PolicyRuleBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<PolicyRule> buildRules() {
        return this.rules != null ? RoleFluent.build(this.rules) : null;
    }

    public PolicyRule buildRule(int index) {
        return this.rules.get(index).build();
    }

    public PolicyRule buildFirstRule() {
        return this.rules.get(0).build();
    }

    public PolicyRule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    public PolicyRule buildMatchingRule(Predicate<PolicyRuleBuilder> predicate) {
        for (PolicyRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingRule(Predicate<PolicyRuleBuilder> predicate) {
        for (PolicyRuleBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withRules(List<PolicyRule> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").clear();
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (PolicyRule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    public A withRules(PolicyRule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove("rules");
        }
        if (rules != null) {
            for (PolicyRule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    public boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    public RulesNested<A> addNewRule() {
        return new RulesNested(-1, null);
    }

    public RulesNested<A> addNewRuleLike(PolicyRule item) {
        return new RulesNested(-1, item);
    }

    public RulesNested<A> setNewRuleLike(int index, PolicyRule item) {
        return new RulesNested(index, item);
    }

    public RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    public RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public RulesNested<A> editMatchingRule(Predicate<PolicyRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RoleFluent that = (RoleFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.rules, that.rules)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.rules, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.rules != null && !this.rules.isEmpty()) {
            sb.append("rules:");
            sb.append(this.rules + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RulesNested<N>
    extends PolicyRuleFluent<RulesNested<N>>
    implements Nested<N> {
        PolicyRuleBuilder builder;
        int index;

        RulesNested(int index, PolicyRule item) {
            this.index = index;
            this.builder = new PolicyRuleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RoleFluent.this.setToRules(this.index, this.builder.build());
        }

        public N endRule() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)RoleFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }
}

