/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.openshift.api.model.config.v1.IdentityProvider;
import io.fabric8.openshift.api.model.hive.v1.SelectorSyncIdentityProviderSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class SelectorSyncIdentityProviderSpecFluent<A extends SelectorSyncIdentityProviderSpecFluent<A>>
extends BaseFluent<A> {
    private LabelSelectorBuilder clusterDeploymentSelector;
    private List<IdentityProvider> identityProviders = new ArrayList<IdentityProvider>();
    private Map<String, Object> additionalProperties;

    public SelectorSyncIdentityProviderSpecFluent() {
    }

    public SelectorSyncIdentityProviderSpecFluent(SelectorSyncIdentityProviderSpec instance) {
        SelectorSyncIdentityProviderSpec selectorSyncIdentityProviderSpec = instance = instance != null ? instance : new SelectorSyncIdentityProviderSpec();
        if (instance != null) {
            this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
            this.withIdentityProviders(instance.getIdentityProviders());
            this.withClusterDeploymentSelector(instance.getClusterDeploymentSelector());
            this.withIdentityProviders(instance.getIdentityProviders());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public LabelSelector buildClusterDeploymentSelector() {
        return this.clusterDeploymentSelector != null ? this.clusterDeploymentSelector.build() : null;
    }

    public A withClusterDeploymentSelector(LabelSelector clusterDeploymentSelector) {
        this._visitables.get("clusterDeploymentSelector").remove(this.clusterDeploymentSelector);
        if (clusterDeploymentSelector != null) {
            this.clusterDeploymentSelector = new LabelSelectorBuilder(clusterDeploymentSelector);
            this._visitables.get("clusterDeploymentSelector").add(this.clusterDeploymentSelector);
        } else {
            this.clusterDeploymentSelector = null;
            this._visitables.get("clusterDeploymentSelector").remove(this.clusterDeploymentSelector);
        }
        return (A)this;
    }

    public boolean hasClusterDeploymentSelector() {
        return this.clusterDeploymentSelector != null;
    }

    public ClusterDeploymentSelectorNested<A> withNewClusterDeploymentSelector() {
        return new ClusterDeploymentSelectorNested(null);
    }

    public ClusterDeploymentSelectorNested<A> withNewClusterDeploymentSelectorLike(LabelSelector item) {
        return new ClusterDeploymentSelectorNested(item);
    }

    public ClusterDeploymentSelectorNested<A> editClusterDeploymentSelector() {
        return this.withNewClusterDeploymentSelectorLike(Optional.ofNullable(this.buildClusterDeploymentSelector()).orElse(null));
    }

    public ClusterDeploymentSelectorNested<A> editOrNewClusterDeploymentSelector() {
        return this.withNewClusterDeploymentSelectorLike(Optional.ofNullable(this.buildClusterDeploymentSelector()).orElse(new LabelSelectorBuilder().build()));
    }

    public ClusterDeploymentSelectorNested<A> editOrNewClusterDeploymentSelectorLike(LabelSelector item) {
        return this.withNewClusterDeploymentSelectorLike(Optional.ofNullable(this.buildClusterDeploymentSelector()).orElse(item));
    }

    public A addToIdentityProviders(int index, IdentityProvider item) {
        if (this.identityProviders == null) {
            this.identityProviders = new ArrayList<IdentityProvider>();
        }
        this.identityProviders.add(index, item);
        return (A)this;
    }

    public A setToIdentityProviders(int index, IdentityProvider item) {
        if (this.identityProviders == null) {
            this.identityProviders = new ArrayList<IdentityProvider>();
        }
        this.identityProviders.set(index, item);
        return (A)this;
    }

    public A addToIdentityProviders(IdentityProvider ... items) {
        if (this.identityProviders == null) {
            this.identityProviders = new ArrayList<IdentityProvider>();
        }
        for (IdentityProvider item : items) {
            this.identityProviders.add(item);
        }
        return (A)this;
    }

    public A addAllToIdentityProviders(Collection<IdentityProvider> items) {
        if (this.identityProviders == null) {
            this.identityProviders = new ArrayList<IdentityProvider>();
        }
        for (IdentityProvider item : items) {
            this.identityProviders.add(item);
        }
        return (A)this;
    }

    public A removeFromIdentityProviders(IdentityProvider ... items) {
        if (this.identityProviders == null) {
            return (A)this;
        }
        for (IdentityProvider item : items) {
            this.identityProviders.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromIdentityProviders(Collection<IdentityProvider> items) {
        if (this.identityProviders == null) {
            return (A)this;
        }
        for (IdentityProvider item : items) {
            this.identityProviders.remove(item);
        }
        return (A)this;
    }

    public List<IdentityProvider> getIdentityProviders() {
        return this.identityProviders;
    }

    public IdentityProvider getIdentityProvider(int index) {
        return this.identityProviders.get(index);
    }

    public IdentityProvider getFirstIdentityProvider() {
        return this.identityProviders.get(0);
    }

    public IdentityProvider getLastIdentityProvider() {
        return this.identityProviders.get(this.identityProviders.size() - 1);
    }

    public IdentityProvider getMatchingIdentityProvider(Predicate<IdentityProvider> predicate) {
        for (IdentityProvider item : this.identityProviders) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingIdentityProvider(Predicate<IdentityProvider> predicate) {
        for (IdentityProvider item : this.identityProviders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withIdentityProviders(List<IdentityProvider> identityProviders) {
        if (identityProviders != null) {
            this.identityProviders = new ArrayList<IdentityProvider>();
            for (IdentityProvider item : identityProviders) {
                this.addToIdentityProviders(item);
            }
        } else {
            this.identityProviders = null;
        }
        return (A)this;
    }

    public A withIdentityProviders(IdentityProvider ... identityProviders) {
        if (this.identityProviders != null) {
            this.identityProviders.clear();
            this._visitables.remove("identityProviders");
        }
        if (identityProviders != null) {
            for (IdentityProvider item : identityProviders) {
                this.addToIdentityProviders(item);
            }
        }
        return (A)this;
    }

    public boolean hasIdentityProviders() {
        return this.identityProviders != null && !this.identityProviders.isEmpty();
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SelectorSyncIdentityProviderSpecFluent that = (SelectorSyncIdentityProviderSpecFluent)o;
        if (!Objects.equals(this.clusterDeploymentSelector, that.clusterDeploymentSelector)) {
            return false;
        }
        if (!Objects.equals(this.identityProviders, that.identityProviders)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusterDeploymentSelector, this.identityProviders, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterDeploymentSelector != null) {
            sb.append("clusterDeploymentSelector:");
            sb.append(this.clusterDeploymentSelector + ",");
        }
        if (this.identityProviders != null && !this.identityProviders.isEmpty()) {
            sb.append("identityProviders:");
            sb.append(this.identityProviders + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ClusterDeploymentSelectorNested<N>
    extends LabelSelectorFluent<ClusterDeploymentSelectorNested<N>>
    implements Nested<N> {
        LabelSelectorBuilder builder;

        ClusterDeploymentSelectorNested(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SelectorSyncIdentityProviderSpecFluent.this.withClusterDeploymentSelector(this.builder.build());
        }

        public N endClusterDeploymentSelector() {
            return this.and();
        }
    }
}

