/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.installer.openstack.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.installer.openstack.v1.FailureDomain;
import io.fabric8.openshift.api.model.installer.openstack.v1.NamedPortTarget;
import io.fabric8.openshift.api.model.installer.openstack.v1.NamedPortTargetBuilder;
import io.fabric8.openshift.api.model.installer.openstack.v1.NamedPortTargetFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class FailureDomainFluent<A extends FailureDomainFluent<A>>
extends BaseFluent<A> {
    private String computeAvailabilityZone;
    private ArrayList<NamedPortTargetBuilder> portTargets = new ArrayList();
    private String storageAvailabilityZone;
    private Map<String, Object> additionalProperties;

    public FailureDomainFluent() {
    }

    public FailureDomainFluent(FailureDomain instance) {
        FailureDomain failureDomain = instance = instance != null ? instance : new FailureDomain();
        if (instance != null) {
            this.withComputeAvailabilityZone(instance.getComputeAvailabilityZone());
            this.withPortTargets(instance.getPortTargets());
            this.withStorageAvailabilityZone(instance.getStorageAvailabilityZone());
            this.withComputeAvailabilityZone(instance.getComputeAvailabilityZone());
            this.withPortTargets(instance.getPortTargets());
            this.withStorageAvailabilityZone(instance.getStorageAvailabilityZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getComputeAvailabilityZone() {
        return this.computeAvailabilityZone;
    }

    public A withComputeAvailabilityZone(String computeAvailabilityZone) {
        this.computeAvailabilityZone = computeAvailabilityZone;
        return (A)this;
    }

    public boolean hasComputeAvailabilityZone() {
        return this.computeAvailabilityZone != null;
    }

    public A addToPortTargets(int index, NamedPortTarget item) {
        if (this.portTargets == null) {
            this.portTargets = new ArrayList();
        }
        NamedPortTargetBuilder builder = new NamedPortTargetBuilder(item);
        if (index < 0 || index >= this.portTargets.size()) {
            this._visitables.get("portTargets").add(builder);
            this.portTargets.add(builder);
        } else {
            this._visitables.get("portTargets").add(index, builder);
            this.portTargets.add(index, builder);
        }
        return (A)this;
    }

    public A setToPortTargets(int index, NamedPortTarget item) {
        if (this.portTargets == null) {
            this.portTargets = new ArrayList();
        }
        NamedPortTargetBuilder builder = new NamedPortTargetBuilder(item);
        if (index < 0 || index >= this.portTargets.size()) {
            this._visitables.get("portTargets").add(builder);
            this.portTargets.add(builder);
        } else {
            this._visitables.get("portTargets").set(index, builder);
            this.portTargets.set(index, builder);
        }
        return (A)this;
    }

    public A addToPortTargets(NamedPortTarget ... items) {
        if (this.portTargets == null) {
            this.portTargets = new ArrayList();
        }
        for (NamedPortTarget item : items) {
            NamedPortTargetBuilder builder = new NamedPortTargetBuilder(item);
            this._visitables.get("portTargets").add(builder);
            this.portTargets.add(builder);
        }
        return (A)this;
    }

    public A addAllToPortTargets(Collection<NamedPortTarget> items) {
        if (this.portTargets == null) {
            this.portTargets = new ArrayList();
        }
        for (NamedPortTarget item : items) {
            NamedPortTargetBuilder builder = new NamedPortTargetBuilder(item);
            this._visitables.get("portTargets").add(builder);
            this.portTargets.add(builder);
        }
        return (A)this;
    }

    public A removeFromPortTargets(NamedPortTarget ... items) {
        if (this.portTargets == null) {
            return (A)this;
        }
        for (NamedPortTarget item : items) {
            NamedPortTargetBuilder builder = new NamedPortTargetBuilder(item);
            this._visitables.get("portTargets").remove(builder);
            this.portTargets.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPortTargets(Collection<NamedPortTarget> items) {
        if (this.portTargets == null) {
            return (A)this;
        }
        for (NamedPortTarget item : items) {
            NamedPortTargetBuilder builder = new NamedPortTargetBuilder(item);
            this._visitables.get("portTargets").remove(builder);
            this.portTargets.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPortTargets(Predicate<NamedPortTargetBuilder> predicate) {
        if (this.portTargets == null) {
            return (A)this;
        }
        Iterator<NamedPortTargetBuilder> each = this.portTargets.iterator();
        Object visitables = this._visitables.get("portTargets");
        while (each.hasNext()) {
            NamedPortTargetBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<NamedPortTarget> buildPortTargets() {
        return this.portTargets != null ? FailureDomainFluent.build(this.portTargets) : null;
    }

    public NamedPortTarget buildPortTarget(int index) {
        return this.portTargets.get(index).build();
    }

    public NamedPortTarget buildFirstPortTarget() {
        return this.portTargets.get(0).build();
    }

    public NamedPortTarget buildLastPortTarget() {
        return this.portTargets.get(this.portTargets.size() - 1).build();
    }

    public NamedPortTarget buildMatchingPortTarget(Predicate<NamedPortTargetBuilder> predicate) {
        for (NamedPortTargetBuilder item : this.portTargets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPortTarget(Predicate<NamedPortTargetBuilder> predicate) {
        for (NamedPortTargetBuilder item : this.portTargets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPortTargets(List<NamedPortTarget> portTargets) {
        if (this.portTargets != null) {
            this._visitables.get("portTargets").clear();
        }
        if (portTargets != null) {
            this.portTargets = new ArrayList();
            for (NamedPortTarget item : portTargets) {
                this.addToPortTargets(item);
            }
        } else {
            this.portTargets = null;
        }
        return (A)this;
    }

    public A withPortTargets(NamedPortTarget ... portTargets) {
        if (this.portTargets != null) {
            this.portTargets.clear();
            this._visitables.remove("portTargets");
        }
        if (portTargets != null) {
            for (NamedPortTarget item : portTargets) {
                this.addToPortTargets(item);
            }
        }
        return (A)this;
    }

    public boolean hasPortTargets() {
        return this.portTargets != null && !this.portTargets.isEmpty();
    }

    public PortTargetsNested<A> addNewPortTarget() {
        return new PortTargetsNested(-1, null);
    }

    public PortTargetsNested<A> addNewPortTargetLike(NamedPortTarget item) {
        return new PortTargetsNested(-1, item);
    }

    public PortTargetsNested<A> setNewPortTargetLike(int index, NamedPortTarget item) {
        return new PortTargetsNested(index, item);
    }

    public PortTargetsNested<A> editPortTarget(int index) {
        if (this.portTargets.size() <= index) {
            throw new RuntimeException("Can't edit portTargets. Index exceeds size.");
        }
        return this.setNewPortTargetLike(index, this.buildPortTarget(index));
    }

    public PortTargetsNested<A> editFirstPortTarget() {
        if (this.portTargets.size() == 0) {
            throw new RuntimeException("Can't edit first portTargets. The list is empty.");
        }
        return this.setNewPortTargetLike(0, this.buildPortTarget(0));
    }

    public PortTargetsNested<A> editLastPortTarget() {
        int index = this.portTargets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last portTargets. The list is empty.");
        }
        return this.setNewPortTargetLike(index, this.buildPortTarget(index));
    }

    public PortTargetsNested<A> editMatchingPortTarget(Predicate<NamedPortTargetBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.portTargets.size(); ++i) {
            if (!predicate.test(this.portTargets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching portTargets. No match found.");
        }
        return this.setNewPortTargetLike(index, this.buildPortTarget(index));
    }

    public String getStorageAvailabilityZone() {
        return this.storageAvailabilityZone;
    }

    public A withStorageAvailabilityZone(String storageAvailabilityZone) {
        this.storageAvailabilityZone = storageAvailabilityZone;
        return (A)this;
    }

    public boolean hasStorageAvailabilityZone() {
        return this.storageAvailabilityZone != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FailureDomainFluent that = (FailureDomainFluent)o;
        if (!Objects.equals(this.computeAvailabilityZone, that.computeAvailabilityZone)) {
            return false;
        }
        if (!Objects.equals(this.portTargets, that.portTargets)) {
            return false;
        }
        if (!Objects.equals(this.storageAvailabilityZone, that.storageAvailabilityZone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.computeAvailabilityZone, this.portTargets, this.storageAvailabilityZone, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.computeAvailabilityZone != null) {
            sb.append("computeAvailabilityZone:");
            sb.append(this.computeAvailabilityZone + ",");
        }
        if (this.portTargets != null && !this.portTargets.isEmpty()) {
            sb.append("portTargets:");
            sb.append(this.portTargets + ",");
        }
        if (this.storageAvailabilityZone != null) {
            sb.append("storageAvailabilityZone:");
            sb.append(this.storageAvailabilityZone + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class PortTargetsNested<N>
    extends NamedPortTargetFluent<PortTargetsNested<N>>
    implements Nested<N> {
        NamedPortTargetBuilder builder;
        int index;

        PortTargetsNested(int index, NamedPortTarget item) {
            this.index = index;
            this.builder = new NamedPortTargetBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)FailureDomainFluent.this.setToPortTargets(this.index, this.builder.build());
        }

        public N endPortTarget() {
            return this.and();
        }
    }
}

