/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.monitoring.v1.ShardStatus;
import io.fabric8.openshift.api.model.monitoring.v1.ShardStatusFluent;

public class ShardStatusBuilder
extends ShardStatusFluent<ShardStatusBuilder>
implements VisitableBuilder<ShardStatus, ShardStatusBuilder> {
    ShardStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ShardStatusBuilder() {
        this(false);
    }

    public ShardStatusBuilder(Boolean validationEnabled) {
        this(new ShardStatus(), validationEnabled);
    }

    public ShardStatusBuilder(ShardStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ShardStatusBuilder(ShardStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ShardStatus(), validationEnabled);
    }

    public ShardStatusBuilder(ShardStatusFluent<?> fluent, ShardStatus instance) {
        this(fluent, instance, false);
    }

    public ShardStatusBuilder(ShardStatusFluent<?> fluent, ShardStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        ShardStatus shardStatus = instance = instance != null ? instance : new ShardStatus();
        if (instance != null) {
            fluent.withAvailableReplicas(instance.getAvailableReplicas());
            fluent.withReplicas(instance.getReplicas());
            fluent.withShardID(instance.getShardID());
            fluent.withUnavailableReplicas(instance.getUnavailableReplicas());
            fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
            fluent.withAvailableReplicas(instance.getAvailableReplicas());
            fluent.withReplicas(instance.getReplicas());
            fluent.withShardID(instance.getShardID());
            fluent.withUnavailableReplicas(instance.getUnavailableReplicas());
            fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ShardStatusBuilder(ShardStatus instance) {
        this(instance, (Boolean)false);
    }

    public ShardStatusBuilder(ShardStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        ShardStatus shardStatus = instance = instance != null ? instance : new ShardStatus();
        if (instance != null) {
            this.withAvailableReplicas(instance.getAvailableReplicas());
            this.withReplicas(instance.getReplicas());
            this.withShardID(instance.getShardID());
            this.withUnavailableReplicas(instance.getUnavailableReplicas());
            this.withUpdatedReplicas(instance.getUpdatedReplicas());
            this.withAvailableReplicas(instance.getAvailableReplicas());
            this.withReplicas(instance.getReplicas());
            this.withShardID(instance.getShardID());
            this.withUnavailableReplicas(instance.getUnavailableReplicas());
            this.withUpdatedReplicas(instance.getUpdatedReplicas());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ShardStatus build() {
        ShardStatus buildable = new ShardStatus(this.fluent.getAvailableReplicas(), this.fluent.getReplicas(), this.fluent.getShardID(), this.fluent.getUnavailableReplicas(), this.fluent.getUpdatedReplicas());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

