/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.monitoring.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.monitoring.v1.Sigv4;
import io.fabric8.openshift.api.model.monitoring.v1.Sigv4Builder;
import io.fabric8.openshift.api.model.monitoring.v1.Sigv4Fluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfig;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigBuilder;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.HTTPConfigFluent;
import io.fabric8.openshift.api.model.monitoring.v1alpha1.SNSConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class SNSConfigFluent<A extends SNSConfigFluent<A>>
extends BaseFluent<A> {
    private String apiURL;
    private Map<String, String> attributes;
    private HTTPConfigBuilder httpConfig;
    private String message;
    private String phoneNumber;
    private Boolean sendResolved;
    private Sigv4Builder sigv4;
    private String subject;
    private String targetARN;
    private String topicARN;
    private Map<String, Object> additionalProperties;

    public SNSConfigFluent() {
    }

    public SNSConfigFluent(SNSConfig instance) {
        SNSConfig sNSConfig = instance = instance != null ? instance : new SNSConfig();
        if (instance != null) {
            this.withApiURL(instance.getApiURL());
            this.withAttributes(instance.getAttributes());
            this.withHttpConfig(instance.getHttpConfig());
            this.withMessage(instance.getMessage());
            this.withPhoneNumber(instance.getPhoneNumber());
            this.withSendResolved(instance.getSendResolved());
            this.withSigv4(instance.getSigv4());
            this.withSubject(instance.getSubject());
            this.withTargetARN(instance.getTargetARN());
            this.withTopicARN(instance.getTopicARN());
            this.withApiURL(instance.getApiURL());
            this.withAttributes(instance.getAttributes());
            this.withHttpConfig(instance.getHttpConfig());
            this.withMessage(instance.getMessage());
            this.withPhoneNumber(instance.getPhoneNumber());
            this.withSendResolved(instance.getSendResolved());
            this.withSigv4(instance.getSigv4());
            this.withSubject(instance.getSubject());
            this.withTargetARN(instance.getTargetARN());
            this.withTopicARN(instance.getTopicARN());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiURL() {
        return this.apiURL;
    }

    public A withApiURL(String apiURL) {
        this.apiURL = apiURL;
        return (A)this;
    }

    public boolean hasApiURL() {
        return this.apiURL != null;
    }

    public A addToAttributes(String key, String value) {
        if (this.attributes == null && key != null && value != null) {
            this.attributes = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.attributes.put(key, value);
        }
        return (A)this;
    }

    public A addToAttributes(Map<String, String> map) {
        if (this.attributes == null && map != null) {
            this.attributes = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.attributes.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAttributes(String key) {
        if (this.attributes == null) {
            return (A)this;
        }
        if (key != null && this.attributes != null) {
            this.attributes.remove(key);
        }
        return (A)this;
    }

    public A removeFromAttributes(Map<String, String> map) {
        if (this.attributes == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.attributes == null) continue;
                this.attributes.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public <K, V> A withAttributes(Map<String, String> attributes) {
        this.attributes = attributes == null ? null : new LinkedHashMap<String, String>(attributes);
        return (A)this;
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    public HTTPConfig buildHttpConfig() {
        return this.httpConfig != null ? this.httpConfig.build() : null;
    }

    public A withHttpConfig(HTTPConfig httpConfig) {
        this._visitables.get("httpConfig").remove(this.httpConfig);
        if (httpConfig != null) {
            this.httpConfig = new HTTPConfigBuilder(httpConfig);
            this._visitables.get("httpConfig").add(this.httpConfig);
        } else {
            this.httpConfig = null;
            this._visitables.get("httpConfig").remove(this.httpConfig);
        }
        return (A)this;
    }

    public boolean hasHttpConfig() {
        return this.httpConfig != null;
    }

    public HttpConfigNested<A> withNewHttpConfig() {
        return new HttpConfigNested(null);
    }

    public HttpConfigNested<A> withNewHttpConfigLike(HTTPConfig item) {
        return new HttpConfigNested(item);
    }

    public HttpConfigNested<A> editHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(null));
    }

    public HttpConfigNested<A> editOrNewHttpConfig() {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(new HTTPConfigBuilder().build()));
    }

    public HttpConfigNested<A> editOrNewHttpConfigLike(HTTPConfig item) {
        return this.withNewHttpConfigLike(Optional.ofNullable(this.buildHttpConfig()).orElse(item));
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public A withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return (A)this;
    }

    public boolean hasPhoneNumber() {
        return this.phoneNumber != null;
    }

    public Boolean getSendResolved() {
        return this.sendResolved;
    }

    public A withSendResolved(Boolean sendResolved) {
        this.sendResolved = sendResolved;
        return (A)this;
    }

    public boolean hasSendResolved() {
        return this.sendResolved != null;
    }

    public Sigv4 buildSigv4() {
        return this.sigv4 != null ? this.sigv4.build() : null;
    }

    public A withSigv4(Sigv4 sigv4) {
        this._visitables.get("sigv4").remove(this.sigv4);
        if (sigv4 != null) {
            this.sigv4 = new Sigv4Builder(sigv4);
            this._visitables.get("sigv4").add(this.sigv4);
        } else {
            this.sigv4 = null;
            this._visitables.get("sigv4").remove(this.sigv4);
        }
        return (A)this;
    }

    public boolean hasSigv4() {
        return this.sigv4 != null;
    }

    public Sigv4Nested<A> withNewSigv4() {
        return new Sigv4Nested(null);
    }

    public Sigv4Nested<A> withNewSigv4Like(Sigv4 item) {
        return new Sigv4Nested(item);
    }

    public Sigv4Nested<A> editSigv4() {
        return this.withNewSigv4Like(Optional.ofNullable(this.buildSigv4()).orElse(null));
    }

    public Sigv4Nested<A> editOrNewSigv4() {
        return this.withNewSigv4Like(Optional.ofNullable(this.buildSigv4()).orElse(new Sigv4Builder().build()));
    }

    public Sigv4Nested<A> editOrNewSigv4Like(Sigv4 item) {
        return this.withNewSigv4Like(Optional.ofNullable(this.buildSigv4()).orElse(item));
    }

    public String getSubject() {
        return this.subject;
    }

    public A withSubject(String subject) {
        this.subject = subject;
        return (A)this;
    }

    public boolean hasSubject() {
        return this.subject != null;
    }

    public String getTargetARN() {
        return this.targetARN;
    }

    public A withTargetARN(String targetARN) {
        this.targetARN = targetARN;
        return (A)this;
    }

    public boolean hasTargetARN() {
        return this.targetARN != null;
    }

    public String getTopicARN() {
        return this.topicARN;
    }

    public A withTopicARN(String topicARN) {
        this.topicARN = topicARN;
        return (A)this;
    }

    public boolean hasTopicARN() {
        return this.topicARN != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SNSConfigFluent that = (SNSConfigFluent)o;
        if (!Objects.equals(this.apiURL, that.apiURL)) {
            return false;
        }
        if (!Objects.equals(this.attributes, that.attributes)) {
            return false;
        }
        if (!Objects.equals(this.httpConfig, that.httpConfig)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.phoneNumber, that.phoneNumber)) {
            return false;
        }
        if (!Objects.equals(this.sendResolved, that.sendResolved)) {
            return false;
        }
        if (!Objects.equals(this.sigv4, that.sigv4)) {
            return false;
        }
        if (!Objects.equals(this.subject, that.subject)) {
            return false;
        }
        if (!Objects.equals(this.targetARN, that.targetARN)) {
            return false;
        }
        if (!Objects.equals(this.topicARN, that.topicARN)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiURL, this.attributes, this.httpConfig, this.message, this.phoneNumber, this.sendResolved, this.sigv4, this.subject, this.targetARN, this.topicARN, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiURL != null) {
            sb.append("apiURL:");
            sb.append(this.apiURL + ",");
        }
        if (this.attributes != null && !this.attributes.isEmpty()) {
            sb.append("attributes:");
            sb.append(this.attributes + ",");
        }
        if (this.httpConfig != null) {
            sb.append("httpConfig:");
            sb.append(this.httpConfig + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.phoneNumber != null) {
            sb.append("phoneNumber:");
            sb.append(this.phoneNumber + ",");
        }
        if (this.sendResolved != null) {
            sb.append("sendResolved:");
            sb.append(this.sendResolved + ",");
        }
        if (this.sigv4 != null) {
            sb.append("sigv4:");
            sb.append(this.sigv4 + ",");
        }
        if (this.subject != null) {
            sb.append("subject:");
            sb.append(this.subject + ",");
        }
        if (this.targetARN != null) {
            sb.append("targetARN:");
            sb.append(this.targetARN + ",");
        }
        if (this.topicARN != null) {
            sb.append("topicARN:");
            sb.append(this.topicARN + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withSendResolved() {
        return this.withSendResolved(true);
    }

    public class Sigv4Nested<N>
    extends Sigv4Fluent<Sigv4Nested<N>>
    implements Nested<N> {
        Sigv4Builder builder;

        Sigv4Nested(Sigv4 item) {
            this.builder = new Sigv4Builder(this, item);
        }

        @Override
        public N and() {
            return (N)SNSConfigFluent.this.withSigv4(this.builder.build());
        }

        public N endSigv4() {
            return this.and();
        }
    }

    public class HttpConfigNested<N>
    extends HTTPConfigFluent<HttpConfigNested<N>>
    implements Nested<N> {
        HTTPConfigBuilder builder;

        HttpConfigNested(HTTPConfig item) {
            this.builder = new HTTPConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)SNSConfigFluent.this.withHttpConfig(this.builder.build());
        }

        public N endHttpConfig() {
            return this.and();
        }
    }
}

